/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseProjectileAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.magic.MagicMetaKeys;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.SafetyUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.util.Vector;

public class TNTAction
extends BaseProjectileAction {
    private int size;
    private int count;
    private int fuse;
    private boolean useFire;
    private boolean breakBlocks;
    private double velocity;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.track = true;
        super.prepare(context, parameters);
        this.size = parameters.getInt("size", 6);
        this.count = parameters.getInt("count", 1);
        this.fuse = parameters.getInt("fuse", 80);
        this.useFire = parameters.getBoolean("fire", false);
        this.breakBlocks = parameters.getBoolean("break_blocks", true);
        this.velocity = parameters.getDouble("tnt_velocity", 1.0);
    }

    @Override
    public SpellResult start(CastContext context) {
        Mage mage = context.getMage();
        LivingEntity living = mage.getLivingEntity();
        MageController controller = context.getController();
        int size = (int)(mage.getRadiusMultiplier() * (float)this.size);
        Location loc = context.getEyeLocation();
        if (loc == null) {
            return SpellResult.LOCATION_REQUIRED;
        }
        if (!context.hasBreakPermission(loc.getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Random rand = new Random();
        for (int i = 0; i < this.count; ++i) {
            TNTPrimed grenade;
            Location targetLoc = loc.clone();
            if (this.count > 1) {
                targetLoc.setX(targetLoc.getX() + (double)rand.nextInt(2 * this.count) - (double)this.count);
                targetLoc.setZ(targetLoc.getZ() + (double)rand.nextInt(2 * this.count) - (double)this.count);
            }
            if ((grenade = (TNTPrimed)context.getWorld().spawnEntity(targetLoc, EntityType.PRIMED_TNT)) == null) {
                return SpellResult.FAIL;
            }
            if (living != null) {
                CompatibilityLib.getCompatibilityUtils().setTNTSource(grenade, living);
            }
            if (this.velocity > 0.0) {
                Vector aim = context.getDirection();
                SafetyUtils.setVelocity((Entity)grenade, aim.multiply(this.velocity));
            }
            grenade.setYield((float)size);
            grenade.setFuseTicks(this.fuse);
            grenade.setIsIncendiary(this.useFire);
            if (!this.breakBlocks) {
                CompatibilityLib.getEntityMetadataUtils().setBoolean((Entity)grenade, MagicMetaKeys.CANCEL_EXPLOSION_BLOCKS, true);
            }
            this.track(context, (Entity)grenade);
        }
        return this.checkTracking(context);
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("size");
        parameters.add("count");
        parameters.add("fuse");
        parameters.add("fire");
        parameters.add("break_blocks");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("fire") || parameterKey.equals("break_blocks")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("size") || parameterKey.equals("count") || parameterKey.equals("fuse")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresBuildPermission() {
        return this.useFire;
    }

    @Override
    public boolean requiresBreakPermission() {
        return this.breakBlocks;
    }
}

