/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.item.InventorySlot;
import com.elmakers.mine.bukkit.utility.ColorHD;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class ColorItemAction
extends BaseSpellAction {
    private List<InventorySlot> slots;
    private ColorHD color;
    private boolean useWand;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        ConfigurationSection colorSection;
        super.prepare(context, parameters);
        List<String> slots = ConfigurationUtils.getStringList(parameters, "slots");
        String slot = parameters.getString("slot");
        if (slot != null && !slot.isEmpty()) {
            if (slots == null) {
                slots = new ArrayList<String>();
            }
            slots.add(slot);
        }
        if (slots != null) {
            this.slots = new ArrayList<InventorySlot>();
            for (String slotKey : slots) {
                InventorySlot inventorySlot = InventorySlot.parse(slotKey);
                if (inventorySlot != null) {
                    this.slots.add(inventorySlot);
                    continue;
                }
                context.getLogger().warning("Invalid slot in ColorItem action: " + slotKey);
            }
        }
        this.color = (colorSection = parameters.getConfigurationSection("color")) != null ? new ColorHD(colorSection) : new ColorHD(parameters.getString("color"));
        this.useWand = parameters.getBoolean("color_wand");
    }

    @Override
    public SpellResult perform(CastContext context) {
        Wand wand;
        boolean colored = false;
        if (this.useWand && (wand = context.getWand()) != null && this.color(context, wand.getItem())) {
            colored = true;
        }
        if (this.slots == null || this.slots.isEmpty()) {
            return colored ? SpellResult.CAST : SpellResult.NO_TARGET;
        }
        Entity entity = context.getTargetEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)entity;
            EntityEquipment equipment = li.getEquipment();
            if (equipment == null) {
                return SpellResult.NO_TARGET;
            }
            for (InventorySlot slot : this.slots) {
                ItemStack slotItem = slot.getItem(equipment);
                if (!this.color(context, slotItem)) continue;
                colored = true;
                slot.setItem(equipment, slotItem);
            }
            return colored ? SpellResult.CAST : SpellResult.NO_TARGET;
        }
        if (entity == null || !(entity instanceof Item)) {
            return SpellResult.NO_TARGET;
        }
        Item item = (Item)entity;
        ItemStack itemStack = item.getItemStack();
        if (this.color(context, itemStack)) {
            colored = true;
        }
        return colored ? SpellResult.CAST : SpellResult.NO_TARGET;
    }

    protected boolean color(CastContext context, ItemStack itemStack) {
        if (CompatibilityLib.getItemUtils().isEmpty(itemStack)) {
            return false;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (!(meta instanceof LeatherArmorMeta)) {
            return false;
        }
        Wand wand = context.getController().getIfWand(itemStack);
        LeatherArmorMeta leatherMeta = (LeatherArmorMeta)meta;
        leatherMeta.setColor(this.color.getColor());
        itemStack.setItemMeta((ItemMeta)leatherMeta);
        if (wand != null) {
            wand.setIcon(new MaterialAndData(itemStack));
        }
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

