/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.populator.builtin;

import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.automata.Automaton;
import com.elmakers.mine.bukkit.utility.random.RandomUtils;
import com.elmakers.mine.bukkit.utility.random.WeightedPair;
import com.elmakers.mine.bukkit.world.BlockResult;
import com.elmakers.mine.bukkit.world.populator.MagicBlockPopulator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class AutomatonPopulator
extends MagicBlockPopulator {
    private MaterialSet replace;
    private Deque<WeightedPair<String>> automatonProbability = new ArrayDeque<WeightedPair<String>>();
    private ConfigurationSection parameters;

    @Override
    public boolean onLoad(ConfigurationSection parameters) {
        RandomUtils.populateStringProbabilityMap(this.automatonProbability, parameters, "automaton");
        this.parameters = parameters.getConfigurationSection("automaton_parameters");
        this.replace = this.controller.getMaterialSetManager().fromConfig(parameters.getString("replace"));
        String message = "Creating automata " + StringUtils.join(RandomUtils.getValues(this.automatonProbability), (String)",");
        if (this.replace != null) {
            message = message + " on generation of " + StringUtils.join(this.replace.getMaterials(), (String)",");
        }
        this.logBlockRule(message);
        return !this.automatonProbability.isEmpty();
    }

    @Override
    public BlockResult populate(Block block, Random random) {
        if (this.replace != null && !this.replace.testBlock(block)) {
            return BlockResult.SKIP;
        }
        String automatonKey = (String)RandomUtils.weightedRandom(this.automatonProbability);
        if (automatonKey.equalsIgnoreCase("none")) {
            return BlockResult.SKIP;
        }
        try {
            BlockResult result = BlockResult.valueOf(automatonKey.toUpperCase());
            return result;
        }
        catch (Exception result) {
            Location location = block.getLocation();
            Automaton automaton = this.controller.addAutomaton(location, automatonKey, null, null, this.parameters);
            String message = " automaton: " + automatonKey + " at " + location.getWorld().getName() + "," + location.toVector();
            message = automaton == null ? "Failed to create" + message : "Created" + message;
            this.controller.info(message);
            return automaton == null ? BlockResult.SKIP : BlockResult.REMOVE_DROPS;
        }
    }
}

