/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base.entity;

import com.elmakers.mine.bukkit.entity.EntityExtraData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class EntityArmorStandData
extends EntityExtraData {
    public ItemStack itemInHand;
    public ItemStack boots;
    public ItemStack leggings;
    public ItemStack chestplate;
    public ItemStack helmet;
    public EulerAngle bodyPose;
    public EulerAngle leftArmPose;
    public EulerAngle rightArmPose;
    public EulerAngle leftLegPose;
    public EulerAngle rightLegPose;
    public EulerAngle headPose;
    public boolean isMarker;
    public boolean hasGravity;
    public boolean isVisible;
    public boolean hasArms;
    public boolean isSmall;
    public boolean hasBasePlate;
    public int disabledSlots;

    public EntityArmorStandData() {
    }

    public EntityArmorStandData(ArmorStand armorStand) {
        EntityEquipment equipment = armorStand.getEquipment();
        this.itemInHand = equipment.getItemInMainHand();
        if (this.itemInHand != null) {
            this.itemInHand = this.itemInHand.clone();
        }
        this.boots = equipment.getBoots();
        if (this.boots != null) {
            this.boots = this.boots.clone();
        }
        this.leggings = equipment.getLeggings();
        if (this.leggings != null) {
            this.leggings = this.leggings.clone();
        }
        this.chestplate = equipment.getChestplate();
        if (this.chestplate != null) {
            this.chestplate = this.chestplate.clone();
        }
        this.helmet = equipment.getHelmet();
        if (this.helmet != null) {
            this.helmet = this.helmet.clone();
        }
        this.bodyPose = armorStand.getBodyPose();
        this.leftArmPose = armorStand.getLeftArmPose();
        this.rightArmPose = armorStand.getRightArmPose();
        this.leftLegPose = armorStand.getLeftLegPose();
        this.rightLegPose = armorStand.getRightLegPose();
        this.headPose = armorStand.getHeadPose();
        this.hasGravity = armorStand.hasGravity();
        this.isVisible = armorStand.isVisible();
        this.hasArms = armorStand.hasArms();
        this.isSmall = armorStand.isSmall();
        this.hasBasePlate = armorStand.hasBasePlate();
        this.isMarker = armorStand.isMarker();
        this.disabledSlots = EntityArmorStandData.getPlatform().getCompatibilityUtils().getDisabledSlots(armorStand);
    }

    public EntityArmorStandData(ConfigurationSection parameters) {
        this.isSmall = parameters.getBoolean("small", false);
        this.isVisible = !parameters.getBoolean("invisible", false);
        this.hasBasePlate = !parameters.getBoolean("baseplate", true);
        this.hasGravity = parameters.getBoolean("gravity", true);
        this.isMarker = parameters.getBoolean("marker", false);
        this.hasArms = parameters.getBoolean("arms", false);
        this.disabledSlots = parameters.getInt("disabled_slots", 0);
    }

    @Override
    public void apply(Entity entity) {
        if (!(entity instanceof ArmorStand)) {
            return;
        }
        ArmorStand armorStand = (ArmorStand)entity;
        EntityEquipment equipment = armorStand.getEquipment();
        equipment.setItemInMainHand(this.itemInHand);
        equipment.setBoots(this.boots);
        equipment.setLeggings(this.leggings);
        equipment.setChestplate(this.chestplate);
        equipment.setHelmet(this.helmet);
        if (this.bodyPose != null) {
            armorStand.setBodyPose(this.bodyPose);
        }
        if (this.leftArmPose != null) {
            armorStand.setLeftArmPose(this.leftArmPose);
        }
        if (this.rightArmPose != null) {
            armorStand.setRightArmPose(this.rightArmPose);
        }
        if (this.leftLegPose != null) {
            armorStand.setLeftLegPose(this.leftLegPose);
        }
        if (this.rightLegPose != null) {
            armorStand.setRightLegPose(this.rightLegPose);
        }
        if (this.headPose != null) {
            armorStand.setHeadPose(this.headPose);
        }
        armorStand.setGravity(this.hasGravity);
        armorStand.setVisible(this.isVisible);
        armorStand.setArms(this.hasArms);
        armorStand.setSmall(this.isSmall);
        armorStand.setBasePlate(this.hasBasePlate);
        armorStand.setMarker(this.isMarker);
        EntityArmorStandData.getPlatform().getCompatibilityUtils().setDisabledSlots(armorStand, this.disabledSlots);
    }
}

