/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MagicRecipe {
    private String outputKey;
    private Material outputType;
    private Material substitue;
    private String outputItemType;
    private String group;
    private boolean ignoreDamage;
    private boolean disableDefaultRecipe;
    private ShapedRecipe recipe;
    private Map<Character, ItemData> ingredients = new HashMap<Character, ItemData>();
    private final MagicController controller;
    private final String key;
    private boolean autoDiscover = false;
    private boolean locked = false;
    private List<String> discover = null;
    public static boolean FIRST_REGISTER = true;

    public MagicRecipe(String key, MagicController controller) {
        this.key = key;
        this.controller = controller;
    }

    public boolean load(ConfigurationSection configuration) {
        boolean isVanillaRecipe;
        this.outputKey = configuration.getString("output");
        if (this.outputKey == null || this.outputKey.isEmpty()) {
            this.outputKey = this.key;
        }
        this.substitue = ConfigurationUtils.getMaterial(configuration, "substitute", null);
        this.disableDefaultRecipe = configuration.getBoolean("disable_default", false);
        this.group = configuration.getString("group", "");
        this.ignoreDamage = configuration.getBoolean("ignore_damage", false);
        this.autoDiscover = configuration.getBoolean("auto_discover", false);
        this.locked = configuration.getBoolean("locked", false);
        this.discover = ConfigurationUtils.getStringList(configuration, "discover");
        this.outputItemType = configuration.getString("output_type", "item");
        ItemStack item = null;
        if (this.outputItemType.equalsIgnoreCase("wand")) {
            Wand wand;
            Wand wand2 = wand = !this.outputKey.isEmpty() ? this.controller.createWand(this.outputKey) : null;
            if (wand != null) {
                item = wand.getItem();
            } else {
                this.controller.getLogger().warning("Unable to load recipe output wand: " + this.outputKey);
            }
        } else if (this.outputItemType.equalsIgnoreCase("spell")) {
            item = this.controller.createSpellItem(this.outputKey);
        } else if (this.outputItemType.equalsIgnoreCase("brush")) {
            item = this.controller.createBrushItem(this.outputKey);
        } else if (this.outputItemType.equalsIgnoreCase("item")) {
            item = this.controller.createItem(this.outputKey);
        }
        if (item == null) {
            this.controller.getLogger().warning("Unknown output for recipe " + this.key + ": " + this.outputKey);
            return false;
        }
        String vanillaItemKey = configuration.getString("vanilla");
        boolean bl = isVanillaRecipe = vanillaItemKey != null && !vanillaItemKey.isEmpty() && !vanillaItemKey.equalsIgnoreCase("false");
        if (isVanillaRecipe) {
            ItemStack vanillaItem = item;
            if (!vanillaItemKey.equalsIgnoreCase("true") && (vanillaItem = this.controller.createItem(vanillaItemKey)) == null) {
                this.controller.getLogger().warning("Crafting recipe " + this.key + " specifies a vanilla recipe with an invalid item: " + vanillaItemKey);
                vanillaItem = item;
            }
            this.outputType = item.getType();
            List recipes = this.controller.getPlugin().getServer().getRecipesFor(vanillaItem);
            if (recipes != null && !recipes.isEmpty()) {
                Recipe recipe;
                if (recipes.size() > 1) {
                    this.controller.getLogger().warning("Crafting recipe " + this.key + " specifies a vanilla recipe, but more than one recipe was found for: " + this.outputKey + ". Only one version will be overridden.");
                }
                if ((recipe = (Recipe)recipes.get(0)) instanceof ShapedRecipe) {
                    ShapedRecipe copyRecipe = (ShapedRecipe)recipe;
                    this.recipe = CompatibilityLib.getCompatibilityUtils().createShapedRecipe(this.key, item);
                    this.recipe.shape(copyRecipe.getShape());
                    for (Map.Entry entry : copyRecipe.getIngredientMap().entrySet()) {
                        char ingredientKey = ((Character)entry.getKey()).charValue();
                        ItemStack input = (ItemStack)entry.getValue();
                        if (CompatibilityLib.getItemUtils().isEmpty(input)) {
                            input = new ItemStack(Material.AIR);
                        }
                        ItemData ingredient = this.controller.createItemData(input);
                        this.ingredients.put(Character.valueOf(ingredientKey), ingredient);
                        if (CompatibilityLib.getCompatibilityUtils().setRecipeIngredient(this.recipe, ingredientKey, ingredient.getItemStack(1), this.ignoreDamage)) continue;
                        this.outputType = null;
                        this.controller.getLogger().warning("Unable to set recipe ingredient from vanilla ingredient: " + input);
                        return false;
                    }
                } else {
                    this.controller.getLogger().warning("Crafting recipe " + this.key + " specifies a shapeless vanilla recipe: " + this.outputKey);
                }
            } else {
                this.controller.getLogger().warning("Crafting recipe " + this.key + " specifies a vanilla recipe, but no recipe was found for: " + this.outputKey);
            }
        } else {
            this.outputType = item.getType();
            ShapedRecipe shaped = CompatibilityLib.getCompatibilityUtils().createShapedRecipe(this.key, item);
            ArrayList<String> rows = new ArrayList<String>();
            for (int i = 1; i <= 3; ++i) {
                String recipeRow = configuration.getString("row_" + i, "");
                if (recipeRow.length() <= 0) continue;
                rows.add(recipeRow);
            }
            if (rows.size() > 0) {
                shaped = shaped.shape(rows.toArray(new String[0]));
                ConfigurationSection materials = configuration.getConfigurationSection("ingredients");
                if (materials == null) {
                    materials = configuration.getConfigurationSection("materials");
                }
                Set keys = materials.getKeys(false);
                for (String key : keys) {
                    String materialKey = materials.getString(key);
                    ItemData ingredient = this.controller.getOrCreateItem(materialKey);
                    if (ingredient == null) {
                        this.outputType = null;
                        this.controller.getLogger().warning("Invalid recipe ingredient " + materialKey);
                        return false;
                    }
                    if (!CompatibilityLib.getCompatibilityUtils().setRecipeIngredient(shaped, key.charAt(0), ingredient.getItemStack(1), this.ignoreDamage)) {
                        this.outputType = null;
                        this.controller.getLogger().warning("Unable to set recipe ingredient " + materialKey);
                        return false;
                    }
                    this.ingredients.put(Character.valueOf(key.charAt(0)), ingredient);
                }
                this.recipe = shaped;
            }
        }
        if (this.recipe != null && this.group != null && !this.group.isEmpty()) {
            CompatibilityLib.getCompatibilityUtils().setRecipeGroup(this.recipe, this.group);
        }
        return this.outputType != null;
    }

    public void unregister(Plugin plugin) {
        boolean canRemoveRecipes = CompatibilityLib.getCompatibilityUtils().canRemoveRecipes();
        if (this.recipe != null && !FIRST_REGISTER && canRemoveRecipes) {
            CompatibilityLib.getCompatibilityUtils().removeRecipe(this.key);
        }
    }

    public void preregister(Plugin plugin) {
        boolean canRemoveRecipes = CompatibilityLib.getCompatibilityUtils().canRemoveRecipes();
        if (this.disableDefaultRecipe && canRemoveRecipes) {
            int disabled = 0;
            List existing = plugin.getServer().getRecipesFor(new ItemStack(this.outputType));
            for (Recipe recipe : existing) {
                CompatibilityLib.getCompatibilityUtils().removeRecipe(recipe);
                ++disabled;
            }
            if (disabled > 0) {
                plugin.getLogger().info("Disabled " + disabled + " default crafting recipe(s) for " + this.outputType);
            }
        }
    }

    public void register(MagicController controller, Plugin plugin) {
        boolean canRemoveRecipes = CompatibilityLib.getCompatibilityUtils().canRemoveRecipes();
        if (this.recipe != null) {
            List existing;
            if (!FIRST_REGISTER && !canRemoveRecipes && (existing = plugin.getServer().getRecipesFor(this.craft())).size() > 0) {
                return;
            }
            controller.info("Adding crafting recipe for " + this.outputKey);
            try {
                plugin.getServer().addRecipe((Recipe)this.recipe);
            }
            catch (Exception ex) {
                plugin.getLogger().log(Level.WARNING, "Failed to add recipe", ex);
            }
        }
    }

    public Material getOutputType() {
        return this.outputType;
    }

    public Material getSubstitute() {
        return this.substitue;
    }

    @Nullable
    public ItemStack craft() {
        if (this.outputKey == null) {
            return null;
        }
        Object item = this.outputItemType.equalsIgnoreCase("wand") ? (this.outputKey != null && !this.outputKey.isEmpty() ? this.controller.createWand(this.outputKey).getItem() : null) : (this.outputItemType.equalsIgnoreCase("spell") ? this.controller.createSpellItem(this.outputKey) : (this.outputItemType.equalsIgnoreCase("brush") ? this.controller.createBrushItem(this.outputKey) : (this.outputItemType.equalsIgnoreCase("item") ? this.controller.createItem(this.outputKey) : null)));
        return item;
    }

    public boolean isSameRecipe(Recipe matchRecipe) {
        return CompatibilityLib.getCompatibilityUtils().isSameKey((Plugin)this.controller.getPlugin(), this.getKey(), matchRecipe);
    }

    public MatchType getMatchType(Recipe matchRecipe, ItemStack[] matrix) {
        ItemStack ingredient;
        int i;
        int height;
        if (this.recipe == null || matrix.length < 4) {
            return MatchType.NONE;
        }
        if (!CompatibilityLib.getCompatibilityUtils().isLegacyRecipes()) {
            return this.isSameRecipe(matchRecipe) ? MatchType.MATCH : MatchType.NONE;
        }
        int width = height = (int)Math.sqrt(matrix.length);
        boolean[] rows = new boolean[width];
        boolean[] columns = new boolean[height];
        block0: for (int matrixRow = 0; matrixRow < height; ++matrixRow) {
            for (int matrixColumn = 0; matrixColumn < width; ++matrixColumn) {
                i = matrixRow * height + matrixColumn;
                ingredient = matrix[i];
                if (ingredient == null || ingredient.getType() == Material.AIR) continue;
                rows[matrixRow] = true;
                continue block0;
            }
        }
        block2: for (int matrixColumn = 0; matrixColumn < width; ++matrixColumn) {
            for (int matrixRow = 0; matrixRow < height; ++matrixRow) {
                i = matrixRow * width + matrixColumn;
                ingredient = matrix[i];
                if (ingredient == null || ingredient.getType() == Material.AIR) continue;
                columns[matrixColumn] = true;
                continue block2;
            }
        }
        String[] shape = this.recipe.getShape();
        if (shape == null || shape.length < 1) {
            return MatchType.NONE;
        }
        int shapeRow = 0;
        for (int matrixRow = 0; matrixRow < height; ++matrixRow) {
            if (!rows[matrixRow]) continue;
            int shapeColumn = 0;
            for (int matrixColumn = 0; matrixColumn < width; ++matrixColumn) {
                if (!columns[matrixColumn]) continue;
                if (shapeRow >= shape.length) {
                    return MatchType.NONE;
                }
                String row = shape[shapeRow];
                char charAt = ' ';
                if (shapeColumn >= row.length()) {
                    return MatchType.NONE;
                }
                charAt = row.charAt(shapeColumn);
                ItemData item = this.ingredients.get(Character.valueOf(charAt));
                int i2 = matrixRow * width + matrixColumn;
                ItemStack ingredient2 = matrix[i2];
                if (ingredient2 != null && ingredient2.getType() == Material.AIR) {
                    ingredient2 = null;
                }
                if (item == null && ingredient2 == null) {
                    ++shapeColumn;
                    continue;
                }
                if (item == null && ingredient2 != null) {
                    return MatchType.NONE;
                }
                if (ingredient2 == null && item != null) {
                    return MatchType.NONE;
                }
                if (ingredient2.getType() != item.getType()) {
                    return MatchType.NONE;
                }
                if (!this.ignoreDamage && ingredient2.getDurability() != item.getDurability()) {
                    return MatchType.NONE;
                }
                ItemMeta meta = item.getItemMeta();
                if (meta != null) {
                    ItemStack compareItem = item.getItemStack();
                    ItemStack ingredientItem = ingredient2;
                    if (this.ignoreDamage && compareItem.getDurability() != ingredientItem.getDurability()) {
                        ingredientItem = ingredientItem.clone();
                        ingredientItem.setDurability(compareItem.getDurability());
                    }
                    if (!this.controller.itemsAreEqual(ingredientItem, compareItem)) {
                        return MatchType.PARTIAL;
                    }
                }
                ++shapeColumn;
            }
            ++shapeRow;
        }
        return MatchType.MATCH;
    }

    public void crafted(HumanEntity entity, MageController controller) {
        if (this.discover == null) {
            return;
        }
        for (String key : this.discover) {
            if (!controller.hasPermission((Entity)entity, "Magic.craft." + key)) continue;
            CompatibilityLib.getCompatibilityUtils().discoverRecipe(entity, key);
        }
    }

    public String getKey() {
        return this.key;
    }

    public boolean isAutoDiscover() {
        return this.autoDiscover;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public static enum MatchType {
        NONE,
        MATCH,
        PARTIAL;

    }
}

