/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CheckAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.item.InventorySlot;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CheckInventoryAction
extends CheckAction {
    private ItemStack item;
    private InventorySlot slot;
    private Collection<Enchantment> allowedEnchantments;
    private Collection<Enchantment> blockedEnchantments;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        String slotName;
        super.prepare(context, parameters);
        String itemKey = parameters.getString("item");
        if (itemKey != null && !itemKey.isEmpty()) {
            this.item = context.getController().createItem(itemKey);
            if (this.item == null) {
                context.getLogger().warning("Invalid item: " + itemKey);
            }
        }
        if ((slotName = parameters.getString("slot")) != null && !slotName.isEmpty()) {
            this.slot = InventorySlot.parse(slotName);
            if (this.slot == null) {
                context.getLogger().warning("Invalid slot in CheckInventory action: " + slotName);
            }
        }
        this.allowedEnchantments = this.parseEnchantmentList(context, parameters, "allowed_enchantments");
        this.blockedEnchantments = this.parseEnchantmentList(context, parameters, "blocked_enchantments");
    }

    @Nullable
    private Collection<Enchantment> parseEnchantmentList(CastContext context, ConfigurationSection parameters, String key) {
        ArrayList<Enchantment> enchantments = null;
        List keys = parameters.getStringList(key);
        if (keys != null && !keys.isEmpty()) {
            enchantments = new ArrayList<Enchantment>();
            CompatibilityUtils compatibilityUtils = CompatibilityLib.getCompatibilityUtils();
            for (String enchantmentKey : keys) {
                Enchantment enchantment = compatibilityUtils.getEnchantmentByKey(enchantmentKey);
                if (enchantment != null) {
                    enchantments.add(enchantment);
                    continue;
                }
                context.getLogger().warning("Invalid enchantment in CheckInventory action " + key + ": " + enchantmentKey);
            }
        }
        return enchantments;
    }

    @Override
    protected boolean isAllowed(CastContext context) {
        Entity targetEntity = context.getTargetEntity();
        if (targetEntity == null || !(targetEntity instanceof Player)) {
            return false;
        }
        Mage mage = context.getController().getMage(targetEntity);
        if (this.slot != null) {
            ItemMeta meta;
            int slotNumber = this.slot.getSlot(mage);
            if (slotNumber == -1) {
                context.getLogger().warning("Invalid slot for CheckInventory action: " + (Object)((Object)this.slot));
                return false;
            }
            ItemStack item = mage.getItem(slotNumber);
            if (this.item != null && Objects.equals(item, this.item)) {
                return true;
            }
            ItemMeta itemMeta = meta = item == null ? null : item.getItemMeta();
            if (this.blockedEnchantments != null && meta != null) {
                for (Enchantment enchantment : this.blockedEnchantments) {
                    if (!meta.hasEnchant(enchantment)) continue;
                    return false;
                }
            }
            if (this.allowedEnchantments != null) {
                if (meta == null) {
                    return false;
                }
                for (Enchantment enchantment : this.allowedEnchantments) {
                    if (!meta.hasEnchant(enchantment)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return this.item != null && mage.hasItem(this.item);
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

