/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class WandLevel {
    private final WandUpgradePath path;
    private Deque<WeightedPair<Integer>> spellCountProbability = new ArrayDeque<WeightedPair<Integer>>();
    private Deque<WeightedPair<Integer>> materialCountProbability = new ArrayDeque<WeightedPair<Integer>>();
    private Deque<WeightedPair<String>> spellProbability = new ArrayDeque<WeightedPair<String>>();
    private Deque<WeightedPair<String>> materialProbability = new ArrayDeque<WeightedPair<String>>();
    private Deque<WeightedPair<Integer>> useProbability = new ArrayDeque<WeightedPair<Integer>>();
    private Deque<WeightedPair<Integer>> propertyCountProbability = new ArrayDeque<WeightedPair<Integer>>();
    private Map<String, Deque<WeightedPair<Float>>> propertiesProbability = new HashMap<String, Deque<WeightedPair<Float>>>();
    private Deque<WeightedPair<Integer>> manaRegenerationProbability = new ArrayDeque<WeightedPair<Integer>>();
    private Deque<WeightedPair<Integer>> manaMaxProbability = new ArrayDeque<WeightedPair<Integer>>();

    protected WandLevel(WandUpgradePath path, MageController controller, ConfigurationSection template, int levelIndex, int nextLevelIndex, float distance) {
        this.path = path;
        ArrayDeque<WeightedPair<String>> spells = new ArrayDeque<WeightedPair<String>>();
        RandomUtils.populateStringProbabilityMap(spells, template, "spells", levelIndex, nextLevelIndex, distance);
        for (WeightedPair weightedPair : spells) {
            if (controller.getSpellTemplate((String)weightedPair.getValue()) == null) continue;
            this.spellProbability.add(weightedPair);
        }
        RandomUtils.populateIntegerProbabilityMap(this.spellCountProbability, template, "spell_count", levelIndex, nextLevelIndex, distance);
        ArrayDeque<WeightedPair<String>> brushes = new ArrayDeque<WeightedPair<String>>();
        String string = template.contains("brushes") ? "brushes" : "materials";
        RandomUtils.populateStringProbabilityMap(brushes, template, string, levelIndex, nextLevelIndex, distance);
        for (WeightedPair weightedPair : brushes) {
            MaterialBrush brush = new MaterialBrush((String)weightedPair.getValue());
            if (!brush.isValid(false)) continue;
            this.materialProbability.add(weightedPair);
        }
        String materialCountKey = template.contains("brush_count") ? "brush_count" : "material_count";
        RandomUtils.populateIntegerProbabilityMap(this.materialCountProbability, template.getConfigurationSection(materialCountKey), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.useProbability, template, "uses", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.propertyCountProbability, template, "property_count", levelIndex, nextLevelIndex, distance);
        ConfigurationSection configurationSection = template.getConfigurationSection("properties");
        if (configurationSection != null) {
            for (String propertyKey : configurationSection.getKeys(false)) {
                ArrayDeque<WeightedPair<Float>> propertyProbability = new ArrayDeque<WeightedPair<Float>>();
                RandomUtils.populateFloatProbabilityMap(propertyProbability, configurationSection, propertyKey, levelIndex, nextLevelIndex, distance);
                propertyKey = propertyKey.replace("|", ".");
                this.propertiesProbability.put(propertyKey, propertyProbability);
            }
        }
        RandomUtils.populateIntegerProbabilityMap(this.manaRegenerationProbability, template, "mana_regeneration", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.manaMaxProbability, template, "mana_max", levelIndex, nextLevelIndex, distance);
    }

    public void add(WandLevel other) {
        this.spellProbability = RandomUtils.merge(this.spellProbability, other.spellProbability);
        this.materialProbability = RandomUtils.merge(this.materialProbability, other.materialProbability);
        this.materialCountProbability = this.materialCountProbability.isEmpty() ? other.materialCountProbability : this.materialCountProbability;
        this.spellCountProbability = this.spellCountProbability.isEmpty() ? other.spellCountProbability : this.spellCountProbability;
        this.useProbability = this.useProbability.isEmpty() ? other.useProbability : this.useProbability;
        this.propertyCountProbability = this.propertyCountProbability.isEmpty() ? other.propertyCountProbability : this.propertyCountProbability;
        for (Map.Entry<String, Deque<WeightedPair<Float>>> entry : other.propertiesProbability.entrySet()) {
            Deque<WeightedPair<Float>> thisOne = this.propertiesProbability.get(entry.getKey());
            if (thisOne != null && !thisOne.isEmpty()) continue;
            this.propertiesProbability.put(entry.getKey(), entry.getValue());
        }
        this.manaRegenerationProbability = this.manaRegenerationProbability.isEmpty() ? other.manaRegenerationProbability : this.manaRegenerationProbability;
        this.manaMaxProbability = this.manaMaxProbability.isEmpty() ? other.manaMaxProbability : this.manaMaxProbability;
    }

    public int getSpellCount() {
        int count = 0;
        for (WeightedPair<Integer> spellCount : this.spellCountProbability) {
            if (spellCount.getValue() <= count) continue;
            count = spellCount.getValue();
        }
        if (count == 0 && !this.spellProbability.isEmpty()) {
            count = 1;
        }
        return count;
    }

    public int getMaterialCount() {
        int count = 0;
        for (WeightedPair<Integer> materialCount : this.materialCountProbability) {
            if (materialCount.getValue() <= count) continue;
            count = materialCount.getValue();
        }
        return count;
    }

    public Deque<WeightedPair<String>> getRemainingSpells(CasterProperties properties) {
        ArrayDeque<WeightedPair<String>> remainingSpells = new ArrayDeque<WeightedPair<String>>();
        for (WeightedPair<String> spell : this.spellProbability) {
            if (!(spell.getRawThreshold().floatValue() >= 1.0f) || properties.hasSpell(spell.getValue())) continue;
            remainingSpells.add(spell);
        }
        return remainingSpells;
    }

    public Deque<WeightedPair<String>> getRemainingMaterials(CasterProperties properties) {
        ArrayDeque<WeightedPair<String>> remainingMaterials = new ArrayDeque<WeightedPair<String>>();
        for (WeightedPair<String> material : this.materialProbability) {
            String materialKey = material.getValue();
            if (properties.hasBrush(materialKey = materialKey.replace("|", ":")) || !MaterialBrush.isValidMaterial(materialKey, false)) continue;
            remainingMaterials.add(material);
        }
        return remainingMaterials;
    }

    public boolean randomizeWand(com.elmakers.mine.bukkit.api.magic.Mage mage, Wand wand, boolean hasUpgrade, boolean addSpells) {
        Mage activeMage = wand.getActiveMage();
        if (mage == null) {
            mage = activeMage;
        }
        wand.setActiveMage(mage);
        boolean result = this.randomize(mage, wand, hasUpgrade, addSpells);
        wand.setActiveMage(activeMage);
        return result;
    }

    public boolean randomize(com.elmakers.mine.bukkit.api.magic.Mage mage, CasterProperties caster, boolean hasUpgrade, boolean addSpells) {
        Wand wand;
        int wandUses;
        int maxSpells;
        boolean addedSpells = false;
        Deque remainingSpells = this.getRemainingSpells(caster);
        if (addSpells && remainingSpells.size() > 0 && ((maxSpells = caster.getMaxSpells()) <= 0 || caster.getSpells().size() < maxSpells)) {
            Integer spellCount = (Integer)RandomUtils.weightedRandom(this.spellCountProbability);
            if (spellCount == null || spellCount == 0) {
                spellCount = 1;
            }
            for (int i = 0; i < spellCount; ++i) {
                String spellKey = (String)RandomUtils.weightedRandom(remainingSpells);
                boolean added = caster.addSpell(spellKey);
                if (mage != null) {
                    mage.sendDebugMessage("Trying to add spell: " + (String)spellKey + " ? " + added);
                }
                if (!added) continue;
                addedSpells = true;
            }
        }
        boolean needsMaterials = false;
        int maxManaCost = 0;
        Collection<String> spells = caster.getSpells();
        for (String spellName : spells) {
            SpellTemplate spell = caster.getController().getSpellTemplate(spellName);
            if (spell == null) continue;
            boolean bl = needsMaterials = needsMaterials || spell.usesBrush();
            Collection<CastingCost> costs = spell.getCosts();
            if (costs == null) continue;
            for (CastingCost cost : costs) {
                maxManaCost = Math.max(maxManaCost, cost.getMana());
            }
        }
        boolean addedMaterials = false;
        Deque remainingMaterials = this.getRemainingMaterials(caster);
        if (needsMaterials && remainingMaterials.size() > 0) {
            int currentMaterialCount = caster.getBrushes().size();
            Integer materialCount = (Integer)RandomUtils.weightedRandom(this.materialCountProbability);
            if (materialCount == null) {
                materialCount = 0;
            }
            if (currentMaterialCount == 0) {
                materialCount = Math.max(1, materialCount);
            }
            int retries = 100;
            for (int i = 0; i < materialCount; ++i) {
                String materialKey = (String)RandomUtils.weightedRandom(remainingMaterials);
                if (!caster.addBrush(materialKey = materialKey.replace("|", ":"))) {
                    if (retries-- <= 0) continue;
                    --i;
                    continue;
                }
                addedMaterials = true;
            }
        }
        if (hasUpgrade && addSpells && (!addedMaterials || !needsMaterials) && !addedSpells && (this.getSpellCount() > 0 && this.spellProbability.size() > 0 || this.getMaterialCount() > 0 && this.materialProbability.size() > 0)) {
            if (mage != null && mage.getDebugLevel() > 0) {
                mage.sendDebugMessage("Has upgrade: " + hasUpgrade);
                mage.sendDebugMessage("Added spells: " + addedSpells + ", should: " + addSpells);
                mage.sendDebugMessage("Spells per enchant: " + this.getSpellCount());
                mage.sendDebugMessage("Spells in list: " + this.spellProbability.size());
                mage.sendDebugMessage("Added brushes: " + addedMaterials + ", needed: " + needsMaterials);
            }
            return false;
        }
        boolean addedProperties = false;
        Integer propertyCount = this.propertyCountProbability.size() == 0 ? Integer.valueOf(0) : (Integer)RandomUtils.weightedRandom(this.propertyCountProbability);
        ConfigurationSection upgradeProperties = ConfigurationUtils.newConfigurationSection();
        ArrayList<String> propertyKeys = new ArrayList<String>(this.propertiesProbability.keySet());
        ArrayList<String> propertiesAvailable = new ArrayList<String>();
        for (String propertyKey : propertyKeys) {
            double maxValue;
            double currentValue = caster.getDouble(propertyKey);
            if (!(currentValue < (maxValue = this.path.getMaxProperty(propertyKey)))) continue;
            propertiesAvailable.add(propertyKey);
        }
        if (propertiesAvailable.size() > 0 && !addedMaterials && !addedSpells && propertyCount == 0) {
            propertyCount = 1;
        }
        while (propertyCount != null) {
            Integer n = propertyCount;
            propertyCount = propertyCount - 1;
            if (n <= 0 || propertiesAvailable.size() <= 0) break;
            int randomPropertyIndex = (int)(Math.random() * (double)propertiesAvailable.size());
            String randomProperty = (String)propertiesAvailable.get(randomPropertyIndex);
            Deque probabilities = this.propertiesProbability.get(randomProperty);
            double current = caster.getDouble(randomProperty);
            double maxValue = this.path.getMaxProperty(randomProperty);
            if (probabilities.size() <= 0 || !(current < maxValue)) continue;
            addedProperties = true;
            current = Math.min(maxValue, current + (double)((Float)RandomUtils.weightedRandom(probabilities)).floatValue());
            upgradeProperties.set(randomProperty, (Object)current);
        }
        if (caster.isCostFree()) {
            upgradeProperties.set("mana_regeneration", (Object)0);
            upgradeProperties.set("mana_max", (Object)0);
            upgradeProperties.set("mana", (Object)0);
        } else {
            int manaRegeneration = caster.getManaRegeneration();
            if (this.manaRegenerationProbability.size() > 0 && manaRegeneration < this.path.getMaxManaRegeneration()) {
                addedProperties = true;
                manaRegeneration = Math.min(this.path.getMaxManaRegeneration(), manaRegeneration + (Integer)RandomUtils.weightedRandom(this.manaRegenerationProbability));
                upgradeProperties.set("mana_regeneration", (Object)manaRegeneration);
            }
            int manaMax = caster.getManaMax();
            if (this.manaMaxProbability.size() > 0 && manaMax < this.path.getMaxMaxMana()) {
                manaMax = Math.min(this.path.getMaxMaxMana(), manaMax + (Integer)RandomUtils.weightedRandom(this.manaMaxProbability));
                if (this.path.getMatchSpellMana()) {
                    manaMax = Math.max(maxManaCost, manaMax);
                }
                upgradeProperties.set("mana_max", (Object)manaMax);
                addedProperties = true;
            }
            upgradeProperties.set("mana", (Object)manaMax);
        }
        if (!this.useProbability.isEmpty() && caster instanceof Wand && (wandUses = (wand = (Wand)caster).getRemainingUses()) < this.path.getMaxUses() && this.useProbability.size() > 0) {
            upgradeProperties.set("uses", (Object)Math.min(this.path.getMaxUses(), wandUses + (Integer)RandomUtils.weightedRandom(this.useProbability)));
            addedProperties = true;
        }
        caster.upgrade(upgradeProperties);
        return addedMaterials || addedSpells || addedProperties;
    }

    public int getSpellProbabilityCount() {
        return this.spellProbability.size();
    }

    public int getMaterialProbabilityCount() {
        return this.materialProbability.size();
    }
}

