/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_17_0;

import com.elmakers.mine.bukkit.utility.BoundingBox;
import com.elmakers.mine.bukkit.utility.EnteredStateTracker;
import com.elmakers.mine.bukkit.utility.LoadingChunk;
import com.elmakers.mine.bukkit.utility.ReflectionUtils;
import com.elmakers.mine.bukkit.utility.platform.PaperUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.base.CompatibilityUtilsBase;
import com.google.common.collect.Multimap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.Paintings;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityDragonFireball;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.EntityFireballFireball;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemBoneMeal;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Rotation;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Lockable;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.bukkit.craftbukkit.v1_17_R1.CraftArt;
import org.bukkit.craftbukkit.v1_17_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftArmorStand;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftHanging;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftItem;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftMagicNumbers;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Witch;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.KnowledgeBookMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.loot.Lootable;
import org.bukkit.map.MapView;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class CompatibilityUtils
extends CompatibilityUtilsBase {
    private final Pattern hexColorPattern = Pattern.compile("&(#[A-Fa-f0-9]{6})");
    private final Map<String, EntityTypes> projectileEntityTypes = new HashMap<String, EntityTypes>();
    private final Map<String, Class<? extends IProjectile>> projectileClasses = new HashMap<String, Class<? extends IProjectile>>();

    public CompatibilityUtils(Platform platform) {
        super(platform);
        this.populateProjectileClasses();
    }

    private void addProjectileClass(String key, Class<? extends IProjectile> projectileClass, EntityTypes<?> entityType) {
        this.projectileClasses.put(key, projectileClass);
        this.projectileEntityTypes.put(projectileClass.getSimpleName(), entityType);
    }

    private void populateProjectileClasses() {
        this.addProjectileClass("arrow", EntityTippedArrow.class, EntityTypes.d);
        this.addProjectileClass("tippedarrow", EntityTippedArrow.class, EntityTypes.d);
        this.addProjectileClass("tipped_arrow", EntityTippedArrow.class, EntityTypes.d);
        this.addProjectileClass("dragonfireball", EntityDragonFireball.class, EntityTypes.r);
        this.addProjectileClass("dragon_fireball", EntityDragonFireball.class, EntityTypes.r);
        this.addProjectileClass("fireball", EntityLargeFireball.class, EntityTypes.S);
        this.addProjectileClass("largefireball", EntityLargeFireball.class, EntityTypes.S);
        this.addProjectileClass("large_fireball", EntityLargeFireball.class, EntityTypes.S);
        this.addProjectileClass("smallfireball", EntitySmallFireball.class, EntityTypes.aE);
        this.addProjectileClass("small_fireball", EntitySmallFireball.class, EntityTypes.aE);
        this.addProjectileClass("fireworks", EntityFireworks.class, EntityTypes.D);
        this.addProjectileClass("firework", EntityFireworks.class, EntityTypes.D);
        this.addProjectileClass("fireworkrocket", EntityFireworks.class, EntityTypes.D);
        this.addProjectileClass("firework_rocket", EntityFireworks.class, EntityTypes.D);
        this.addProjectileClass("fireworkrocketentity", EntityFireworks.class, EntityTypes.D);
        this.addProjectileClass("fishinghook", EntityFishingHook.class, EntityTypes.bj);
        this.addProjectileClass("fishing_hook", EntityFishingHook.class, EntityTypes.bj);
        this.addProjectileClass("fishing_bobber", EntityFishingHook.class, EntityTypes.bj);
        this.addProjectileClass("llamaspit", EntityLlamaSpit.class, EntityTypes.W);
        this.addProjectileClass("llama_spit", EntityLlamaSpit.class, EntityTypes.W);
        this.addProjectileClass("shulkerbullet", EntityShulkerBullet.class, EntityTypes.az);
        this.addProjectileClass("shulker_bullet", EntityShulkerBullet.class, EntityTypes.az);
        this.addProjectileClass("snowball", EntitySnowball.class, EntityTypes.aG);
        this.addProjectileClass("spectralarrow", EntitySpectralArrow.class, EntityTypes.aH);
        this.addProjectileClass("spectral_arrow", EntitySpectralArrow.class, EntityTypes.aH);
        this.addProjectileClass("egg", EntityEgg.class, EntityTypes.aM);
        this.addProjectileClass("thrownegg", EntityEgg.class, EntityTypes.aM);
        this.addProjectileClass("enderpearl", EntityEnderPearl.class, EntityTypes.aN);
        this.addProjectileClass("ender_pearl", EntityEnderPearl.class, EntityTypes.aN);
        this.addProjectileClass("thrownenderpearl", EntityEnderPearl.class, EntityTypes.aN);
        this.addProjectileClass("thrownexperiencebottle", EntityThrownExpBottle.class, EntityTypes.aO);
        this.addProjectileClass("experiencebottle", EntityThrownExpBottle.class, EntityTypes.aO);
        this.addProjectileClass("thrownpotion", EntityPotion.class, EntityTypes.aP);
        this.addProjectileClass("potion", EntityPotion.class, EntityTypes.aP);
        this.addProjectileClass("throwntrident", EntityThrownTrident.class, EntityTypes.aQ);
        this.addProjectileClass("trident", EntityThrownTrident.class, EntityTypes.aQ);
        this.addProjectileClass("witherskull", EntityWitherSkull.class, EntityTypes.bb);
        this.addProjectileClass("wither_skull", EntityWitherSkull.class, EntityTypes.bb);
    }

    @Override
    public Inventory createInventory(InventoryHolder holder, int size, String name) {
        size = (int)(Math.ceil((double)size / 9.0) * 9.0);
        size = Math.min(size, 54);
        String translatedName = this.translateColors(name);
        return Bukkit.createInventory((InventoryHolder)holder, (int)size, (String)translatedName);
    }

    @Override
    public boolean isInvulnerable(Entity entity) {
        return entity.isInvulnerable();
    }

    @Override
    public void setInvulnerable(Entity entity, boolean flag) {
        entity.setInvulnerable(flag);
    }

    @Override
    public boolean isSilent(Entity entity) {
        return entity.isSilent();
    }

    @Override
    public void setSilent(Entity entity, boolean flag) {
        entity.setSilent(flag);
    }

    @Override
    public boolean isPersist(Entity entity) {
        return entity.isPersistent();
    }

    @Override
    public void setPersist(Entity entity, boolean flag) {
        entity.setPersistent(flag);
    }

    @Override
    public void setRemoveWhenFarAway(Entity entity, boolean flag) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity li = (LivingEntity)entity;
        li.setRemoveWhenFarAway(flag);
    }

    @Override
    public boolean isSitting(Entity entity) {
        if (!(entity instanceof Sittable)) {
            return false;
        }
        Sittable sittable = (Sittable)entity;
        return sittable.isSitting();
    }

    @Override
    public void setSitting(Entity entity, boolean flag) {
        if (!(entity instanceof Sittable)) {
            return;
        }
        Sittable sittable = (Sittable)entity;
        sittable.setSitting(flag);
    }

    @Override
    public Painting createPainting(Location location, BlockFace facing, Art art) {
        CraftEntity bukkitEntity;
        Painting newPainting = null;
        WorldServer level = ((CraftWorld)location.getWorld()).getHandle();
        EnumDirection directionEnum = null;
        try {
            directionEnum = EnumDirection.valueOf((String)facing.name());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        BlockPosition blockLocation = new BlockPosition(location.getX(), location.getY(), location.getZ());
        EntityPainting newEntity = new EntityPainting((net.minecraft.world.level.World)level, blockLocation, directionEnum);
        if (newEntity != null) {
            Paintings notchArt;
            newEntity.e = notchArt = CraftArt.BukkitToNotch((Art)art);
        }
        if ((bukkitEntity = newEntity.getBukkitEntity()) != null && bukkitEntity instanceof Painting) {
            newPainting = (Painting)bukkitEntity;
        }
        return newPainting;
    }

    @Override
    public ItemFrame createItemFrame(Location location, BlockFace facing, Rotation rotation, ItemStack item) {
        ItemFrame newItemFrame = null;
        WorldServer level = ((CraftWorld)location.getWorld()).getHandle();
        EnumDirection directionEnum = null;
        try {
            directionEnum = EnumDirection.valueOf((String)facing.name());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        BlockPosition blockLocation = new BlockPosition(location.getX(), location.getY(), location.getZ());
        EntityItemFrame newEntity = new EntityItemFrame((net.minecraft.world.level.World)level, blockLocation, directionEnum);
        CraftEntity bukkitEntity = newEntity.getBukkitEntity();
        if (bukkitEntity != null && bukkitEntity instanceof ItemFrame) {
            newItemFrame = (ItemFrame)bukkitEntity;
            newItemFrame.setItem(this.platform.getItemUtils().getCopy(item));
            newItemFrame.setRotation(rotation);
        }
        return newItemFrame;
    }

    @Override
    public Entity createEntity(Location location, EntityType entityType) {
        CraftEntity bukkitEntity = null;
        try {
            Class entityClass = entityType.getEntityClass();
            CraftWorld craftWorld = (CraftWorld)location.getWorld();
            net.minecraft.world.entity.Entity newEntity = craftWorld.createEntity(location, entityClass);
            if (!(newEntity == null || (bukkitEntity = newEntity.getBukkitEntity()) != null && entityClass.isAssignableFrom(bukkitEntity.getClass()))) {
                return null;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return bukkitEntity;
    }

    @Override
    public boolean addToWorld(World world, Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        WorldServer level = ((CraftWorld)world).getHandle();
        net.minecraft.world.entity.Entity entityHandle = ((CraftEntity)entity).getHandle();
        level.addEntity(entityHandle, reason);
        return true;
    }

    @Override
    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z) {
        if (location == null) {
            return null;
        }
        x = Math.min(x, 72.0);
        z = Math.min(z, 72.0);
        return location.getWorld().getNearbyEntities(location, x, y, z);
    }

    @Override
    public void ageItem(Item item, int ticksToAge) {
        EntityItem nmsItem = (EntityItem)((CraftItem)item).getHandle();
        nmsItem.ao = ticksToAge;
    }

    @Override
    public void magicDamage(org.bukkit.entity.Damageable target, double amount, Entity source) {
        block18: {
            try {
                if (target == null || target.isDead()) {
                    return;
                }
                if (!this.USE_MAGIC_DAMAGE || target instanceof Witch || target instanceof Enderman || target instanceof ArmorStand || !(target instanceof LivingEntity)) {
                    this.damage(target, amount, source);
                    return;
                }
                net.minecraft.world.entity.Entity targetHandle = ((CraftEntity)target).getHandle();
                if (targetHandle == null) {
                    return;
                }
                net.minecraft.world.entity.Entity sourceHandle = ((CraftEntity)source).getHandle();
                if (sourceHandle != null && source instanceof LivingEntity) {
                    Location location = target.getLocation();
                    ThrownPotion potion = this.getOrCreatePotionEntity(location);
                    net.minecraft.world.entity.Entity potionHandle = ((CraftEntity)potion).getHandle();
                    potion.setShooter((ProjectileSource)((LivingEntity)source));
                    DamageSource magicSource = DamageSource.c((net.minecraft.world.entity.Entity)potionHandle, (net.minecraft.world.entity.Entity)sourceHandle);
                    ((EntityDamageSource)magicSource).D();
                    try (EnteredStateTracker.Touchable damaging = this.DAMAGING.enter();){
                        damaging.touch();
                        targetHandle.damageEntity(magicSource, (float)amount);
                        break block18;
                    }
                }
                try (EnteredStateTracker.Touchable damaging = this.DAMAGING.enter();){
                    damaging.touch();
                    targetHandle.damageEntity(DamageSource.o, (float)amount);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected DamageSource getDamageSource(String damageType) {
        switch (damageType.toUpperCase()) {
            case "IN_FIRE": {
                return DamageSource.a;
            }
            case "LIGHTNING_BOLT": {
                return DamageSource.b;
            }
            case "ON_FIRE": {
                return DamageSource.c;
            }
            case "LAVA": {
                return DamageSource.d;
            }
            case "HOT_FLOOR": {
                return DamageSource.e;
            }
            case "IN_WALL": {
                return DamageSource.f;
            }
            case "CRAMMING": {
                return DamageSource.g;
            }
            case "DROWN": {
                return DamageSource.h;
            }
            case "STARVE": {
                return DamageSource.i;
            }
            case "CACTUS": {
                return DamageSource.j;
            }
            case "FALL": {
                return DamageSource.k;
            }
            case "FLY_INTO_WALL": {
                return DamageSource.l;
            }
            case "OUT_OF_WORLD": {
                return DamageSource.m;
            }
            case "GENERIC": {
                return DamageSource.n;
            }
            case "MAGIC": {
                return DamageSource.o;
            }
            case "WITHER": {
                return DamageSource.p;
            }
            case "ANVIL": {
                return DamageSource.q;
            }
            case "FALLING_BLOCK": {
                return DamageSource.r;
            }
            case "DRAGON_BREATH": {
                return DamageSource.s;
            }
            case "DRY_OUT": {
                return DamageSource.t;
            }
            case "SWEET_BERRY_BUSH": {
                return DamageSource.u;
            }
            case "FREEZE": {
                return DamageSource.v;
            }
            case "FALLING_STALACTITE": {
                return DamageSource.w;
            }
            case "STALAGMITE": {
                return DamageSource.x;
            }
        }
        return null;
    }

    @Override
    public void damage(org.bukkit.entity.Damageable target, double amount, Entity source, String damageType) {
        if (target == null || target.isDead()) {
            return;
        }
        if (damageType.equalsIgnoreCase("direct")) {
            double health = target.getHealth() - amount;
            target.setHealth(Math.max(health, 0.0));
            return;
        }
        if (damageType.equalsIgnoreCase("magic")) {
            this.magicDamage(target, amount, source);
            return;
        }
        DamageSource damageSource = this.getDamageSource(damageType);
        if (damageSource == null) {
            this.magicDamage(target, amount, source);
            return;
        }
        net.minecraft.world.entity.Entity targetHandle = ((CraftEntity)target).getHandle();
        if (targetHandle == null) {
            return;
        }
        try (EnteredStateTracker.Touchable damaging = this.DAMAGING.enter();){
            damaging.touch();
            targetHandle.damageEntity(damageSource, (float)amount);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isReady(Chunk chunk) {
        return true;
    }

    @Override
    public boolean createExplosion(Entity entity, World world, double x, double y, double z, float power, boolean setFire, boolean breakBlocks) {
        return world.createExplosion(x, y, z, power, setFire, breakBlocks, entity);
    }

    public TileEntity getTileEntity(Location location) {
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        return world.getTileEntity(new BlockPosition(location.getX(), location.getY(), location.getZ()), false);
    }

    public NBTTagCompound getTileEntityData(Location location) {
        if (location == null) {
            return null;
        }
        TileEntity tileEntity = this.getTileEntity(location);
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tileEntity.save(tag);
        return tag;
    }

    @Override
    public void setTileEntityData(Location location, Object data) {
        if (location == null || data == null || !(data instanceof NBTTagCompound)) {
            return;
        }
        TileEntity tileEntity = this.getTileEntity(location);
        if (tileEntity == null) {
            return;
        }
        NBTTagCompound tag = (NBTTagCompound)data;
        tag.setInt("x", location.getBlockX());
        tag.setInt("y", location.getBlockY());
        tag.setInt("z", location.getBlockZ());
        tileEntity.load(tag);
        tileEntity.update();
    }

    @Override
    public void clearItems(Location location) {
        if (location == null) {
            return;
        }
        TileEntity tileEntity = this.getTileEntity(location);
        if (tileEntity == null) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tileEntity.save(tag);
        NBTTagList itemList = tag.getList("Items", 10);
        if (itemList != null) {
            itemList.clear();
        }
        tag.remove("Items");
        tileEntity.load(tag);
        tileEntity.update();
        org.bukkit.block.Block block = location.getBlock();
        BlockState blockState = block.getState();
        if (blockState instanceof Lootable) {
            Lootable lootable = (Lootable)blockState;
            lootable.setLootTable(null);
            blockState.update();
        }
    }

    @Override
    public void setEnvironment(World world, World.Environment environment) {
    }

    @Override
    public void playCustomSound(Player player, Location location, String sound, float volume, float pitch) {
        player.playSound(location, sound, volume, pitch);
    }

    @Override
    public List<Entity> selectEntities(CommandSender sender, String selector) {
        if (!selector.startsWith("@")) {
            return null;
        }
        try {
            return Bukkit.selectEntities((CommandSender)sender, (String)selector);
        }
        catch (IllegalArgumentException ex) {
            this.platform.getLogger().warning("Invalid selector: " + ex.getMessage());
            return null;
        }
    }

    @Override
    public MapView getMapById(int id) {
        return Bukkit.getMap((int)id);
    }

    @Override
    public <T> Map<String, T> getTypedMap(ConfigurationSection section) {
        if (section == null) {
            return null;
        }
        if (section instanceof MemorySection) {
            return (Map)ReflectionUtils.getPrivate(this.platform.getLogger(), section, MemorySection.class, "map");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set keys = section.getKeys(false);
        for (String key : keys) {
            map.put(key, section.get(key));
        }
        return map;
    }

    @Override
    public boolean setMap(ConfigurationSection section, Map<String, Object> map) {
        if (section == null) {
            return false;
        }
        if (section instanceof MemorySection) {
            return ReflectionUtils.setPrivate(this.platform.getLogger(), section, MemorySection.class, "map", map);
        }
        return true;
    }

    @Override
    public Vector getPosition(Object entityData, String tag) {
        if (entityData == null || !(entityData instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound data = (NBTTagCompound)entityData;
        NBTTagList list = data.getList(tag, 6);
        double x = list.h(0);
        double y = list.h(1);
        double z = list.h(2);
        return new Vector(x, y, z);
    }

    @Override
    public BlockVector getBlockVector(Object entityData, String tag) {
        if (entityData == null || !(entityData instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound data = (NBTTagCompound)entityData;
        int[] coords = data.getIntArray(tag);
        if (coords == null || coords.length < 3) {
            return null;
        }
        return new BlockVector(coords[0], coords[1], coords[2]);
    }

    @Override
    public void setTNTSource(TNTPrimed tnt, LivingEntity source) {
        tnt.setSource((Entity)source);
    }

    @Override
    public void setEntityMotion(Entity entity, Vector motion) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        nms.setMot(new Vec3D(motion.getX(), motion.getY(), motion.getZ()));
    }

    @Override
    public boolean setLock(org.bukkit.block.Block block, String lockName) {
        if (!(block instanceof Lockable)) {
            return false;
        }
        Lockable lockable = (Lockable)block;
        lockable.setLock(lockName);
        return true;
    }

    @Override
    public boolean clearLock(org.bukkit.block.Block block) {
        if (!(block instanceof Lockable)) {
            return false;
        }
        Lockable lockable = (Lockable)block;
        lockable.setLock(null);
        return true;
    }

    @Override
    public boolean isLocked(org.bukkit.block.Block block) {
        if (!(block instanceof Lockable)) {
            return false;
        }
        Lockable lockable = (Lockable)block;
        return lockable.isLocked();
    }

    @Override
    public String getLock(org.bukkit.block.Block block) {
        if (!(block instanceof Lockable)) {
            return null;
        }
        Lockable lockable = (Lockable)block;
        return lockable.getLock();
    }

    @Override
    public void setFallingBlockDamage(FallingBlock entity, float fallHurtAmount, int fallHurtMax) {
        entity.setHurtEntities(true);
        EntityFallingBlock nms = (EntityFallingBlock)((CraftEntity)entity).getHandle();
        ReflectionUtils.setPrivateNeedsFixing(this.platform.getLogger(), nms, EntityFallingBlock.class, "fallDamagePerDistance", "ar", Float.valueOf(fallHurtAmount));
        ReflectionUtils.setPrivateNeedsFixing(this.platform.getLogger(), nms, EntityFallingBlock.class, "fallDamageMax", "aq", fallHurtMax);
    }

    @Override
    public void setGravity(ArmorStand armorStand, boolean gravity) {
        armorStand.setGravity(gravity);
    }

    @Override
    public void setGravity(Entity entity, boolean gravity) {
        entity.setGravity(gravity);
    }

    @Override
    public void setDisabledSlots(ArmorStand armorStand, int disabledSlots) {
        EntityArmorStand nms = ((CraftArmorStand)armorStand).getHandle();
        nms.cf = disabledSlots;
    }

    @Override
    public int getDisabledSlots(ArmorStand armorStand) {
        EntityArmorStand nms = ((CraftArmorStand)armorStand).getHandle();
        return nms.cf;
    }

    @Override
    public void setInvisible(ArmorStand armorStand, boolean invisible) {
        armorStand.setInvisible(invisible);
    }

    @Override
    public void setInvisible(Entity entity, boolean invisible) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        nms.setInvisible(invisible);
    }

    @Override
    public Boolean isInvisible(Entity entity) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        return nms.isInvisible();
    }

    @Override
    public boolean isPersistentInvisible(Entity entity) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        return nms.persistentInvisibility;
    }

    @Override
    public void setPersistentInvisible(Entity entity, boolean invisible) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        nms.persistentInvisibility = invisible;
    }

    @Override
    public void setYawPitch(Entity entity, float yaw, float pitch) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        nms.setYRot(yaw % 360.0f);
        nms.setXRot(pitch % 360.0f);
    }

    @Override
    public void setLocation(Entity entity, double x, double y, double z, float yaw, float pitch) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        nms.setLocation(x, y, z, yaw, pitch);
    }

    @Override
    public void addFlightExemption(Player player, int ticks) {
        EntityPlayer nms = ((CraftPlayer)player).getHandle();
        ReflectionUtils.setPrivateNeedsFixing(this.platform.getLogger(), nms.b, PlayerConnection.class, "aboveGroundTickCount", "C", -ticks);
    }

    @Override
    public boolean isValidProjectileClass(Class<?> projectileType) {
        return projectileType != null && IProjectile.class.isAssignableFrom(projectileType);
    }

    @Override
    public Projectile spawnProjectile(Class<?> projectileType, Location location, Vector direction, ProjectileSource source, float speed, float spread, float spreadLocations, Random random) {
        Constructor<?> constructor = null;
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        Projectile projectile = null;
        try {
            CraftEntity entity;
            EntityTypes entityType = null;
            constructor = projectileType.getConstructor(EntityTypes.class, net.minecraft.world.level.World.class);
            entityType = this.projectileEntityTypes.get(projectileType.getSimpleName());
            if (entityType == null) {
                throw new Exception("Failed to find entity type for projectile class " + projectileType.getName());
            }
            Object nmsProjectile = null;
            try {
                nmsProjectile = (entityType == null ? constructor.newInstance(nmsWorld) : constructor.newInstance(entityType, nmsWorld));
            }
            catch (Exception ex) {
                nmsProjectile = null;
                this.platform.getLogger().log(Level.WARNING, "Error spawning projectile of class " + projectileType.getName(), ex);
            }
            if (nmsProjectile == null || !(nmsProjectile instanceof net.minecraft.world.entity.Entity)) {
                throw new Exception("Failed to spawn projectile of class " + projectileType.getName());
            }
            if (nmsProjectile instanceof EntityFireball) {
                EntityFireball fireballIsh = nmsProjectile;
                double spreadWeight = Math.min((double)0.4f, (double)spread * (double)0.0075f);
                double dx = (double)speed * (direction.getX() + random.nextGaussian() * spreadWeight);
                double dy = (double)speed * (direction.getY() + random.nextGaussian() * spreadWeight);
                double dz = (double)speed * (direction.getZ() + random.nextGaussian() * spreadWeight);
                fireballIsh.b = dx * 0.1;
                fireballIsh.c = dy * 0.1;
                fireballIsh.d = dz * 0.1;
            }
            net.minecraft.world.entity.Entity nmsEntity = nmsProjectile;
            Vector modifiedLocation = location.toVector().clone();
            if (EntityFireballFireball.class.isAssignableFrom(projectileType) && spreadLocations > 0.0f) {
                modifiedLocation.setX(modifiedLocation.getX() + direction.getX() + random.nextGaussian() * (double)spread / 5.0);
                modifiedLocation.setY(modifiedLocation.getY() + direction.getY() + random.nextGaussian() * (double)spread / 5.0);
                modifiedLocation.setZ(modifiedLocation.getZ() + direction.getZ() + random.nextGaussian() * (double)spread / 5.0);
            }
            nmsEntity.setPositionRotation(modifiedLocation.getX(), modifiedLocation.getY(), modifiedLocation.getZ(), location.getYaw(), location.getPitch());
            if (nmsEntity instanceof IProjectile) {
                IProjectile nms = (IProjectile)nmsEntity;
                nms.shoot(direction.getX(), direction.getY(), direction.getZ(), speed, spread);
            }
            if ((entity = nmsEntity.getBukkitEntity()) == null || !(entity instanceof Projectile)) {
                throw new Exception("Got invalid bukkit entity from projectile of class " + projectileType.getName());
            }
            projectile = (Projectile)entity;
            if (source != null) {
                projectile.setShooter(source);
                nmsEntity.projectileSource = source;
            }
            nmsWorld.addEntity(nmsEntity, CreatureSpawnEvent.SpawnReason.DEFAULT);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
        return projectile;
    }

    @Override
    public void setDamage(Projectile projectile, double damage) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)projectile).getHandle();
        if (!(nms instanceof EntityTippedArrow)) {
            return;
        }
        EntityTippedArrow arrow = (EntityTippedArrow)nms;
        arrow.setDamage(damage);
    }

    @Override
    public void decreaseLifespan(Projectile projectile, int ticks) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)projectile).getHandle();
        if (!(nms instanceof EntityTippedArrow)) {
            return;
        }
        EntityTippedArrow arrow = (EntityTippedArrow)nms;
        arrow.au = ticks;
    }

    @Override
    public Entity spawnEntity(Location target, EntityType entityType, CreatureSpawnEvent.SpawnReason spawnReason) {
        CraftWorld craftWorld = (CraftWorld)target.getWorld();
        return craftWorld.spawn(target, entityType.getEntityClass(), null, spawnReason);
    }

    @Override
    public String getResourcePack(Server server) {
        return ((CraftServer)server).getServer().getResourcePack();
    }

    @Override
    public boolean setResourcePack(Player player, String rp, byte[] hash) {
        player.setResourcePack(rp, hash);
        return true;
    }

    @Override
    public boolean removeItemAttribute(ItemStack item, Attribute attribute) {
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        if (!meta.removeAttributeModifier(attribute)) {
            return false;
        }
        item.setItemMeta(meta);
        return true;
    }

    @Override
    public boolean removeItemAttributes(ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        Multimap modifiers = meta.getAttributeModifiers();
        if (modifiers == null || modifiers.isEmpty()) {
            return false;
        }
        for (Attribute attribute : modifiers.keySet()) {
            meta.removeAttributeModifier(attribute);
        }
        item.setItemMeta(meta);
        return true;
    }

    @Override
    public boolean setItemAttribute(ItemStack item, Attribute attribute, double value, String slot, int attributeOperation, UUID attributeUUID) {
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        try {
            AttributeModifier modifier;
            AttributeModifier.Operation operation;
            try {
                operation = AttributeModifier.Operation.values()[attributeOperation];
            }
            catch (Throwable ex) {
                this.platform.getLogger().warning("[Magic] invalid attribute operation ordinal: " + attributeOperation);
                return false;
            }
            if (slot != null && !slot.isEmpty()) {
                EquipmentSlot equipmentSlot;
                try {
                    equipmentSlot = slot.equalsIgnoreCase("mainhand") ? EquipmentSlot.HAND : (slot.equalsIgnoreCase("offhand") ? EquipmentSlot.OFF_HAND : EquipmentSlot.valueOf((String)slot.toUpperCase()));
                }
                catch (Throwable ex) {
                    this.platform.getLogger().warning("[Magic] invalid attribute slot: " + slot);
                    return false;
                }
                modifier = new AttributeModifier(attributeUUID, "Equipment Modifier", value, operation, equipmentSlot);
            } else {
                modifier = new AttributeModifier(attributeUUID, "Equipment Modifier", value, operation);
            }
            meta.addAttributeModifier(attribute, modifier);
            item.setItemMeta(meta);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void sendExperienceUpdate(Player player, float experience, int level) {
        player.sendExperienceChange(experience, level);
    }

    public NBTTagCompound getEntityData(Entity entity) {
        if (entity == null) {
            return null;
        }
        NBTTagCompound data = new NBTTagCompound();
        ((CraftEntity)entity).getHandle().e(data);
        return data;
    }

    @Override
    public String getEntityType(Entity entity) {
        if (entity == null) {
            return null;
        }
        return ((CraftEntity)entity).getHandle().getSaveID();
    }

    @Override
    public void swingOffhand(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        ((LivingEntity)entity).swingOffHand();
    }

    @Override
    public void sendTitle(Player player, String title, String subTitle, int fadeIn, int stay, int fadeOut) {
        player.sendTitle(title, subTitle, fadeIn, stay, fadeOut);
    }

    @Override
    public boolean sendActionBar(Player player, String message) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
        return true;
    }

    @Override
    public float getDurability(Material material) {
        return CraftMagicNumbers.getBlock((Material)material).getDurability();
    }

    protected void sendPacket(Server server, Location source, Collection<? extends Player> players, Packet<?> packet) throws Exception {
        players = players != null && players.size() > 0 ? players : server.getOnlinePlayers();
        int viewDistance = Bukkit.getServer().getViewDistance() * 16;
        int viewDistanceSquared = viewDistance * viewDistance;
        World sourceWorld = source.getWorld();
        for (Player player : players) {
            Location location = player.getLocation();
            if (!location.getWorld().equals(sourceWorld) || !(location.distanceSquared(source) <= (double)viewDistanceSquared)) continue;
            this.sendPacket(player, packet);
        }
    }

    protected void sendPacket(Player player, Packet<?> packet) throws Exception {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        nmsPlayer.b.sendPacket(packet);
    }

    @Override
    public void sendBreaking(Player player, long id, Location location, int breakAmount) {
        try {
            BlockPosition blockPosition = new BlockPosition(location.getX(), location.getY(), location.getZ());
            PacketPlayOutBlockBreakAnimation packet = new PacketPlayOutBlockBreakAnimation((int)id, blockPosition, breakAmount);
            this.sendPacket(player, (Packet<?>)packet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Set<String> getTags(Entity entity) {
        return entity.getScoreboardTags();
    }

    @Override
    public boolean isJumping(LivingEntity entity) {
        EntityLiving living = ((CraftLivingEntity)entity).getHandle();
        return (Boolean)ReflectionUtils.getPrivateNeedsFixing(this.platform.getLogger(), living, EntityLiving.class, "jumping", "bn");
    }

    @Override
    public float getForwardMovement(LivingEntity entity) {
        EntityLiving living = ((CraftLivingEntity)entity).getHandle();
        return living.bq;
    }

    @Override
    public float getStrafeMovement(LivingEntity entity) {
        EntityLiving living = ((CraftLivingEntity)entity).getHandle();
        return living.bo;
    }

    @Override
    public boolean setBlockFast(Chunk chunk, int x, int y, int z, Material material, int data) {
        net.minecraft.world.level.chunk.Chunk nmsChunk = ((CraftChunk)chunk).getHandle();
        Block block = CraftMagicNumbers.getBlock((Material)material);
        BlockPosition blockLocation = new BlockPosition(x, y, z);
        nmsChunk.setType(blockLocation, block.getBlockData(), false);
        return true;
    }

    @Override
    public boolean setPickupStatus(Arrow arrow, String pickupStatus) {
        AbstractArrow.PickupStatus status;
        try {
            status = AbstractArrow.PickupStatus.valueOf((String)pickupStatus.toUpperCase());
        }
        catch (Throwable ex) {
            this.platform.getLogger().warning("Invalid pickup status: " + pickupStatus);
            return false;
        }
        arrow.setPickupStatus(status);
        return true;
    }

    @Override
    public org.bukkit.block.Block getHitBlock(ProjectileHitEvent event) {
        return event.getHitBlock();
    }

    @Override
    public Entity getEntity(World world, UUID uuid) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftWorld)world).getHandle().getEntity(uuid);
        return nmsEntity == null ? null : nmsEntity.getBukkitEntity();
    }

    @Override
    public Entity getEntity(UUID uuid) {
        return Bukkit.getEntity((UUID)uuid);
    }

    @Override
    public boolean canRemoveRecipes() {
        return true;
    }

    @Override
    public boolean removeRecipe(Recipe recipe) {
        if (!(recipe instanceof Keyed)) {
            return false;
        }
        Keyed keyed = (Keyed)recipe;
        return this.platform.getPlugin().getServer().removeRecipe(keyed.getKey());
    }

    @Override
    public boolean removeRecipe(String key) {
        NamespacedKey namespacedKey = new NamespacedKey(this.platform.getPlugin(), key.toLowerCase());
        return this.platform.getPlugin().getServer().removeRecipe(namespacedKey);
    }

    @Override
    public ShapedRecipe createShapedRecipe(String key, ItemStack item) {
        NamespacedKey namespacedKey = new NamespacedKey(this.platform.getPlugin(), key.toLowerCase());
        return new ShapedRecipe(namespacedKey, item);
    }

    @Override
    public boolean discoverRecipe(HumanEntity entity, String key) {
        NamespacedKey namespacedKey = new NamespacedKey(this.platform.getPlugin(), key.toLowerCase());
        return entity.discoverRecipe(namespacedKey);
    }

    @Override
    public boolean undiscoverRecipe(HumanEntity entity, String key) {
        NamespacedKey namespacedKey = new NamespacedKey(this.platform.getPlugin(), key.toLowerCase());
        return entity.undiscoverRecipe(namespacedKey);
    }

    @Override
    public double getMaxHealth(org.bukkit.entity.Damageable li) {
        if (li instanceof LivingEntity) {
            return ((LivingEntity)li).getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
        }
        return 0.0;
    }

    @Override
    public void setMaxHealth(org.bukkit.entity.Damageable li, double maxHealth) {
        if (li instanceof LivingEntity) {
            ((LivingEntity)li).getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(maxHealth);
        }
    }

    @Override
    public Material fromLegacy(MaterialData materialData) {
        Material converted = Bukkit.getUnsafe().fromLegacy(materialData);
        if (converted == Material.AIR) {
            materialData.setData((byte)0);
            converted = Bukkit.getUnsafe().fromLegacy(materialData);
        }
        return converted;
    }

    @Override
    public boolean hasLegacyMaterials() {
        return true;
    }

    @Override
    public boolean isLegacy(Material material) {
        return material.isLegacy();
    }

    @Override
    public Material getLegacyMaterial(String materialName) {
        return Material.getMaterial((String)materialName, (boolean)true);
    }

    @Override
    public boolean applyBonemeal(Location location) {
        if (this.dummyItem == null) {
            this.dummyItem = new ItemStack(Material.DIRT, 64);
            this.dummyItem = this.platform.getItemUtils().makeReal(this.dummyItem);
        }
        this.dummyItem.setAmount(64);
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        net.minecraft.world.item.ItemStack itemStack = (net.minecraft.world.item.ItemStack)this.platform.getItemUtils().getHandle(this.dummyItem);
        BlockPosition blockPosition = new BlockPosition(location.getX(), location.getY(), location.getZ());
        return ItemBoneMeal.a((net.minecraft.world.item.ItemStack)itemStack, (net.minecraft.world.level.World)nmsWorld, (BlockPosition)blockPosition);
    }

    @Override
    public Color getColor(PotionMeta meta) {
        return meta.getColor();
    }

    @Override
    public boolean setColor(PotionMeta meta, Color color) {
        meta.setColor(color);
        return true;
    }

    @Override
    public boolean hasBlockDataSupport() {
        return true;
    }

    @Override
    public byte getBlockData(FallingBlock falling) {
        return 0;
    }

    @Override
    public String getBlockData(Material material, byte data) {
        BlockData blockData = this.platform.getDeprecatedUtils().getUnsafe().fromLegacy(material, data);
        return blockData == null ? null : blockData.getAsString();
    }

    @Override
    public String getBlockData(org.bukkit.block.Block block) {
        BlockData blockData = block.getBlockData();
        return blockData == null ? null : blockData.getAsString();
    }

    @Override
    public boolean setBlockData(org.bukkit.block.Block block, String data) {
        BlockData blockData = this.platform.getPlugin().getServer().createBlockData(data);
        block.setBlockData(blockData, false);
        return true;
    }

    @Override
    public boolean applyPhysics(org.bukkit.block.Block block) {
        WorldServer nmsWorld = ((CraftWorld)block.getWorld()).getHandle();
        BlockPosition blockLocation = new BlockPosition(block.getX(), block.getY(), block.getZ());
        IBlockData blockState = nmsWorld.getType(blockLocation);
        this.clearItems(block.getLocation());
        this.platform.getDeprecatedUtils().setTypeAndData(block, Material.AIR, (byte)0, false);
        return nmsWorld.setTypeAndData(blockLocation, blockState, 3);
    }

    @Override
    public boolean addRecipeToBook(ItemStack book, Plugin plugin, String recipeKey) {
        if (book == null) {
            return false;
        }
        ItemMeta meta = book.getItemMeta();
        if (!(meta instanceof KnowledgeBookMeta)) {
            return false;
        }
        KnowledgeBookMeta bookMeta = (KnowledgeBookMeta)meta;
        NamespacedKey key = new NamespacedKey(plugin, recipeKey.toLowerCase());
        bookMeta.addRecipe(new NamespacedKey[]{key});
        book.setItemMeta((ItemMeta)bookMeta);
        return true;
    }

    @Override
    public boolean isPowerable(org.bukkit.block.Block block) {
        BlockData blockData = block.getBlockData();
        return blockData != null && blockData instanceof Powerable;
    }

    @Override
    public boolean isPowered(org.bukkit.block.Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData == null || !(blockData instanceof Powerable)) {
            return false;
        }
        Powerable powerable = (Powerable)blockData;
        return powerable.isPowered();
    }

    @Override
    public boolean setPowered(org.bukkit.block.Block block, boolean powered) {
        BlockData blockData = block.getBlockData();
        if (blockData == null || !(blockData instanceof Powerable)) {
            return false;
        }
        Powerable powerable = (Powerable)blockData;
        powerable.setPowered(powered);
        block.setBlockData((BlockData)powerable, true);
        return true;
    }

    @Override
    public boolean isWaterLoggable(org.bukkit.block.Block block) {
        BlockData blockData = block.getBlockData();
        return blockData != null && blockData instanceof Waterlogged;
    }

    @Override
    public boolean setWaterlogged(org.bukkit.block.Block block, boolean waterlogged) {
        BlockData blockData = block.getBlockData();
        if (blockData == null || !(blockData instanceof Waterlogged)) {
            return false;
        }
        Waterlogged waterlogger = (Waterlogged)blockData;
        waterlogger.setWaterlogged(waterlogged);
        block.setBlockData((BlockData)waterlogger, true);
        return true;
    }

    @Override
    public boolean setTopHalf(org.bukkit.block.Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData == null || !(blockData instanceof Bisected)) {
            return false;
        }
        Bisected bisected = (Bisected)blockData;
        bisected.setHalf(Bisected.Half.TOP);
        block.setBlockData((BlockData)bisected, false);
        return true;
    }

    @Override
    public boolean stopSound(Player player, Sound sound) {
        player.stopSound(sound);
        return true;
    }

    @Override
    public boolean stopSound(Player player, String sound) {
        player.stopSound(sound);
        return true;
    }

    @Override
    public boolean lockChunk(Chunk chunk) {
        if (!this.platform.getPlugin().isEnabled()) {
            return false;
        }
        if (!chunk.isLoaded()) {
            this.platform.getLogger().info("Locking unloaded chunk");
        }
        chunk.addPluginChunkTicket(this.platform.getPlugin());
        return true;
    }

    @Override
    public boolean unlockChunk(Chunk chunk) {
        if (!this.platform.getPlugin().isEnabled()) {
            return false;
        }
        chunk.removePluginChunkTicket(this.platform.getPlugin());
        return true;
    }

    @Override
    public Location getHangingLocation(Entity entity) {
        Location location = entity.getLocation();
        if (!(entity instanceof Hanging)) {
            return location;
        }
        EntityHanging nms = ((CraftHanging)entity).getHandle();
        BlockPosition position = nms.getChunkCoordinates();
        location.setX((double)position.getX());
        location.setY((double)position.getY());
        location.setZ((double)position.getZ());
        return location;
    }

    @Override
    public boolean setRecipeGroup(ShapedRecipe recipe, String group) {
        recipe.setGroup(group);
        return true;
    }

    @Override
    public boolean isSameKey(Plugin plugin, String key, Object keyedObject) {
        if (!(keyedObject instanceof Keyed)) {
            return false;
        }
        String namespace = plugin.getName().toLowerCase(Locale.ROOT);
        key = key.toLowerCase(Locale.ROOT);
        Keyed keyed = (Keyed)keyedObject;
        NamespacedKey namespacedKey = keyed.getKey();
        String keyNamespace = namespacedKey.getNamespace();
        String keyKey = namespacedKey.getKey();
        return keyNamespace.equals(namespace) && keyKey.equals(key);
    }

    @Override
    public boolean isLegacyRecipes() {
        return false;
    }

    @Override
    public boolean setRecipeIngredient(ShapedRecipe recipe, char key, ItemStack ingredient, boolean ignoreDamage) {
        if (ingredient == null) {
            return false;
        }
        try {
            short maxDurability = ingredient.getType().getMaxDurability();
            if (ignoreDamage && maxDurability > 0) {
                ItemMeta meta;
                ArrayList<ItemStack> damaged = new ArrayList<ItemStack>();
                for (short damage = 0; damage < maxDurability && (meta = (ingredient = ingredient.clone()).getItemMeta()) != null && meta instanceof Damageable; damage = (short)(damage + 1)) {
                    Damageable damageable = (Damageable)meta;
                    damageable.setDamage((int)damage);
                    ingredient.setItemMeta(meta);
                    damaged.add(ingredient);
                }
                RecipeChoice.ExactChoice exactChoice = new RecipeChoice.ExactChoice(damaged);
                recipe.setIngredient(key, (RecipeChoice)exactChoice);
                return true;
            }
            RecipeChoice.ExactChoice exactChoice = new RecipeChoice.ExactChoice(ingredient);
            recipe.setIngredient(key, (RecipeChoice)exactChoice);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setAutoBlockState(org.bukkit.block.Block block, Location target, BlockFace facing, boolean physics, Player originator) {
        EnumDirection direction;
        if (block == null || facing == null || target == null) {
            return false;
        }
        IBlockData blockState = ((CraftBlock)block).getNMS();
        if (blockState == null) {
            return false;
        }
        Block nmsBlock = blockState.getBlock();
        ItemStack blockItem = new ItemStack(block.getType());
        EntityPlayer originatorHandle = ((CraftPlayer)originator).getHandle();
        WorldServer world = ((CraftWorld)block.getWorld()).getHandle();
        Object item = this.platform.getItemUtils().getHandle(this.platform.getItemUtils().makeReal(blockItem));
        if (originatorHandle == null || world == null || item == null) {
            return false;
        }
        BlockPosition blockPosition = new BlockPosition(block.getX(), block.getY(), block.getZ());
        Vec3D vec3D = new Vec3D(target.getX(), target.getY(), target.getZ());
        try {
            direction = EnumDirection.valueOf((String)facing.name());
        }
        catch (Exception ex) {
            this.platform.getLogger().log(Level.SEVERE, "Could not translate to NMS direction: " + facing);
            return false;
        }
        MovingObjectPositionBlock hitResult = new MovingObjectPositionBlock(vec3D, direction, blockPosition, false);
        BlockActionContext actionContext = new BlockActionContext((EntityHuman)originatorHandle, EnumHand.a, (net.minecraft.world.item.ItemStack)item, hitResult);
        IBlockData state = nmsBlock.getPlacedState(actionContext);
        if (state == null) {
            return false;
        }
        ((CraftBlock)block).setTypeAndData(state, physics);
        return true;
    }

    @Override
    public boolean forceUpdate(org.bukkit.block.Block block, boolean physics) {
        if (block == null) {
            return false;
        }
        IBlockData blockState = ((CraftBlock)block).getNMS();
        if (blockState == null) {
            return false;
        }
        Block nmsBlock = blockState.getBlock();
        IBlockData blockData = nmsBlock.getBlockData();
        WorldServer world = ((CraftWorld)block.getWorld()).getHandle();
        BlockPosition blockPosition = new BlockPosition(block.getX(), block.getY(), block.getZ());
        world.setTypeAndData(blockPosition, blockData, 11);
        return false;
    }

    @Override
    public int getPhantomSize(Entity entity) {
        if (entity == null || !(entity instanceof Phantom)) {
            return 0;
        }
        return ((Phantom)entity).getSize();
    }

    @Override
    public boolean setPhantomSize(Entity entity, int size) {
        if (entity == null || !(entity instanceof Phantom)) {
            return false;
        }
        ((Phantom)entity).setSize(size);
        return true;
    }

    @Override
    public Location getBedSpawnLocation(Player player) {
        if (player == null) {
            return null;
        }
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        BlockPosition bedLocation = nmsPlayer.getSpawn();
        ResourceKey bedDimension = nmsPlayer.getSpawnDimension();
        if (bedLocation != null && bedDimension != null) {
            CraftWorld world;
            MinecraftServer server = nmsPlayer.getMinecraftServer();
            WorldServer worldServer = server != null ? server.getWorldServer(bedDimension) : null;
            CraftWorld craftWorld = world = worldServer != null ? worldServer.getWorld() : null;
            if (world != null) {
                return new Location((World)world, (double)bedLocation.getX(), (double)bedLocation.getY(), (double)bedLocation.getZ());
            }
        }
        return player.getBedSpawnLocation();
    }

    @Override
    public void loadChunk(World world, int x, int z, boolean generate, Consumer<Chunk> consumer) {
        PaperUtils paperUtils = this.platform.getPaperUtils();
        if (paperUtils == null) {
            Chunk chunk2 = world.getChunkAt(x, z);
            chunk2.load();
            if (consumer != null) {
                consumer.accept(chunk2);
            }
            return;
        }
        LoadingChunk loading = new LoadingChunk(world, x, z);
        Integer requestCount = (Integer)this.loadingChunks.get(loading);
        if (requestCount != null) {
            Integer n = requestCount;
            requestCount = requestCount + 1;
            if (requestCount > 10000) {
                this.platform.getLogger().warning("Exceeded retry count for asynchronous chunk load, loading synchronously");
                if (!this.hasDumpedStack) {
                    this.hasDumpedStack = true;
                    Thread.dumpStack();
                }
                Chunk chunk3 = world.getChunkAt(x, z);
                chunk3.load();
                if (consumer != null) {
                    consumer.accept(chunk3);
                }
                this.loadingChunks.remove(loading);
                return;
            }
            this.loadingChunks.put(loading, requestCount);
            return;
        }
        this.loadingChunks.put(loading, 1);
        paperUtils.loadChunk(world, x, z, generate, chunk -> {
            this.loadingChunks.remove(loading);
            if (consumer != null) {
                consumer.accept((Chunk)chunk);
            }
        });
    }

    @Override
    public void addPassenger(Entity vehicle, Entity passenger) {
        vehicle.addPassenger(passenger);
    }

    @Override
    public List<Entity> getPassengers(Entity entity) {
        return entity.getPassengers();
    }

    @Override
    public boolean openBook(Player player, ItemStack itemStack) {
        player.openBook(itemStack);
        return true;
    }

    @Override
    public boolean isHandRaised(Player player) {
        return player.isHandRaised();
    }

    @Override
    public Class<?> getProjectileClass(String projectileTypeName) {
        return this.projectileClasses.get(projectileTypeName.toLowerCase());
    }

    @Override
    public Entity spawnFireworkEffect(Material fireworkMaterial, Server server, Location location, FireworkEffect effect, int power, Vector direction, Integer expectedLifespan, Integer ticksFlown, boolean silent) {
        CraftEntity entity = null;
        try {
            if (fireworkMaterial == null) {
                return null;
            }
            WorldServer level = ((CraftWorld)location.getWorld()).getHandle();
            ItemStack itemStack = new ItemStack(fireworkMaterial);
            FireworkMeta meta = (FireworkMeta)itemStack.getItemMeta();
            meta.addEffect(effect);
            meta.setPower(power);
            itemStack.setItemMeta((ItemMeta)meta);
            Object item = this.platform.getItemUtils().getHandle(this.platform.getItemUtils().makeReal(itemStack));
            EntityFireworks fireworkHandle = new EntityFireworks((net.minecraft.world.level.World)level, location.getX(), location.getY(), location.getZ(), (net.minecraft.world.item.ItemStack)item);
            fireworkHandle.setSilent(silent);
            if (direction != null) {
                fireworkHandle.setMot(new Vec3D(direction.getX(), direction.getY(), direction.getZ()));
            }
            if (ticksFlown != null) {
                ReflectionUtils.setPrivateNeedsFixing(this.platform.getLogger(), fireworkHandle, EntityFireworks.class, "life", "e", ticksFlown);
            }
            if (expectedLifespan != null) {
                fireworkHandle.f = expectedLifespan;
            }
            if (direction == null) {
                PacketPlayOutSpawnEntity fireworkPacket = new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)fireworkHandle, 76);
                int fireworkId = fireworkHandle.getId();
                DataWatcher watcher = fireworkHandle.getDataWatcher();
                PacketPlayOutEntityMetadata metadataPacket = new PacketPlayOutEntityMetadata(fireworkId, watcher, true);
                PacketPlayOutEntityStatus statusPacket = new PacketPlayOutEntityStatus((net.minecraft.world.entity.Entity)fireworkHandle, 17);
                PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(fireworkId);
                Collection players = server.getOnlinePlayers();
                this.sendPacket(server, location, players, (Packet<?>)fireworkPacket);
                this.sendPacket(server, location, players, (Packet<?>)metadataPacket);
                this.sendPacket(server, location, players, (Packet<?>)statusPacket);
                this.sendPacket(server, location, players, (Packet<?>)destroyPacket);
                return null;
            }
            level.addEntity((net.minecraft.world.entity.Entity)fireworkHandle, CreatureSpawnEvent.SpawnReason.CUSTOM);
            entity = fireworkHandle.getBukkitEntity();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return entity;
    }

    @Override
    public boolean loadAllTagsFromNBT(ConfigurationSection tags, Object tag) {
        if (!(tag instanceof NBTTagCompound)) {
            return false;
        }
        NBTTagCompound compoundTag = (NBTTagCompound)tag;
        Set<String> keys = this.platform.getInventoryUtils().getTagKeys(tag);
        if (keys == null) {
            return false;
        }
        for (String tagName : keys) {
            NBTBase metaBase = compoundTag.get(tagName);
            if (metaBase == null) continue;
            if (metaBase instanceof NBTTagCompound) {
                ConfigurationSection newSection = tags.createSection(tagName);
                this.loadAllTagsFromNBT(newSection, metaBase);
                continue;
            }
            try {
                tags.set(tagName, this.platform.getInventoryUtils().getTagValue(metaBase));
            }
            catch (Exception ex) {
                this.platform.getLogger().log(Level.SEVERE, "Failed to load NBT tags", ex);
                return false;
            }
        }
        return true;
    }

    @Override
    public BoundingBox getHitbox(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB aabb = nmsEntity.getBoundingBox();
        if (aabb == null) {
            return null;
        }
        return new BoundingBox(aabb.a, aabb.d, aabb.b, aabb.e, aabb.c, aabb.f);
    }

    @Override
    public boolean isPrimaryThread() {
        return Bukkit.isPrimaryThread();
    }

    @Override
    public String getEnchantmentKey(Enchantment enchantment) {
        return enchantment.getKey().getKey();
    }

    @Override
    public String translateColors(String message) {
        message = super.translateColors(message);
        Matcher matcher = this.hexColorPattern.matcher(message);
        StringBuffer buffer = new StringBuffer(message.length() + 32);
        while (matcher.find()) {
            String match = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.of((String)match).toString());
        }
        return matcher.appendTail(buffer).toString();
    }
}

