/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base;

import com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.platform.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.platform.InventoryUtils;
import com.elmakers.mine.bukkit.utility.platform.ItemUtils;
import com.elmakers.mine.bukkit.utility.platform.NBTUtils;
import com.elmakers.mine.bukkit.utility.platform.PaperUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.SchematicUtils;
import com.elmakers.mine.bukkit.utility.platform.SkinUtils;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public abstract class PlatformBase
implements Platform {
    private final Logger logger;
    private final Plugin plugin;
    protected boolean valid = false;
    protected CompatibilityUtils compatibilityUtils;
    protected DeprecatedUtils deprecatedUtils;
    protected InventoryUtils inventoryUtils;
    protected ItemUtils itemUtils;
    protected NBTUtils nbtUtils;
    protected SchematicUtils schematicUtils;
    protected SkinUtils skinUtils;
    protected PaperUtils paperUtils;

    public PlatformBase(Plugin plugin, Logger logger) {
        this.plugin = plugin;
        this.logger = logger;
        try {
            World.class.getMethod("getChunkAtAsync", Integer.TYPE, Integer.TYPE, Boolean.TYPE, Consumer.class);
            logger.info("Async chunk loading API found");
            this.paperUtils = new com.elmakers.mine.bukkit.utility.paper.PaperUtils((Platform)this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isLegacy() {
        return false;
    }

    @Override
    public boolean isCurrentVersion() {
        return true;
    }

    @Override
    public boolean hasStatistics() {
        return true;
    }

    @Override
    public boolean hasEntityTransformEvent() {
        return true;
    }

    @Override
    public boolean hasTimeSkipEvent() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public CompatibilityUtils getCompatibilityUtils() {
        return this.compatibilityUtils;
    }

    @Override
    public DeprecatedUtils getDeprecatedUtils() {
        return this.deprecatedUtils;
    }

    @Override
    public InventoryUtils getInventoryUtils() {
        return this.inventoryUtils;
    }

    @Override
    public ItemUtils getItemUtils() {
        return this.itemUtils;
    }

    @Override
    public NBTUtils getNBTUtils() {
        return this.nbtUtils;
    }

    @Override
    public SchematicUtils getSchematicUtils() {
        return this.schematicUtils;
    }

    @Override
    public SkinUtils getSkinUtils() {
        return this.skinUtils;
    }

    @Override
    public PaperUtils getPaperUtils() {
        return this.paperUtils;
    }
}

