/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageContext;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.magic.MagicMetaKeys;
import com.elmakers.mine.bukkit.utility.BoundingBox;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Hit;
import com.elmakers.mine.bukkit.utility.Target;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class Targeting {
    private static final Set<UUID> EMPTY_IGNORE_SET = Collections.emptySet();
    private static final Map<Entity, Hit> projectileHits = new WeakHashMap<Entity, Hit>();
    @Nonnull
    private TargetingResult result = TargetingResult.NONE;
    private Location source = null;
    private Target target = null;
    private List<Target> targets = null;
    @Nonnull
    private TargetType targetType = TargetType.NONE;
    private BlockIterator blockIterator = null;
    private Block currentBlock = null;
    private Block previousBlock = null;
    private Block previousPreviousBlock = null;
    private Vector targetLocationOffset;
    private Vector targetDirectionOverride;
    private String targetLocationWorldName;
    protected float distanceWeight = 1.0f;
    protected float fovWeight = 4.0f;
    protected int npcWeight = -1;
    protected int mageWeight = 5;
    protected int playerWeight = 4;
    protected int livingEntityWeight = 3;
    private boolean ignoreBlocks = false;
    private int targetBreakableDepth = 2;
    private double hitboxPadding = 0.0;
    private double hitboxBlockPadding = 0.0;
    private double rangeQueryPadding = 1.0;
    private boolean useHitbox = true;
    private double fov = 0.3;
    private double closeRange = 0.0;
    private double closeFOV = 0.0;
    private double yOffset = 0.0;
    private boolean targetSpaceRequired = false;
    private int targetMinOffset = 0;
    @Nonnull
    private Set<UUID> ignoreEntities = EMPTY_IGNORE_SET;

    public void reset() {
        this.iterate();
        this.ignoreEntities = EMPTY_IGNORE_SET;
    }

    public void iterate() {
        this.result = TargetingResult.NONE;
        this.source = null;
        this.target = null;
        this.targets = null;
        this.blockIterator = null;
        this.currentBlock = null;
        this.previousBlock = null;
        this.previousPreviousBlock = null;
        this.targetSpaceRequired = false;
        this.targetMinOffset = 0;
        this.yOffset = 0.0;
    }

    protected boolean initializeBlockIterator(Location location, double range) {
        if (this.blockIterator != null) {
            return true;
        }
        if (location.getBlockY() < 0) {
            location = location.clone();
            location.setY(0.0);
        }
        int maxHeight = location.getWorld().getMaxHeight();
        if (location.getBlockY() > maxHeight) {
            location = location.clone();
            location.setY((double)maxHeight);
        }
        try {
            this.blockIterator = new BlockIterator(location, this.yOffset, (int)Math.ceil(range));
        }
        catch (Exception ex) {
            if (Target.DEBUG_TARGETING) {
                Bukkit.getLogger().warning("Exception creating BlockIterator");
                ex.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public Target getOrCreateTarget(Location defaultLocation) {
        if (this.target == null) {
            this.target = new Target(defaultLocation);
        }
        return this.target;
    }

    public Target getTarget() {
        return this.target;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public void setTargetSpaceRequired(boolean required) {
        this.targetSpaceRequired = required;
    }

    public void setTargetMinOffset(int offset) {
        this.targetMinOffset = offset;
    }

    public void targetBlock(Location source, Block block) {
        this.target = new Target(source, block, this.useHitbox, this.hitboxBlockPadding);
    }

    public void setYOffset(int offset) {
        this.yOffset = offset;
    }

    @Nullable
    protected Block getNextBlock() {
        this.previousPreviousBlock = this.previousBlock;
        this.previousBlock = this.currentBlock;
        this.currentBlock = this.blockIterator == null || !this.blockIterator.hasNext() ? null : this.blockIterator.next();
        return this.currentBlock;
    }

    public Block getCurBlock() {
        return this.currentBlock;
    }

    public Block getPreviousBlock() {
        return this.previousBlock;
    }

    public Block getPreviousPreviousBlock() {
        return this.previousPreviousBlock;
    }

    public void setFOV(double fov) {
        this.fov = fov;
    }

    public void setCloseRange(double closeRange) {
        this.closeRange = closeRange;
    }

    public void setCloseFOV(double closeFOV) {
        this.closeFOV = closeFOV;
    }

    public void setUseHitbox(boolean useHitbox) {
        this.useHitbox = useHitbox;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(TargetType type) {
        this.targetType = type;
    }

    public void start(Location source) {
        this.iterate();
        this.source = source.clone();
    }

    public Target overrideTarget(MageContext context, Target target) {
        Location location;
        if (this.targetLocationOffset != null) {
            target.add(this.targetLocationOffset);
        }
        if (this.targetDirectionOverride != null) {
            target.setDirection(this.targetDirectionOverride);
        }
        if (this.targetLocationWorldName != null && this.targetLocationWorldName.length() > 0 && (location = target.getLocation()) != null) {
            World targetWorld = location.getWorld();
            target.setWorld(ConfigurationUtils.overrideWorld(this.targetLocationWorldName, targetWorld, context.getController().canCreateWorlds()));
        }
        this.target = target;
        return target;
    }

    public Target target(MageContext context, double range) {
        if (this.source == null) {
            this.source = context.getEyeLocation();
        }
        this.target = this.findTarget(context, range);
        this.target = this.overrideTarget(context, this.target);
        Mage mage = context.getMage();
        if (mage.getDebugLevel() > 15) {
            Entity targetEntity;
            Location targetLocation = this.target.getLocation();
            String message = "";
            if (this.source != null) {
                message = message + ChatColor.GREEN + "Targeted from " + ChatColor.GRAY + this.source.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + this.source.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + this.source.getBlockZ() + ChatColor.DARK_GREEN + " with range of " + ChatColor.GREEN + range + ChatColor.DARK_GREEN + ": " + ChatColor.GOLD + (Object)((Object)this.result);
            }
            if ((targetEntity = this.target.getEntity()) != null) {
                message = message + ChatColor.DARK_GREEN + " (" + ChatColor.YELLOW + targetEntity.getType() + ChatColor.DARK_GREEN + ")";
            }
            if (targetLocation != null) {
                message = message + ChatColor.DARK_GREEN + " (" + ChatColor.LIGHT_PURPLE + targetLocation.getBlock().getType() + ChatColor.DARK_GREEN + ")";
                message = message + ChatColor.DARK_GREEN + " at " + ChatColor.GRAY + targetLocation.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + targetLocation.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + targetLocation.getBlockZ();
            }
            mage.sendDebugMessage(message);
        }
        return this.target;
    }

    protected Target findTarget(MageContext context, double range) {
        Target targetBlock;
        if (this.targetType == TargetType.NONE) {
            return new Target(this.source);
        }
        boolean isBlock = this.targetType == TargetType.BLOCK || this.targetType == TargetType.SELECT;
        Mage mage = context.getMage();
        Entity mageEntity = mage.getEntity();
        if (this.targetType == TargetType.SELF && mageEntity != null) {
            this.result = TargetingResult.ENTITY;
            return new Target(this.source, mageEntity);
        }
        CommandSender sender = mage.getCommandSender();
        if (this.targetType == TargetType.SELF && mageEntity == null && sender != null && sender instanceof BlockCommandSender) {
            BlockCommandSender commandBlock = (BlockCommandSender)mage.getCommandSender();
            return new Target(commandBlock.getBlock().getLocation(), commandBlock.getBlock());
        }
        if (this.targetType == TargetType.SELF && this.source != null) {
            return new Target(this.source, this.source.getBlock());
        }
        if (this.targetType == TargetType.SELF) {
            return new Target(this.source);
        }
        Block block = null;
        if (!this.ignoreBlocks) {
            this.findTargetBlock(context, range);
            block = this.currentBlock;
        }
        if (isBlock) {
            return new Target(this.source, block, this.useHitbox, this.hitboxBlockPadding);
        }
        Target target = targetBlock = block == null ? null : new Target(this.source, block, this.useHitbox, this.hitboxBlockPadding);
        if (targetBlock != null && this.source != null && this.source.getWorld().equals(block.getWorld()) && !this.result.isMiss()) {
            range = Math.min(range, this.source.distance(targetBlock.getLocation()));
        }
        Target entityTarget = null;
        List<Target> scored = this.getAllTargetEntities(context, range);
        if (scored.size() > 0) {
            entityTarget = scored.get(0);
        }
        if (context instanceof CastContext) {
            CastContext castContext = (CastContext)context;
            if (entityTarget != null && !castContext.canCast(entityTarget.getLocation())) {
                entityTarget = null;
            }
            if (targetBlock != null && !castContext.canCast(targetBlock.getLocation())) {
                this.result = TargetingResult.MISS;
                targetBlock = null;
            }
        }
        if (this.targetType == TargetType.OTHER_ENTITY && entityTarget == null) {
            this.result = TargetingResult.MISS;
            return new Target(this.source);
        }
        if (this.targetType == TargetType.ANY_ENTITY && entityTarget == null) {
            this.result = TargetingResult.ENTITY;
            return new Target(this.source, mageEntity);
        }
        if (entityTarget == null && this.targetType == TargetType.ANY && mageEntity != null) {
            this.result = TargetingResult.ENTITY;
            return new Target(this.source, mageEntity, targetBlock == null ? null : targetBlock.getBlock());
        }
        if (targetBlock != null && entityTarget != null) {
            if (targetBlock.getDistanceSquared() < entityTarget.getDistanceSquared() - this.hitboxPadding * this.hitboxPadding && !this.result.isMiss()) {
                entityTarget = null;
            } else {
                targetBlock = null;
            }
        }
        if (entityTarget != null) {
            this.result = TargetingResult.ENTITY;
            return entityTarget;
        }
        if (targetBlock != null) {
            return targetBlock;
        }
        this.result = TargetingResult.MISS;
        return new Target(this.source);
    }

    protected void findTargetBlock(MageContext context, double range) {
        if (this.source == null || !CompatibilityLib.getCompatibilityUtils().isChunkLoaded(this.source)) {
            return;
        }
        this.currentBlock = this.source.getBlock();
        if (context.isTargetable(this.currentBlock)) {
            this.result = TargetingResult.BLOCK;
            return;
        }
        Location targetLocation = this.source.clone().add(this.source.getDirection().multiply(range));
        if (targetLocation.getBlockX() == this.source.getBlockX() && targetLocation.getBlockY() == this.source.getBlockY() && targetLocation.getBlockZ() == this.source.getBlockZ()) {
            this.result = TargetingResult.MISS;
            return;
        }
        if (!this.initializeBlockIterator(this.source, range)) {
            return;
        }
        Block block = this.getNextBlock();
        this.result = TargetingResult.BLOCK;
        while (block != null) {
            if (this.targetMinOffset <= 0) {
                CastContext castContext;
                if (this.targetSpaceRequired && context instanceof CastContext ? !(castContext = (CastContext)context).allowPassThrough(block) || castContext.isOkToStandIn(block) && castContext.isOkToStandIn(block.getRelative(BlockFace.UP)) : context.isTargetable(block)) {
                    break;
                }
            } else {
                --this.targetMinOffset;
            }
            block = this.getNextBlock();
        }
        if (block == null) {
            this.result = TargetingResult.MISS;
            this.currentBlock = this.previousBlock;
            this.previousBlock = this.previousPreviousBlock;
        }
    }

    public List<Target> getAllTargetEntities(MageContext context, double range) {
        Entity sourceEntity = context.getEntity();
        Mage mage = context.getMage();
        if (this.targets != null) {
            return this.targets;
        }
        this.targets = new ArrayList<Target>();
        double rangePadded = range + this.hitboxPadding + this.rangeQueryPadding;
        rangePadded = Math.min(rangePadded, (double)CompatibilityLib.getCompatibilityUtils().getMaxEntityRange());
        double rangeSquaredPadded = rangePadded * rangePadded;
        Collection<Entity> entities = null;
        boolean debugMessage = true;
        if (this.source == null && sourceEntity != null) {
            this.source = sourceEntity instanceof LivingEntity ? ((LivingEntity)sourceEntity).getEyeLocation() : sourceEntity.getLocation();
        }
        if (this.source != null) {
            Vector queryRange = null;
            Location sourceLocation = this.source;
            if (this.useHitbox) {
                range = Math.min(range, (double)CompatibilityLib.getCompatibilityUtils().getMaxEntityRange());
                Vector direction = this.source.getDirection();
                Location targetLocation = this.source.clone().add(direction.multiply(range));
                BoundingBox bounds = new BoundingBox(this.source.toVector(), targetLocation.toVector());
                bounds.expand(this.hitboxPadding + this.rangeQueryPadding);
                Vector center = bounds.center();
                sourceLocation = new Location(this.source.getWorld(), center.getX(), center.getY(), center.getZ());
                queryRange = bounds.size();
            } else {
                queryRange = new Vector(range * 2.0, range * 2.0, range * 2.0);
                sourceLocation = this.source;
            }
            entities = CompatibilityLib.getCompatibilityUtils().getNearbyEntities(sourceLocation, queryRange.getX() / 2.0, queryRange.getY() / 2.0, queryRange.getZ() / 2.0);
            if (mage.getDebugLevel() > 16) {
                mage.sendDebugMessage(ChatColor.GREEN + "Targeting " + ChatColor.GOLD + entities.size() + ChatColor.GREEN + " entities from " + ChatColor.GRAY + this.source.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + this.source.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + this.source.getBlockZ() + " via bounding box " + ChatColor.GRAY + (int)Math.ceil(queryRange.getX()) + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + (int)Math.ceil(queryRange.getY()) + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + (int)Math.ceil(queryRange.getZ()) + ChatColor.DARK_GREEN + " with range of " + ChatColor.GREEN + range);
                debugMessage = false;
            }
        }
        if (debugMessage && mage.getDebugLevel() > 17 && this.source != null) {
            mage.sendDebugMessage(ChatColor.GREEN + "Targeting entities from " + ChatColor.GRAY + this.source.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + this.source.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + this.source.getBlockZ() + ChatColor.DARK_GREEN + " with range of " + ChatColor.GREEN + range);
        }
        if (entities == null) {
            return this.targets;
        }
        for (Entity entity : entities) {
            Location entityLocation;
            if (this.ignoreEntities.contains(entity.getUniqueId()) || !(entityLocation = entity instanceof LivingEntity ? ((LivingEntity)entity).getEyeLocation() : entity.getLocation()).getWorld().equals(this.source.getWorld()) || entityLocation.distanceSquared(this.source) > rangeSquaredPadded || !context.canTarget(entity)) continue;
            Target newScore = null;
            int useRange = (int)Math.ceil(range + this.hitboxPadding);
            newScore = this.useHitbox ? new Target(this.source, entity, useRange, this.useHitbox, this.hitboxPadding) : new Target(this.source, entity, useRange, this.fov, this.closeRange, this.closeFOV, this.distanceWeight, this.fovWeight, this.mageWeight, this.npcWeight, this.playerWeight, this.livingEntityWeight);
            int requiredDebug = 20;
            if (newScore.getScore() > 0) {
                this.targets.add(newScore);
                requiredDebug = 11;
            }
            if (mage.getDebugLevel() <= requiredDebug) continue;
            String message = ChatColor.DARK_GREEN + "Target " + ChatColor.GREEN + entity.getType() + ChatColor.DARK_GREEN + ": " + ChatColor.YELLOW + newScore.getScore() + ChatColor.DARK_GREEN + ", r2: " + ChatColor.GREEN + (int)newScore.getDistanceSquared() + " / " + useRange * useRange;
            if (!this.useHitbox) {
                message = message + ChatColor.GREEN + ", a: " + newScore.getAngle();
            }
            mage.sendDebugMessage(message);
        }
        Collections.sort(this.targets);
        return this.targets;
    }

    public void parseTargetType(String targetTypeName) {
        this.targetType = TargetType.NONE;
        if (targetTypeName != null) {
            try {
                this.targetType = targetTypeName.equalsIgnoreCase("damager") ? TargetType.LAST_DAMAGER : TargetType.valueOf(targetTypeName.toUpperCase());
            }
            catch (Exception ex) {
                this.targetType = TargetType.NONE;
            }
        }
    }

    public void processParameters(ConfigurationSection parameters) {
        this.parseTargetType(parameters.getString("target"));
        this.useHitbox = parameters.getBoolean("hitbox", !parameters.contains("fov"));
        this.hitboxPadding = parameters.getDouble("hitbox_size", 0.0);
        this.hitboxBlockPadding = parameters.getDouble("hitbox_block_size", 0.0);
        this.rangeQueryPadding = parameters.getDouble("range_padding", 1.0);
        this.fov = parameters.getDouble("fov", 0.3);
        this.closeRange = parameters.getDouble("close_range", 0.0);
        this.closeFOV = parameters.getDouble("close_fov", 0.5);
        this.distanceWeight = (float)parameters.getDouble("distance_weight", 1.0);
        this.fovWeight = (float)parameters.getDouble("fov_weight", 4.0);
        this.npcWeight = parameters.getInt("npc_weight", -1);
        this.playerWeight = parameters.getInt("player_weight", 4);
        this.livingEntityWeight = parameters.getInt("entity_weight", 3);
        this.targetMinOffset = parameters.getInt("target_min_offset", 0);
        this.targetMinOffset = parameters.getInt("tmo", this.targetMinOffset);
        this.ignoreBlocks = parameters.getBoolean("ignore_blocks", false);
        this.targetBreakableDepth = parameters.getInt("target_breakable_depth", 2);
        this.targetLocationOffset = null;
        this.targetDirectionOverride = null;
        Double otxValue = ConfigurationUtils.getDouble(parameters, "otx", null);
        Double otyValue = ConfigurationUtils.getDouble(parameters, "oty", null);
        Double otzValue = ConfigurationUtils.getDouble(parameters, "otz", null);
        if (otxValue != null || otzValue != null || otyValue != null) {
            this.targetLocationOffset = new Vector(otxValue == null ? 0.0 : otxValue, otyValue == null ? 0.0 : otyValue, otzValue == null ? 0.0 : otzValue);
        }
        this.targetLocationWorldName = parameters.getString("otworld");
        Double tdxValue = ConfigurationUtils.getDouble(parameters, "otdx", null);
        Double tdyValue = ConfigurationUtils.getDouble(parameters, "otdy", null);
        Double tdzValue = ConfigurationUtils.getDouble(parameters, "otdz", null);
        if (tdxValue != null || tdzValue != null || tdyValue != null) {
            this.targetDirectionOverride = new Vector(tdxValue == null ? 0.0 : tdxValue, tdyValue == null ? 0.0 : tdyValue, tdzValue == null ? 0.0 : tdzValue);
        }
    }

    public TargetingResult getResult() {
        return this.result;
    }

    public void getTargetEntities(MageContext context, double range, int targetCount, Collection<WeakReference<Entity>> entities) {
        List<Target> candidates = this.getAllTargetEntities(context, range);
        if (targetCount < 0) {
            targetCount = candidates.size();
        }
        for (int i = 0; i < targetCount && i < candidates.size(); ++i) {
            Target target = candidates.get(i);
            entities.add(new WeakReference<Entity>(target.getEntity()));
        }
    }

    protected int breakBlockRecursively(MageContext mageContext, Block block, int depth) {
        if (depth <= 0 || !(mageContext instanceof CastContext)) {
            return 0;
        }
        CastContext context = (CastContext)mageContext;
        if (!context.isBreakable(block)) {
            return 0;
        }
        Location blockLocation = block.getLocation();
        Location effectLocation = blockLocation.add(0.5, 0.5, 0.5);
        context.playEffects("break", 1.0f, context.getLocation(), null, effectLocation, null);
        UndoList undoList = com.elmakers.mine.bukkit.block.UndoList.getUndoList(blockLocation);
        if (undoList != null) {
            undoList.add(block);
        }
        context.clearBreakable(block);
        context.clearReflective(block);
        block.setType(Material.AIR);
        int broken = 1;
        if (depth > broken) {
            broken += this.breakBlockRecursively(context, block.getRelative(BlockFace.UP), Math.min(this.targetBreakableDepth, depth - broken));
            broken += this.breakBlockRecursively(context, block.getRelative(BlockFace.DOWN), Math.min(this.targetBreakableDepth, depth - broken));
            broken += this.breakBlockRecursively(context, block.getRelative(BlockFace.EAST), Math.min(this.targetBreakableDepth, depth - broken));
            broken += this.breakBlockRecursively(context, block.getRelative(BlockFace.WEST), Math.min(this.targetBreakableDepth, depth - broken));
            broken += this.breakBlockRecursively(context, block.getRelative(BlockFace.NORTH), Math.min(this.targetBreakableDepth, depth - broken));
            broken += this.breakBlockRecursively(context, block.getRelative(BlockFace.SOUTH), Math.min(this.targetBreakableDepth, depth - broken));
        }
        return broken;
    }

    public int breakBlock(CastContext context, Block block, double amount) {
        if (amount <= 0.0) {
            return 0;
        }
        Double breakableAmount = context.getBreakable(block);
        if (breakableAmount == null) {
            return 0;
        }
        double breakable = (int)(amount > 1.0 ? amount : (double)(context.getRandom().nextDouble() < amount ? 1 : 0));
        if (breakable <= 0.0) {
            return 0;
        }
        return this.breakBlockRecursively(context, block, (int)Math.ceil(breakableAmount + breakable - 1.0));
    }

    public static void track(Entity tracked) {
        CompatibilityLib.getEntityMetadataUtils().setBoolean(tracked, MagicMetaKeys.TRACKING, true);
    }

    public static boolean checkTracking(Entity tracked, Entity target, Block block) {
        Hit current;
        if (tracked == null || !CompatibilityLib.getEntityMetadataUtils().getBoolean(tracked, MagicMetaKeys.TRACKING)) {
            return false;
        }
        if (target != null) {
            projectileHits.put(tracked, new Hit(target));
        } else if (!(tracked.hasMetadata("hit") || (current = projectileHits.get(tracked)) != null && current.getEntity() != null)) {
            projectileHits.put(tracked, new Hit(block));
        }
        return true;
    }

    public static Hit getHit(Entity tracked) {
        return projectileHits.get(tracked);
    }

    public void ignoreEntity(Entity entity) {
        if (this.ignoreEntities == EMPTY_IGNORE_SET) {
            this.ignoreEntities = new HashSet<UUID>();
        }
        this.ignoreEntities.add(entity.getUniqueId());
    }

    public static enum TargetingResult {
        NONE,
        BLOCK,
        ENTITY,
        MISS;


        public boolean isMiss() {
            return this == MISS || this == NONE;
        }
    }
}

