/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.utility.CompatibilityConstants;
import com.elmakers.mine.bukkit.utility.metadata.EntityMetadataUtils;
import com.elmakers.mine.bukkit.utility.metadata.LegacyEntityMetadataUtils;
import com.elmakers.mine.bukkit.utility.metadata.PersistentEntityMetadataUtils;
import com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.platform.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.platform.InventoryUtils;
import com.elmakers.mine.bukkit.utility.platform.ItemUtils;
import com.elmakers.mine.bukkit.utility.platform.NBTUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.SchematicUtils;
import com.elmakers.mine.bukkit.utility.platform.SkinUtils;
import com.elmakers.mine.bukkit.utility.platform.legacy.LegacyPlatform;
import java.lang.reflect.Constructor;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;

public class CompatibilityLib {
    private static Platform platform;
    private static EntityMetadataUtils metadataUtils;

    public static boolean initialize(Plugin plugin, Logger logger) {
        int[] version = CompatibilityLib.getServerVersion();
        String versionDescription = StringUtils.join((Object[])ArrayUtils.toObject((int[])version), (String)".");
        if (version.length < 2 || version[0] != 1) {
            logger.severe("Could not parse server version: " + versionDescription);
            return false;
        }
        int minorVersion = version[1];
        if (minorVersion < 9) {
            logger.severe("Not compatible with version: " + versionDescription);
            return false;
        }
        if (minorVersion > 16) {
            logger.info("Loading modern compatibility layer for server version " + versionDescription);
            try {
                String versionPackage = StringUtils.join((Object[])ArrayUtils.toObject((int[])version), (String)"_");
                Class<?> platformClass = Class.forName("com.elmakers.mine.bukkit.utility.platform.v" + versionPackage + ".Platform");
                Constructor<?> platformConstructor = platformClass.getConstructor(Plugin.class, Logger.class);
                platform = (Platform)platformConstructor.newInstance(plugin, logger);
            }
            catch (Exception ex) {
                logger.severe("Failed to load compatibility layer, the plugin may need to be updated to work with your server version");
                return false;
            }
        } else {
            logger.info("Loading legacy compatibility layer for server version " + versionDescription);
            platform = new LegacyPlatform(plugin, logger);
        }
        if (CompatibilityLib.hasPersistentMetadata()) {
            metadataUtils = new PersistentEntityMetadataUtils(plugin);
        } else {
            plugin.getLogger().info("Persistent metadata is not available, will rely on custom names to restore persistent magic mobs");
            metadataUtils = new LegacyEntityMetadataUtils(plugin);
        }
        return platform.isValid();
    }

    public static boolean isInitialized() {
        return platform != null;
    }

    public static boolean isLegacy() {
        return platform == null ? false : platform.isLegacy();
    }

    public static boolean isCurrentVersion() {
        return platform == null ? true : platform.isCurrentVersion();
    }

    public static boolean hasStatistics() {
        return platform == null ? true : platform.hasStatistics();
    }

    public static boolean hasEntityTransformEvent() {
        return platform == null ? true : platform.hasEntityTransformEvent();
    }

    public static boolean hasTimeSkipEvent() {
        return platform == null ? true : platform.hasTimeSkipEvent();
    }

    public static boolean isLegacy(Material material) {
        CompatibilityUtils compatibilityUtils = platform == null ? null : platform.getCompatibilityUtils();
        return compatibilityUtils == null ? false : compatibilityUtils.isLegacy(material);
    }

    public static boolean hasLegacyMaterials() {
        CompatibilityUtils compatibilityUtils = platform == null ? null : platform.getCompatibilityUtils();
        return compatibilityUtils == null ? false : compatibilityUtils.hasLegacyMaterials();
    }

    @Nonnull
    public static Logger getLogger() {
        Logger logger = platform == null ? null : platform.getLogger();
        return logger == null ? Bukkit.getLogger() : logger;
    }

    public static Plugin getPlugin() {
        return platform == null ? null : platform.getPlugin();
    }

    public static CompatibilityUtils getCompatibilityUtils() {
        if (platform == null) {
            throw new IllegalStateException("CompatibilityUtils used before being initialized");
        }
        return platform.getCompatibilityUtils();
    }

    public static DeprecatedUtils getDeprecatedUtils() {
        if (platform == null) {
            throw new IllegalStateException("DeprecatedUtils used before being initialized");
        }
        return platform.getDeprecatedUtils();
    }

    public static InventoryUtils getInventoryUtils() {
        if (platform == null) {
            throw new IllegalStateException("InventoryUtils used before being initialized");
        }
        return platform.getInventoryUtils();
    }

    public static ItemUtils getItemUtils() {
        if (platform == null) {
            throw new IllegalStateException("ItemUtils used before being initialized");
        }
        return platform.getItemUtils();
    }

    public static NBTUtils getNBTUtils() {
        if (platform == null) {
            throw new IllegalStateException("NBTUtils used before being initialized");
        }
        return platform.getNBTUtils();
    }

    public static SchematicUtils getSchematicUtils() {
        if (platform == null) {
            throw new IllegalStateException("SchematicUtils used before being initialized");
        }
        return platform.getSchematicUtils();
    }

    public static SkinUtils getSkinUtils() {
        if (platform == null) {
            throw new IllegalStateException("SkinUtils used before being initialized");
        }
        return platform.getSkinUtils();
    }

    public static EntityMetadataUtils getEntityMetadataUtils() {
        return metadataUtils;
    }

    public static int[] getServerVersion() {
        int[] version = new int[3];
        String versionString = CompatibilityConstants.getVersionPrefix();
        if (versionString == null || versionString.isEmpty()) {
            return version;
        }
        versionString = versionString.substring(1);
        try {
            String[] pieces = StringUtils.split((String)versionString, (char)'_');
            if (pieces.length > 0) {
                version[0] = Integer.parseInt(pieces[0]);
            }
            if (pieces.length > 1) {
                version[1] = Integer.parseInt(pieces[1]);
            }
            if (pieces.length > 2) {
                version[2] = Integer.parseInt(pieces[2]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    protected static boolean hasPersistentMetadata() {
        int[] version = CompatibilityLib.getServerVersion();
        if (version[0] <= 1 && version[1] < 16) {
            return false;
        }
        try {
            Class.forName("org.bukkit.persistence.PersistentDataContainer");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

