/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

public class EnchantingController
implements Listener {
    private final MagicController controller;
    private boolean enchantingEnabled = false;
    private boolean disableEnchanting = false;

    public EnchantingController(MagicController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection properties) {
        this.enchantingEnabled = properties.getBoolean("enable_enchanting", this.enchantingEnabled);
        this.disableEnchanting = properties.getBoolean("disable_enchanting", this.disableEnchanting);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEnchantItem(EnchantItemEvent event) {
        ItemStack item = event.getItem();
        Wand wand = this.controller.getIfWand(item);
        if (wand == null) {
            return;
        }
        if (wand.isEnchantable()) {
            Player player = event.getEnchanter();
            if (player == null || !this.controller.hasPermission(player, "Magic.wand.enchant_vanilla")) {
                event.setCancelled(true);
                return;
            }
            wand.setEnchantments(event.getEnchantsToAdd());
            return;
        }
        if (this.enchantingEnabled) {
            Player player = event.getEnchanter();
            if (player == null || !this.controller.hasPermission(player, "Magic.wand.enchant")) {
                event.setCancelled(true);
                return;
            }
            event.getEnchantsToAdd().clear();
            int level = event.getExpLevelCost();
            if (wand.enchant(level, this.controller.getMage(event.getEnchanter())) <= 0) {
                event.setCancelled(true);
            } else {
                event.setCancelled(false);
                event.getEnchantsToAdd().put(null, 0);
            }
            wand.makeEnchantable(true);
        }
    }

    @EventHandler
    public void onPrepareEnchantItem(PrepareItemEnchantEvent event) {
        Wand wand = this.controller.getIfWand(CompatibilityLib.getItemUtils().getCopy(event.getItem()));
        if (wand == null) {
            return;
        }
        if (wand.isEnchantable()) {
            Player player = event.getEnchanter();
            if (player == null || !this.controller.hasPermission(player, "Magic.wand.enchant_vanilla")) {
                event.setCancelled(true);
                return;
            }
        } else {
            if (!this.enchantingEnabled) {
                event.setCancelled(true);
                return;
            }
            Player player = event.getEnchanter();
            if (player == null || !this.controller.hasPermission(player, "Magic.wand.enchant")) {
                event.setCancelled(true);
                return;
            }
            if (!wand.isModifiable() && wand.getPath() == null) {
                event.setCancelled(true);
                return;
            }
            if (this.controller.isSPEnabled() && wand.hasSpellProgression()) {
                event.setCancelled(true);
                return;
            }
            if (!wand.canUse(player)) {
                event.setCancelled(true);
                return;
            }
            wand = this.controller.getIfWand(event.getItem());
            wand.makeEnchantable(true);
            WandUpgradePath path = wand.getPath();
            if (path == null) {
                event.setCancelled(true);
                return;
            }
            int minLevel = path.getMinLevel();
            int maxLevel = path.getMaxLevel();
            int levelRange = maxLevel - minLevel;
            int[] offered = CompatibilityLib.getDeprecatedUtils().getExpLevelCostsOffered(event);
            float bonusLevelMultiplier = path.getBonusLevelMultiplier();
            int bonusLevels = event.getEnchantmentBonus();
            for (int i = 0; i < offered.length; ++i) {
                int level = minLevel + (int)((float)i * (float)levelRange / (float)offered.length);
                if (bonusLevels > 0 && bonusLevelMultiplier > 0.0f) {
                    level = (int)((float)level + (float)bonusLevels * bonusLevelMultiplier);
                }
                offered[i] = level;
            }
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        InventoryType inventoryType = event.getInventory().getType();
        if (inventoryType != InventoryType.ENCHANTING) {
            return;
        }
        InventoryType.SlotType slotType = event.getSlotType();
        if (slotType != InventoryType.SlotType.CRAFTING) {
            return;
        }
        if (this.enchantingEnabled) {
            Wand currentWand;
            Player player;
            HumanEntity clicker = event.getWhoClicked();
            Player player2 = player = clicker instanceof Player ? (Player)clicker : null;
            if (player == null || !this.controller.hasPermission(player, "Magic.wand.enchant")) {
                return;
            }
            ItemStack cursor = event.getCursor();
            Wand cursorWand = this.controller.getIfWand(cursor);
            if (cursorWand != null && cursorWand.isModifiable()) {
                cursorWand.makeEnchantable(true);
            }
            if ((currentWand = this.controller.getIfWand(event.getCurrentItem())) != null && currentWand.isModifiable()) {
                currentWand.makeEnchantable(false);
            }
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (this.disableEnchanting && event.getInventory().getType().equals((Object)InventoryType.ENCHANTING)) {
            event.setCancelled(true);
        }
    }

    public boolean isEnabled() {
        return this.enchantingEnabled;
    }
}

