/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.block.BrushMode;
import com.elmakers.mine.bukkit.api.block.Schematic;
import com.elmakers.mine.bukkit.api.data.BrushData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.maps.BufferedMapCanvas;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.util.Vector;

public class MaterialBrush
extends MaterialAndData
implements com.elmakers.mine.bukkit.api.block.MaterialBrush {
    public static final String ERASE_MATERIAL_KEY = "erase";
    public static final String COPY_MATERIAL_KEY = "copy";
    public static final String CLONE_MATERIAL_KEY = "clone";
    public static final String REPLICATE_MATERIAL_KEY = "replicate";
    public static final String MAP_MATERIAL_KEY = "map";
    public static final String SCHEMATIC_MATERIAL_KEY = "schematic";
    public static final int DEFAULT_MAP_SIZE = 16;
    public static final String[] SPECIAL_MATERIAL_KEYS = new String[]{"erase", "copy", "clone", "replicate", "map"};
    public static MaterialAndData EraseMaterial = new MaterialAndData(Material.PAPER);
    public static MaterialAndData CopyMaterial = new MaterialAndData(Material.PAPER);
    public static MaterialAndData CloneMaterial = new MaterialAndData(Material.PAPER);
    public static MaterialAndData ReplicateMaterial = new MaterialAndData(Material.PAPER);
    public static MaterialAndData MapMaterial = new MaterialAndData(Material.MAP);
    public static MaterialAndData SchematicMaterial = new MaterialAndData(Material.PAPER);
    public static MaterialAndData DefaultBrushMaterial = new MaterialAndData(Material.PAPER);
    public static String EraseCustomIcon;
    public static String CopyCustomIcon;
    public static String CloneCustomIcon;
    public static String ReplicateCustomIcon;
    public static String MapCustomIcon;
    public static String SchematicCustomIcon;
    public static String DefaultBrushCustomIcon;
    public static boolean EraseEnabled;
    public static boolean CopyEnabled;
    public static boolean CloneEnabled;
    public static boolean ReplicateEnabled;
    public static boolean MapEnabled;
    public static boolean SchematicEnabled;
    public static final Material DEFAULT_MATERIAL;
    private static final Map<MaterialAndData, MaterialAndData> replacements;
    private BrushMode mode = BrushMode.MATERIAL;
    private Location cloneSource = null;
    private Location cloneTarget = null;
    private Location materialTarget = null;
    private Vector targetOffset = null;
    private String targetWorldName = null;
    private final Mage mage;
    private final MageController controller;
    private int mapId = -1;
    private BufferedMapCanvas mapCanvas = null;
    private Schematic schematic;
    private String schematicName = "";
    private boolean fillWithAir = true;
    private Vector orientVector = null;
    private Map<String, String> commandMap;
    private MaterialBrush parent;
    private Material mapMaterialBase = null;
    private double scale = 1.0;

    private MaterialBrush(Mage mage) {
        this.mage = mage;
        this.controller = mage != null ? mage.getController() : null;
    }

    public MaterialBrush(Mage mage, Material material, byte data) {
        super(material, data);
        this.mage = mage;
        this.controller = mage != null ? mage.getController() : null;
    }

    public MaterialBrush(Mage mage, Location location, String materialKey) {
        super(DEFAULT_MATERIAL, (short)0);
        this.mage = mage;
        this.controller = mage != null ? mage.getController() : null;
        this.update(materialKey);
        this.activate(location, materialKey);
    }

    public MaterialBrush(Mage mage, Block block) {
        super(block);
        this.mage = mage;
        this.controller = mage != null ? mage.getController() : null;
    }

    public MaterialBrush(String materialKey) {
        this((MageController)null, materialKey);
    }

    public MaterialBrush(MageController controller, String materialKey) {
        super(DEFAULT_MATERIAL, (short)0);
        this.mage = null;
        this.controller = controller;
        this.update(materialKey);
    }

    @Override
    public MaterialBrush getCopy() {
        MaterialBrush newBrush = new MaterialBrush(this.mage);
        newBrush.parent = this;
        this.copyTo(newBrush);
        return newBrush;
    }

    public void copyTo(MaterialBrush other) {
        super.copyTo(other);
        other.mode = this.mode;
        other.cloneSource = this.cloneSource;
        other.cloneTarget = this.cloneTarget;
        other.materialTarget = this.materialTarget;
        other.targetOffset = this.targetOffset;
        other.targetWorldName = this.targetWorldName;
        other.mapId = this.mapId;
        other.mapCanvas = this.mapCanvas;
        other.schematic = this.schematic;
        other.schematicName = this.schematicName;
        other.fillWithAir = this.fillWithAir;
        other.orientVector = this.orientVector;
        other.commandMap = this.commandMap;
        other.mapMaterialBase = this.mapMaterialBase;
        other.scale = this.scale;
    }

    @Override
    public String getKey() {
        String materialKey = null;
        if (this.mode == BrushMode.ERASE) {
            materialKey = ERASE_MATERIAL_KEY;
        } else if (this.mode == BrushMode.COPY) {
            materialKey = COPY_MATERIAL_KEY;
        } else if (this.mode == BrushMode.CLONE) {
            materialKey = CLONE_MATERIAL_KEY;
        } else if (this.mode == BrushMode.MAP) {
            materialKey = MAP_MATERIAL_KEY;
            int mapSize = (int)(128.0 / this.scale);
            if (mapSize != 16) {
                materialKey = materialKey + ":" + mapSize;
            }
        } else {
            materialKey = this.mode == BrushMode.REPLICATE ? REPLICATE_MATERIAL_KEY : (this.mode == BrushMode.SCHEMATIC ? "schematic:" + this.schematicName : super.getKey());
        }
        return materialKey;
    }

    public static boolean isSpecialMaterialKey(String materialKey) {
        if (materialKey == null || materialKey.length() == 0) {
            return false;
        }
        return COPY_MATERIAL_KEY.equals(materialKey = MaterialBrush.splitMaterialKey(materialKey)[0]) || ERASE_MATERIAL_KEY.equals(materialKey) || REPLICATE_MATERIAL_KEY.equals(materialKey) || CLONE_MATERIAL_KEY.equals(materialKey) || MAP_MATERIAL_KEY.equals(materialKey) || SCHEMATIC_MATERIAL_KEY.equals(materialKey);
    }

    public static boolean isSchematic(String materialKey) {
        if (materialKey == null || materialKey.length() == 0) {
            return false;
        }
        materialKey = MaterialBrush.splitMaterialKey(materialKey)[0];
        return SCHEMATIC_MATERIAL_KEY.equals(materialKey);
    }

    public static String getMaterialName(Messages messages, String materialKey) {
        MaterialBrush brush = new MaterialBrush(materialKey);
        return brush.getName(messages);
    }

    @Override
    public String getName() {
        Messages messages = this.mage != null ? this.mage.getController().getMessages() : null;
        return this.getName(messages);
    }

    @Override
    public String getName(Messages messages) {
        String brushKey;
        switch (this.mode) {
            case ERASE: {
                brushKey = ERASE_MATERIAL_KEY;
                if (messages == null) break;
                brushKey = messages.get("wand.erase_material_name");
                break;
            }
            case CLONE: {
                brushKey = CLONE_MATERIAL_KEY;
                if (messages == null) break;
                brushKey = messages.get("wand.clone_material_name");
                break;
            }
            case REPLICATE: {
                brushKey = REPLICATE_MATERIAL_KEY;
                if (messages == null) break;
                brushKey = messages.get("wand.replicate_material_name");
                break;
            }
            case COPY: {
                brushKey = COPY_MATERIAL_KEY;
                if (messages == null) break;
                brushKey = messages.get("wand.copy_material_name");
                break;
            }
            case MAP: {
                brushKey = MAP_MATERIAL_KEY;
                int mapSize = (int)(128.0 / this.scale);
                if (mapSize != 16) {
                    if (messages != null) {
                        brushKey = messages.get("wand.map_material_name_scaled");
                        brushKey = brushKey.replace("$size", Integer.toString(mapSize));
                    } else {
                        brushKey = brushKey + " " + mapSize + "x" + mapSize;
                    }
                } else if (messages != null) {
                    brushKey = messages.get("wand.map_material_name");
                }
                if (this.mapId > 0) {
                    brushKey = brushKey.replace("$id", Integer.toString(this.mapId));
                    break;
                }
                brushKey = brushKey.replace("$id", "");
                break;
            }
            case SCHEMATIC: {
                brushKey = this.schematicName;
                brushKey = brushKey.toLowerCase().replace('_', ' ');
                break;
            }
            default: {
                brushKey = super.getName(messages);
            }
        }
        return brushKey;
    }

    @Nullable
    public static MaterialBrush parseMaterialKey(String materialKey) {
        return MaterialBrush.parseMaterialKey(materialKey, false);
    }

    @Nullable
    public static MaterialBrush parseMaterialKey(String materialKey, boolean allowItems) {
        if (materialKey == null || materialKey.length() == 0) {
            return null;
        }
        MaterialBrush brush = new MaterialBrush(materialKey);
        return brush.isValid(allowItems) ? brush : null;
    }

    public static boolean isValidMaterial(String materialKey, boolean allowItems) {
        MaterialBrush brush = new MaterialBrush(materialKey);
        return brush.isValid(allowItems);
    }

    public boolean isValid(boolean allowItems) {
        if (!this.isValid()) {
            return false;
        }
        if (this.mode != BrushMode.MATERIAL) {
            return true;
        }
        return allowItems || this.material.isBlock();
    }

    @Override
    public void setMaterial(Material material, Short data) {
        if (!(material == null || this.mage != null && this.mage.isRestricted(material, data))) {
            super.setMaterial(material, data);
            this.isValid = true;
        } else {
            this.isValid = false;
        }
        this.isTargetValid = true;
        this.fillWithAir = true;
        this.mode = BrushMode.MATERIAL;
    }

    public void enableCloning() {
        if (!CloneEnabled) {
            this.isValid = false;
            return;
        }
        if (this.mode != BrushMode.CLONE) {
            this.fillWithAir = this.mode == BrushMode.ERASE;
            this.mode = BrushMode.CLONE;
        }
    }

    public void enableErase() {
        if (!EraseEnabled) {
            this.isValid = false;
            return;
        }
        if (this.mode != BrushMode.ERASE) {
            this.setMaterial(Material.AIR);
            this.mode = BrushMode.ERASE;
            this.fillWithAir = true;
        }
    }

    public void enableMap(int size) {
        if (!MapEnabled) {
            this.isValid = false;
            return;
        }
        this.fillWithAir = false;
        if (size <= 0) {
            size = 16;
        }
        this.scale = 128.0f / (float)size;
        this.mode = BrushMode.MAP;
        this.mapMaterialBase = DefaultMaterials.getInstance().getBaseMaterial(this.material);
        if (this.mapId == -1 && this.mage != null) {
            this.mapId = this.mage.getLastHeldMapId();
        }
    }

    public void enableSchematic(String name) {
        if (!SchematicEnabled) {
            this.isValid = false;
            return;
        }
        if (this.mode != BrushMode.SCHEMATIC) {
            this.fillWithAir = this.mode == BrushMode.ERASE;
            this.mode = BrushMode.SCHEMATIC;
        }
        this.schematicName = name;
        this.schematic = null;
    }

    public void clearSchematic() {
        this.schematic = null;
    }

    public void enableReplication() {
        if (!ReplicateEnabled) {
            this.isValid = false;
            return;
        }
        if (this.mode != BrushMode.REPLICATE) {
            this.fillWithAir = this.mode == BrushMode.ERASE;
            this.mode = BrushMode.REPLICATE;
        }
    }

    public void setMapId(int mapId) {
        this.mapCanvas = null;
        this.mapId = mapId;
    }

    public int getMapId() {
        return this.mapId;
    }

    public void setCloneLocation(Location cloneFrom) {
        this.cloneSource = cloneFrom;
        this.materialTarget = cloneFrom;
        this.cloneTarget = null;
    }

    public void clearCloneLocation() {
        this.cloneSource = null;
        this.materialTarget = null;
    }

    public void clearCloneTarget() {
        this.cloneTarget = null;
        this.targetOffset = null;
        this.targetWorldName = null;
    }

    public void setTargetOffset(Vector offset, String worldName) {
        this.targetOffset = offset.clone();
        this.targetWorldName = worldName;
    }

    public boolean hasCloneTarget() {
        return this.cloneSource != null && this.cloneTarget != null;
    }

    public void enableCopying() {
        this.mode = BrushMode.COPY;
    }

    @Override
    public boolean isReady() {
        if ((this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE) && this.materialTarget != null) {
            Block block = this.materialTarget.getBlock();
            return CompatibilityLib.getCompatibilityUtils().isChunkLoaded(block);
        }
        if (this.mode == BrushMode.SCHEMATIC) {
            return this.checkSchematic();
        }
        return true;
    }

    @Nullable
    public Location toTargetLocation(World targetWorld, Location target) {
        if (this.cloneSource == null || this.cloneTarget == null) {
            return null;
        }
        Location translated = this.cloneSource.clone();
        translated.subtract(this.cloneTarget.toVector());
        translated.add(target.toVector());
        if (targetWorld != null) {
            translated.setWorld(targetWorld);
        }
        return translated;
    }

    @Nullable
    public Location toTargetLocation(Location target) {
        return this.toTargetLocation(null, target);
    }

    @Nullable
    public Location fromTargetLocation(World targetWorld, Location target, boolean isBlock) {
        if (this.cloneSource == null || this.cloneTarget == null) {
            return null;
        }
        Location translated = target.clone();
        Vector delta = this.cloneTarget.toVector().subtract(this.cloneSource.toVector());
        if (isBlock) {
            delta.setX((int)delta.getX());
            delta.setY((int)delta.getY());
            delta.setZ((int)delta.getZ());
        }
        translated.add(delta);
        translated.setWorld(targetWorld);
        return translated;
    }

    @Override
    public void update(String activeMaterial) {
        String[] pieces = StringUtils.split((String)activeMaterial, (char)'&');
        if (pieces != null && pieces.length > 0) {
            activeMaterial = pieces[0];
            if (pieces.length > 1) {
                this.update(pieces[1]);
            }
        }
        pieces = MaterialBrush.splitMaterialKey(activeMaterial);
        this.isValid = true;
        this.isTargetValid = true;
        if (activeMaterial.equals(COPY_MATERIAL_KEY)) {
            this.enableCopying();
        } else if (activeMaterial.equals(CLONE_MATERIAL_KEY)) {
            this.enableCloning();
        } else if (activeMaterial.equals(REPLICATE_MATERIAL_KEY)) {
            this.enableReplication();
        } else if (pieces[0].equals(MAP_MATERIAL_KEY)) {
            String[] dataPieces;
            int size = 16;
            if (pieces.length > 1 && (dataPieces = StringUtils.split((String)pieces[1], (String)":", (int)2)).length > 0) {
                try {
                    size = Integer.parseInt(dataPieces[0]);
                }
                catch (Exception ex) {
                    Bukkit.getLogger().info("Error in map brush definition, first part is not an integer: " + activeMaterial);
                }
                if (dataPieces.length > 1) {
                    String mapKey = dataPieces[1];
                    if (this.controller != null && mapKey.startsWith("http")) {
                        this.mapId = this.controller.getMaps().getURLMapId(((World)Bukkit.getWorlds().get(0)).getName(), mapKey);
                    } else {
                        try {
                            this.mapId = Integer.parseInt(mapKey);
                        }
                        catch (Exception ex) {
                            Bukkit.getLogger().info("Error in map brush definition, second part is not an integer or a URL: " + activeMaterial);
                        }
                    }
                }
            }
            this.enableMap(size);
        } else if (activeMaterial.equals(ERASE_MATERIAL_KEY)) {
            this.enableErase();
        } else if (pieces.length > 1 && pieces[0].equals(SCHEMATIC_MATERIAL_KEY)) {
            this.enableSchematic(pieces[1]);
        } else {
            this.mode = BrushMode.MATERIAL;
            super.update(activeMaterial);
        }
    }

    @Override
    public boolean update(Mage fromMage, Location target) {
        Vector diff;
        if (this.parent != null) {
            this.parent.update(fromMage, target);
        }
        if (this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE) {
            if (this.cloneSource == null) {
                this.isTargetValid = false;
                return true;
            }
            if (this.cloneTarget == null) {
                this.cloneTarget = target;
            }
            this.materialTarget = this.toTargetLocation(target);
            if (this.materialTarget.getY() < 0.0 || this.materialTarget.getWorld() == null || this.materialTarget.getY() > (double)this.materialTarget.getWorld().getMaxHeight()) {
                this.isTargetValid = false;
            } else {
                Block block = this.materialTarget.getBlock();
                if (!CompatibilityLib.getCompatibilityUtils().isChunkLoaded(block)) {
                    return false;
                }
                this.updateFromBlock(block, fromMage.getRestrictedMaterialSet());
                boolean bl = this.isTargetValid = this.fillWithAir || this.material != Material.AIR;
            }
        }
        if (this.mode == BrushMode.SCHEMATIC) {
            if (!this.checkSchematic()) {
                return true;
            }
            if (this.cloneTarget == null) {
                this.isTargetValid = false;
                return true;
            }
            diff = target.toVector().subtract(this.cloneTarget.toVector());
            com.elmakers.mine.bukkit.api.block.MaterialAndData newMaterial = this.schematic.getBlock(diff);
            if (newMaterial == null) {
                this.isTargetValid = false;
            } else {
                String commandKey;
                this.updateFrom(newMaterial);
                boolean bl = this.isTargetValid = this.fillWithAir || newMaterial.getMaterial() != Material.AIR;
                if (this.commandMap != null && DefaultMaterials.isCommand(this.material) && (commandKey = this.getCommandLine()) != null && commandKey.length() > 0 && this.commandMap.containsKey(commandKey)) {
                    this.setCommandLine(this.commandMap.get(commandKey));
                }
            }
        }
        if (this.mode == BrushMode.MAP && this.mapId >= 0) {
            if (this.mapCanvas == null) {
                try {
                    MapView mapView = CompatibilityLib.getDeprecatedUtils().getMap(this.mapId);
                    if (mapView != null) {
                        Player player = fromMage != null ? fromMage.getPlayer() : null;
                        List renderers = mapView.getRenderers();
                        if (renderers.size() > 0) {
                            this.mapCanvas = new BufferedMapCanvas();
                            MapRenderer renderer = (MapRenderer)renderers.get(0);
                            renderer.initialize(mapView);
                            renderer.render(mapView, (MapCanvas)this.mapCanvas, player);
                        }
                    }
                }
                catch (Exception ex) {
                    this.controller.getLogger().log(Level.WARNING, "Error reading map id " + this.mapId, ex);
                }
            }
            this.isTargetValid = false;
            if (this.mapCanvas != null && this.cloneTarget != null) {
                diff = target.toVector().subtract(this.cloneTarget.toVector());
                DyeColor mapColor = DyeColor.WHITE;
                mapColor = this.orientVector.getBlockY() > this.orientVector.getBlockZ() || this.orientVector.getBlockY() > this.orientVector.getBlockX() ? (this.orientVector.getBlockX() > this.orientVector.getBlockZ() ? this.mapCanvas.getDyeColor(Math.abs((int)((double)diff.getBlockX() * this.scale + (double)(BufferedMapCanvas.CANVAS_WIDTH / 2)) % BufferedMapCanvas.CANVAS_WIDTH), Math.abs((int)((double)(-diff.getBlockY()) * this.scale + (double)(BufferedMapCanvas.CANVAS_HEIGHT / 2)) % BufferedMapCanvas.CANVAS_HEIGHT)) : this.mapCanvas.getDyeColor(Math.abs((int)((double)diff.getBlockZ() * this.scale + (double)(BufferedMapCanvas.CANVAS_WIDTH / 2)) % BufferedMapCanvas.CANVAS_WIDTH), Math.abs((int)((double)(-diff.getBlockY()) * this.scale + (double)(BufferedMapCanvas.CANVAS_HEIGHT / 2)) % BufferedMapCanvas.CANVAS_HEIGHT))) : this.mapCanvas.getDyeColor(Math.abs((int)((double)diff.getBlockX() * this.scale + (double)(BufferedMapCanvas.CANVAS_WIDTH / 2)) % BufferedMapCanvas.CANVAS_WIDTH), Math.abs((int)((double)diff.getBlockZ() * this.scale + (double)(BufferedMapCanvas.CANVAS_HEIGHT / 2)) % BufferedMapCanvas.CANVAS_HEIGHT));
                if (mapColor != null) {
                    this.material = this.mapMaterialBase;
                    DefaultMaterials.getInstance().colorize(this, mapColor);
                    this.isTargetValid = this.material != null;
                }
            }
        }
        return true;
    }

    protected boolean checkSchematic() {
        if (this.schematic == null && this.mage != null) {
            if (this.schematicName.length() == 0) {
                this.isValid = false;
                return false;
            }
            this.schematic = this.mage.getController().loadSchematic(this.schematicName);
            if (this.schematic == null) {
                this.schematicName = "";
                this.isValid = false;
                return false;
            }
        }
        return this.schematic != null && this.schematic.isLoaded();
    }

    @Override
    public void prepare() {
        if (this.materialTarget != null) {
            CompatibilityLib.getCompatibilityUtils().checkChunk(this.materialTarget);
        }
    }

    public void load(BrushData data) {
        this.cloneSource = data.getCloneLocation();
        this.cloneTarget = data.getCloneTarget();
        this.materialTarget = data.getMaterialTarget();
        this.schematicName = data.getSchematicName();
        this.mapId = data.getMapId();
        this.material = data.getMaterial();
        this.data = data.getMaterialData();
        this.scale = data.getScale();
        this.fillWithAir = data.isFillWithAir();
    }

    public void save(BrushData data) {
        data.setCloneLocation(this.cloneSource);
        data.setCloneTarget(this.cloneTarget);
        data.setMaterialTarget(this.materialTarget);
        data.setSchematicName(this.schematicName);
        data.setMapId(this.mapId);
        data.setMaterial(this.material);
        data.setMaterialData(this.data);
        data.setScale(this.scale);
        data.setFillWithAir(this.fillWithAir);
    }

    @Override
    public boolean hasEntities() {
        return this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE || this.mode == BrushMode.SCHEMATIC;
    }

    @Override
    @Nullable
    public Collection<Entity> getTargetEntities() {
        if (this.cloneTarget == null || this.mage == null) {
            return null;
        }
        if (this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE || this.mode == BrushMode.SCHEMATIC) {
            ArrayList<Entity> targetData = new ArrayList<Entity>();
            World targetWorld = this.cloneTarget.getWorld();
            List targetEntities = targetWorld.getEntities();
            for (Entity entity : targetEntities) {
                if (this.mode == BrushMode.SCHEMATIC && !(entity instanceof Hanging) || entity instanceof Player || this.mage.getController().isNPC(entity)) continue;
                targetData.add(entity);
            }
            return targetData;
        }
        return null;
    }

    protected void addEntities(Collection<Entity> source, Collection<com.elmakers.mine.bukkit.api.entity.EntityData> destination) {
        for (Entity entity : source) {
            if (entity instanceof Player || entity instanceof Item || this.controller.isNPC(entity)) continue;
            EntityData entityData = new EntityData(this.controller, entity);
            Location translated = this.fromTargetLocation(this.cloneTarget.getWorld(), entityData.getLocation(), entity instanceof Hanging);
            entityData.setLocation(translated);
            destination.add(entityData);
        }
    }

    @Override
    @Nullable
    public Collection<com.elmakers.mine.bukkit.api.entity.EntityData> getEntities(Collection<Chunk> chunks) {
        if (this.cloneTarget == null) {
            return null;
        }
        if ((this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE) && this.cloneSource != null) {
            World sourceWorld = this.cloneSource.getWorld();
            ArrayList<com.elmakers.mine.bukkit.api.entity.EntityData> copyEntities = new ArrayList<com.elmakers.mine.bukkit.api.entity.EntityData>();
            if (chunks == null) {
                this.addEntities(sourceWorld.getEntities(), copyEntities);
            } else {
                for (Chunk chunk : chunks) {
                    Location chunkLocation = chunk.getBlock(0, 0, 0).getLocation();
                    chunkLocation = this.toTargetLocation(sourceWorld, chunkLocation);
                    Chunk sourceChunk = chunkLocation.getChunk();
                    sourceChunk.load();
                    this.addEntities(Arrays.asList(sourceChunk.getEntities()), copyEntities);
                }
            }
            return copyEntities;
        }
        if (this.mode == BrushMode.SCHEMATIC && this.schematic != null) {
            return this.schematic.getEntities(this.cloneTarget);
        }
        return null;
    }

    @Override
    @Nullable
    public Collection<com.elmakers.mine.bukkit.api.entity.EntityData> getEntities() {
        return this.getEntities(null);
    }

    @Override
    public void activate(Location location, String material) {
        String materialKey = MaterialBrush.splitMaterialKey(material)[0];
        if ((materialKey.equals(CLONE_MATERIAL_KEY) || materialKey.equals(REPLICATE_MATERIAL_KEY)) && location != null) {
            Location cloneFrom = location.clone();
            cloneFrom.setY(cloneFrom.getY() - 1.0);
            this.setCloneLocation(cloneFrom);
        } else if (materialKey.equals(MAP_MATERIAL_KEY) || materialKey.equals(SCHEMATIC_MATERIAL_KEY)) {
            this.clearCloneTarget();
        }
    }

    @Override
    public void setTarget(Location target) {
        this.setTarget(target, target);
    }

    @Override
    public void setTarget(Location target, Location center) {
        if (target == null || center == null || this.mage == null) {
            return;
        }
        if (this.parent != null) {
            this.parent.setTarget(target, center);
        }
        this.orientVector = target.toVector().subtract(center.toVector());
        this.orientVector.setX(Math.abs(this.orientVector.getX()));
        this.orientVector.setY(Math.abs(this.orientVector.getY()));
        this.orientVector.setZ(Math.abs(this.orientVector.getZ()));
        if (this.mode == BrushMode.REPLICATE || this.mode == BrushMode.CLONE || this.mode == BrushMode.MAP || this.mode == BrushMode.SCHEMATIC) {
            if (this.cloneTarget == null || this.mode == BrushMode.CLONE || !center.getWorld().getName().equals(this.cloneTarget.getWorld().getName())) {
                this.cloneTarget = center.clone();
                if (this.targetOffset != null) {
                    this.cloneTarget = this.cloneTarget.add(this.targetOffset);
                }
            } else if (this.mode == BrushMode.SCHEMATIC) {
                this.checkSchematic();
                boolean recenter = true;
                if (this.schematic != null && this.schematic.isLoaded()) {
                    Vector diff = target.toVector().subtract(this.cloneTarget.toVector());
                    boolean bl = recenter = !this.schematic.contains(diff);
                }
                if (recenter) {
                    this.cloneTarget = center.clone();
                    if (this.targetOffset != null) {
                        this.cloneTarget = this.cloneTarget.add(this.targetOffset);
                    }
                }
            }
            this.cloneTarget.setX((double)this.cloneTarget.getBlockX());
            this.cloneTarget.setY((double)this.cloneTarget.getBlockY());
            this.cloneTarget.setZ((double)this.cloneTarget.getBlockZ());
            if (this.cloneSource == null) {
                this.cloneSource = this.cloneTarget.clone();
                if (this.targetWorldName != null && this.targetWorldName.length() > 0) {
                    World sourceWorld = this.cloneSource.getWorld();
                    this.cloneSource.setWorld(ConfigurationUtils.overrideWorld(this.targetWorldName, sourceWorld, this.mage.getController().canCreateWorlds()));
                }
            }
            if (this.materialTarget == null) {
                this.materialTarget = this.cloneTarget;
            }
        }
        if (this.mode == BrushMode.COPY) {
            Block block = target.getBlock();
            if (this.targetOffset != null) {
                Location targetLocation = block.getLocation();
                targetLocation = targetLocation.add(this.targetOffset);
                block = targetLocation.getBlock();
            }
            this.updateFromBlock(block, this.mage.getRestrictedMaterialSet());
        }
    }

    @Override
    public Vector getSize() {
        if (this.mode != BrushMode.SCHEMATIC) {
            return new Vector(0, 0, 0);
        }
        if (!this.checkSchematic()) {
            return new Vector(0, 0, 0);
        }
        return this.schematic.getSize();
    }

    @Override
    public BrushMode getMode() {
        return this.mode;
    }

    @Override
    public boolean isEraseModifierActive() {
        return this.fillWithAir;
    }

    @Override
    public boolean isErase() {
        return this.mode == BrushMode.ERASE || this.mode == BrushMode.MATERIAL && this.material == Material.AIR;
    }

    @Nullable
    public ItemStack getItem(MageController controller, boolean isItem) {
        ItemMeta meta;
        Messages messages = controller.getMessages();
        boolean urlIcons = this.mage == null ? controller.isUrlIconsEnabled() : this.mage.isUrlIconsEnabled();
        Short data = this.getData();
        MaterialAndData icon = data == null ? new MaterialAndData(this.getMaterial()) : new MaterialAndData(this.getMaterial(), data);
        String extraLore = null;
        String customName = this.getName(messages);
        ItemStack itemStack = null;
        if (this.mode == BrushMode.ERASE) {
            icon = EraseMaterial;
            if (EraseCustomIcon != null && !EraseCustomIcon.isEmpty() && urlIcons) {
                itemStack = controller.getURLSkull(EraseCustomIcon);
            }
            extraLore = messages.get("wand.erase_material_description");
        } else if (this.mode == BrushMode.COPY) {
            icon = CopyMaterial;
            if (CopyCustomIcon != null && !CopyCustomIcon.isEmpty() && urlIcons) {
                itemStack = controller.getURLSkull(CopyCustomIcon);
            }
            extraLore = messages.get("wand.copy_material_description");
        } else if (this.mode == BrushMode.CLONE) {
            icon = CloneMaterial;
            if (CloneCustomIcon != null && !CloneCustomIcon.isEmpty() && urlIcons) {
                itemStack = controller.getURLSkull(CloneCustomIcon);
            }
            extraLore = messages.get("wand.clone_material_description");
        } else if (this.mode == BrushMode.REPLICATE) {
            icon = ReplicateMaterial;
            if (ReplicateCustomIcon != null && !ReplicateCustomIcon.isEmpty() && urlIcons) {
                itemStack = controller.getURLSkull(ReplicateCustomIcon);
            }
            extraLore = messages.get("wand.replicate_material_description");
        } else if (this.mode == BrushMode.MAP) {
            icon = MapMaterial;
            if (MapCustomIcon != null && !MapCustomIcon.isEmpty() && urlIcons) {
                itemStack = controller.getURLSkull(MapCustomIcon);
            }
            extraLore = messages.get("wand.map_material_description");
        } else if (this.mode == BrushMode.SCHEMATIC) {
            icon = SchematicMaterial;
            if (SchematicCustomIcon != null && !SchematicCustomIcon.isEmpty() && urlIcons) {
                itemStack = controller.getURLSkull(SchematicCustomIcon);
            }
            extraLore = messages.get("wand.schematic_material_description").replace("$schematic", this.schematicName);
        } else {
            MaterialAndData replacementMaterial = replacements.get(icon);
            if (replacementMaterial != null) {
                icon = replacementMaterial;
            }
            extraLore = messages.get("wand.building_material_description").replace("$material", customName);
        }
        if (itemStack == null) {
            itemStack = icon.getItemStack(1);
            itemStack = CompatibilityLib.getItemUtils().makeReal(itemStack);
            if (itemStack == null) {
                if (DefaultBrushCustomIcon != null && !DefaultBrushCustomIcon.isEmpty() && urlIcons) {
                    itemStack = controller.getURLSkull(DefaultBrushCustomIcon);
                }
                if (itemStack == null) {
                    itemStack = DefaultBrushMaterial.getItemStack(1);
                    itemStack = CompatibilityLib.getItemUtils().makeReal(itemStack);
                    if (itemStack == null) {
                        return itemStack;
                    }
                }
            }
        }
        if ((meta = itemStack.getItemMeta()) == null) {
            return null;
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (extraLore != null) {
            lore.add(ChatColor.LIGHT_PURPLE + extraLore);
        }
        if (this.blockData != null && !this.blockData.isEmpty()) {
            ConfigurationUtils.addIfNotEmpty(messages.get("brush.block_data_description").replace("$data", this.blockData), lore);
        }
        if (isItem) {
            ConfigurationUtils.addIfNotEmpty(messages.get("wand.brush_item_description"), lore);
        }
        meta.setLore(lore);
        if (customName != null) {
            meta.setDisplayName(customName);
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static void configureReplacements(ConfigurationSection replacementConfig) {
        replacements.clear();
        if (replacementConfig == null) {
            return;
        }
        Set keys = replacementConfig.getKeys(false);
        for (String key : keys) {
            MaterialAndData toMaterial = ConfigurationUtils.getMaterialAndData(replacementConfig, key);
            MaterialAndData fromMaterial = ConfigurationUtils.toMaterialAndData(key);
            replacements.put(fromMaterial, toMaterial);
        }
    }

    public void colorize(DyeColor color) {
        DefaultMaterials.getInstance().colorize(this, color);
    }

    @Override
    public String toString() {
        return (Object)((Object)this.mode) + ": " + super.toString();
    }

    public void addCommandMapping(String key, String command) {
        if (this.commandMap == null) {
            this.commandMap = new HashMap<String, String>();
        }
        this.commandMap.put(key, command);
    }

    @Override
    protected boolean allowContainers() {
        return this.mage == null ? super.allowContainers() : this.mage.allowContainerCopy();
    }

    static {
        EraseEnabled = true;
        CopyEnabled = true;
        CloneEnabled = true;
        ReplicateEnabled = true;
        MapEnabled = true;
        SchematicEnabled = true;
        DEFAULT_MATERIAL = Material.DIRT;
        replacements = new HashMap<MaterialAndData, MaterialAndData>();
    }
}

