/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.listener;

import com.elmakers.mine.bukkit.magic.listener.ChunkLoadListener;
import com.elmakers.mine.bukkit.tasks.CheckChunkTask;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.world.MagicWorld;
import com.elmakers.mine.bukkit.world.WorldController;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Chunk;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;

public class WorldSpawnListener
implements Listener,
ChunkLoadListener {
    private final WorldController controller;
    private Set<CreatureSpawnEvent.SpawnReason> ignoreReasons = new HashSet<CreatureSpawnEvent.SpawnReason>();
    private int processedSpawns = 0;
    private int processedChunkSpawns = 0;

    public WorldSpawnListener(WorldController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection config) {
        List<String> reasonList = ConfigurationUtils.getStringList(config, "ignore_reasons");
        this.ignoreReasons.clear();
        if (reasonList != null) {
            for (String reason : reasonList) {
                try {
                    CreatureSpawnEvent.SpawnReason ignoreReason = CreatureSpawnEvent.SpawnReason.valueOf((String)reason.toUpperCase());
                    this.ignoreReasons.add(ignoreReason);
                }
                catch (Exception ex) {
                    this.controller.getLogger().warning("Invalid spawn reason in ignore_reasons: " + reason);
                }
            }
        }
    }

    @Override
    public void onChunkLoad(Chunk chunk) {
        MagicWorld magicWorld = this.controller.getWorld(chunk.getWorld().getName());
        if (magicWorld == null) {
            return;
        }
        Plugin plugin = this.controller.getPlugin();
        this.controller.setDisableSpawnReplacement(true);
        for (Entity testEntity : chunk.getEntities()) {
            if (!(testEntity instanceof LivingEntity)) continue;
            LivingEntity entity = (LivingEntity)testEntity;
            try {
                if (!magicWorld.processEntitySpawn(plugin, entity)) continue;
                ++this.processedChunkSpawns;
                entity.remove();
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.SEVERE, "Error replacing mob", ex);
            }
        }
        this.controller.setDisableSpawnReplacement(false);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChunkLoad(ChunkLoadEvent event) {
        if (this.controller.isDisableSpawnReplacement() || this.ignoreReasons.contains(CreatureSpawnEvent.SpawnReason.CHUNK_GEN) || !event.isNewChunk()) {
            return;
        }
        Chunk chunk = event.getChunk();
        if (!this.controller.isDataLoaded()) {
            CheckChunkTask.defer(this.controller.getPlugin(), this, chunk);
        } else {
            this.onChunkLoad(chunk);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntitySpawn(CreatureSpawnEvent event) {
        if (this.controller.isDisableSpawnReplacement() || this.ignoreReasons.contains(event.getSpawnReason())) {
            return;
        }
        MagicWorld magicWorld = this.controller.getWorld(event.getLocation().getWorld().getName());
        if (magicWorld == null) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Plugin plugin = this.controller.getPlugin();
        this.controller.setDisableSpawnReplacement(true);
        try {
            if (magicWorld.processEntitySpawn(plugin, entity)) {
                entity.remove();
                event.setCancelled(true);
                ++this.processedSpawns;
            }
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.SEVERE, "Error replacing mob", ex);
        }
        this.controller.setDisableSpawnReplacement(false);
    }

    public int getProcessedSpawns() {
        return this.processedSpawns;
    }

    public int getProcessedChunkSpawns() {
        return this.processedChunkSpawns;
    }
}

