/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import org.bukkit.inventory.ItemStack;

public class WandInventory {
    public final ItemStack[] items;

    public WandInventory(int size) {
        this.items = new ItemStack[size];
    }

    public int getSize() {
        return this.items.length;
    }

    public ItemStack getItem(int index) {
        if (index < 0 || index >= this.items.length) {
            throw new IllegalArgumentException("WandInventory index out of range: " + index + " not between 0 and " + (this.items.length - 1));
        }
        return this.items[index];
    }

    public void setItem(int index, ItemStack item) {
        if (index < 0 || index >= this.items.length) {
            throw new IllegalArgumentException("WandInventory index out of range: " + index + " not between 0 and " + (this.items.length - 1));
        }
        this.items[index] = item;
    }

    public boolean addItem(ItemStack item) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != null) continue;
            this.items[i] = item;
            return true;
        }
        return false;
    }

    public void clear() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = null;
        }
    }

    public ItemStack[] getContents() {
        return this.items;
    }
}

