/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import org.bukkit.configuration.ConfigurationSection;

public class SpellBlock {
    private final String rightClickSpell;
    private final String rightClickSneakSpell;
    private final boolean requiresWand;
    private final boolean requiresSpellProgression;
    private final boolean cancelClick;

    public SpellBlock(ConfigurationSection configuration) {
        this.rightClickSpell = configuration.getString("right_click");
        this.rightClickSneakSpell = configuration.getString("right_click_sneak");
        this.requiresWand = configuration.getBoolean("requires_wand", false);
        this.requiresSpellProgression = configuration.getBoolean("requires_spell_progression", false);
        this.cancelClick = configuration.getBoolean("cancel_click", true);
    }

    public SpellBlock(String rightClick, String sneakClick, boolean requiresWand) {
        this.rightClickSpell = rightClick;
        this.rightClickSneakSpell = sneakClick;
        this.requiresWand = requiresWand;
        this.requiresSpellProgression = true;
        this.cancelClick = true;
    }

    public String getRightClickSpell() {
        return this.rightClickSpell;
    }

    public String getRightClickSneakSpell() {
        return this.rightClickSneakSpell;
    }

    public boolean requiresWand() {
        return this.requiresWand;
    }

    public boolean requiresSpellProgression() {
        return this.requiresSpellProgression;
    }

    public boolean isCancelClick() {
        return this.cancelClick;
    }
}

