/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class ModelEngineManager {
    private final ModelEngineAPI api;
    private final Plugin owningPlugin;

    public ModelEngineManager(Plugin owningPlugin, Plugin modelEnginePlugin) {
        this.owningPlugin = owningPlugin;
        this.api = modelEnginePlugin instanceof ModelEngineAPI ? (ModelEngineAPI)modelEnginePlugin : null;
    }

    public boolean isValid() {
        return this.api != null;
    }

    public boolean applyModel(Entity entity, ConfigurationSection config) {
        if (config == null || entity == null) {
            return false;
        }
        String modelName = config.getString("id");
        ActiveModel model = this.api.getModelManager().createActiveModel(modelName);
        if (model == null) {
            return false;
        }
        ModeledEntity modeledEntity = this.api.getModelManager().createModeledEntity(entity);
        if (modeledEntity == null) {
            return false;
        }
        modeledEntity.addActiveModel(model);
        modeledEntity.detectPlayers();
        modeledEntity.setInvisible(config.getBoolean("invisible", true));
        return true;
    }
}

