/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.magic.SourceLocation;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class ChangeContextAction
extends CompoundAction {
    private Vector sourceOffset;
    private Vector relativeSourceOffset;
    private Vector targetOffset;
    private Vector relativeTargetOffset;
    private boolean sourceIsCaster;
    private boolean targetCaster;
    private Boolean targetSelf;
    private boolean useParentTargetEntity;
    private boolean useParentSourceEntity;
    private boolean targetEntityLocation;
    private boolean sourceAtTarget;
    private boolean sourceIsTarget;
    private boolean sourceDirectionAtTarget;
    private boolean sourceDirectionIsTarget;
    private Double sourcePitch;
    private Vector randomSourceOffset;
    private Vector randomTargetOffset;
    private Double targetDirectionSpeed;
    private Double sourceDirectionSpeed;
    private Vector sourceDirection;
    private Vector targetDirection;
    private Vector sourceDirectionOffset;
    private Vector targetDirectionOffset;
    private float relativeSourceDirectionYawOffset;
    private float relativeSourceDirectionPitchOffset;
    private float relativeTargetDirectionYawOffset;
    private float relativeTargetDirectionPitchOffset;
    private float sourceYawOffset;
    private float sourcePitchOffset;
    private float targetYawOffset;
    private float targetPitchOffset;
    private String absoluteTargetLocation;
    private String absoluteSourceLocation;
    private SourceLocation sourceLocation;
    private SourceLocation targetLocation;
    private boolean persistTarget;
    private boolean attachBlock;
    private boolean persistCaster;
    private int snapTargetToSize;
    private int sourcePitchMin;
    private int sourcePitchMax;
    private boolean orientPitch;
    private boolean swapSourceAndTarget;
    private boolean sourceUseMovementDirection;
    private boolean targetUseMovementDirection;
    private boolean useTargetMage;
    private MaterialSet destructible;
    private MaterialSet indestructible;
    protected Vector direction;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        String indestructibleKey;
        super.prepare(context, parameters);
        this.useParentTargetEntity = parameters.getBoolean("use_parent_target_entity", false);
        this.useParentSourceEntity = parameters.getBoolean("use_parent_source_entity", false);
        this.useTargetMage = parameters.getBoolean("use_target_mage", false);
        this.targetEntityLocation = parameters.getBoolean("target_entity", false);
        this.targetCaster = parameters.getBoolean("target_caster", false);
        this.sourceIsCaster = parameters.getBoolean("source_is_caster", false);
        this.targetSelf = parameters.contains("target_self") ? Boolean.valueOf(parameters.getBoolean("target_self")) : null;
        this.sourceAtTarget = parameters.getBoolean("source_at_target", false);
        this.sourceIsTarget = parameters.getBoolean("source_is_target", false);
        this.sourceUseMovementDirection = parameters.getBoolean("source_use_movement_direction", false);
        this.targetUseMovementDirection = parameters.getBoolean("target_use_movement_direction", false);
        this.sourceDirectionIsTarget = parameters.getBoolean("source_direction_is_target", false);
        this.sourceDirectionAtTarget = parameters.getBoolean("source_direction_at_target", false);
        this.sourcePitch = ConfigurationUtils.getDouble(parameters, "source_pitch", null);
        this.sourceOffset = ConfigurationUtils.getVector(parameters, "source_offset");
        this.relativeSourceOffset = ConfigurationUtils.getVector(parameters, "relative_source_offset");
        this.targetOffset = ConfigurationUtils.getVector(parameters, "target_offset");
        this.relativeTargetOffset = ConfigurationUtils.getVector(parameters, "relative_target_offset");
        this.randomTargetOffset = ConfigurationUtils.getVector(parameters, "random_target_offset");
        this.randomSourceOffset = ConfigurationUtils.getVector(parameters, "random_source_offset");
        this.sourceDirection = ConfigurationUtils.getVector(parameters, "source_direction");
        this.targetDirection = ConfigurationUtils.getVector(parameters, "target_direction");
        this.sourceDirectionOffset = ConfigurationUtils.getVector(parameters, "source_direction_offset");
        this.targetDirectionOffset = ConfigurationUtils.getVector(parameters, "target_direction_offset");
        this.relativeSourceDirectionYawOffset = (float)parameters.getDouble("source_relative_direction_yaw_offset", 0.0);
        this.relativeSourceDirectionPitchOffset = (float)parameters.getDouble("source_relative_direction_pitch_offset", 0.0);
        this.relativeTargetDirectionYawOffset = (float)parameters.getDouble("target_relative_direction_yaw_offset", 0.0);
        this.relativeTargetDirectionPitchOffset = (float)parameters.getDouble("target_relative_direction_pitch_offset", 0.0);
        this.persistTarget = parameters.getBoolean("persist_target", false);
        this.attachBlock = parameters.getBoolean("target_attachment", false);
        this.persistCaster = parameters.getBoolean("persist_caster", false);
        this.snapTargetToSize = parameters.getInt("target_snap", 0);
        this.sourcePitchMin = parameters.getInt("source_pitch_min", 90);
        this.sourcePitchMax = parameters.getInt("source_pitch_max", -90);
        this.orientPitch = parameters.getBoolean("orient_pitch", true);
        this.sourceYawOffset = (float)parameters.getDouble("source_yaw_offset", 0.0);
        this.sourcePitchOffset = (float)parameters.getDouble("source_pitch_offset", 0.0);
        this.targetYawOffset = (float)parameters.getDouble("target_yaw_offset", 0.0);
        this.targetPitchOffset = (float)parameters.getDouble("target_pitch_offset", 0.0);
        this.swapSourceAndTarget = parameters.getBoolean("swap_source_and_target", false);
        String destructibleKey = parameters.getString("destructible_materials");
        if (destructibleKey != null && !destructibleKey.isEmpty()) {
            this.destructible = context.getController().getMaterialSetManager().fromConfig(destructibleKey);
        }
        if ((indestructibleKey = parameters.getString("indestructible_materials")) != null && !indestructibleKey.isEmpty()) {
            this.indestructible = context.getController().getMaterialSetManager().fromConfig(indestructibleKey);
        }
        this.absoluteTargetLocation = parameters.getString("target_location");
        this.absoluteSourceLocation = parameters.getString("source_location");
        this.targetLocation = SourceLocation.tryCreate(this.absoluteTargetLocation, false);
        if (this.targetLocation != null) {
            this.absoluteTargetLocation = null;
        }
        this.sourceLocation = SourceLocation.tryCreate(this.absoluteSourceLocation, true);
        if (this.sourceLocation != null) {
            this.absoluteSourceLocation = null;
        }
        this.targetDirectionSpeed = parameters.contains("target_direction_speed") ? Double.valueOf(parameters.getDouble("target_direction_speed")) : null;
        this.sourceDirectionSpeed = parameters.contains("source_direction_speed") ? Double.valueOf(parameters.getDouble("source_direction_speed")) : null;
    }

    protected Location modifySource(Location sourceLocation, CastContext context, Entity targetEntity) {
        Location relativeSource;
        boolean updateDirection = false;
        if (this.sourceDirectionIsTarget && targetEntity != null && sourceLocation != null) {
            sourceLocation.setDirection(targetEntity.getLocation().getDirection());
        }
        if (this.sourceUseMovementDirection && sourceLocation != null) {
            sourceLocation.setDirection(context.getMage().getVelocity());
        }
        if (this.sourceDirection != null && sourceLocation != null) {
            sourceLocation.setDirection(this.sourceDirection);
            updateDirection = true;
        }
        if (this.sourcePitch != null && sourceLocation != null) {
            sourceLocation.setPitch((float)this.sourcePitch.doubleValue());
            updateDirection = true;
        }
        if (this.sourceYawOffset != 0.0f && sourceLocation != null) {
            sourceLocation.setYaw(sourceLocation.getYaw() + this.sourceYawOffset);
            updateDirection = true;
        }
        if (this.sourcePitchOffset != 0.0f && sourceLocation != null) {
            sourceLocation.setPitch(sourceLocation.getPitch() + this.sourcePitchOffset);
            updateDirection = true;
        }
        if (sourceLocation != null && sourceLocation.getPitch() > (float)this.sourcePitchMin) {
            sourceLocation.setPitch((float)this.sourcePitchMin);
            updateDirection = true;
        } else if (sourceLocation != null && sourceLocation.getPitch() < (float)this.sourcePitchMax) {
            sourceLocation.setPitch((float)this.sourcePitchMax);
            updateDirection = true;
        }
        if (sourceLocation != null && this.sourceOffset != null) {
            sourceLocation = sourceLocation.add(this.sourceOffset);
        }
        if (this.relativeSourceOffset != null && sourceLocation != null && (relativeSource = this.persistCaster ? context.getMage().getEyeLocation() : sourceLocation) != null) {
            if (!this.orientPitch) {
                relativeSource.setPitch(0.0f);
            }
            Vector offset = VectorUtils.rotateVector(this.relativeSourceOffset, relativeSource);
            sourceLocation.add(offset);
        }
        if (this.randomSourceOffset != null && sourceLocation != null) {
            sourceLocation = RandomUtils.randomizeLocation(sourceLocation, this.randomSourceOffset);
        }
        if ((this.relativeSourceDirectionYawOffset != 0.0f || this.relativeSourceDirectionPitchOffset != 0.0f) && sourceLocation != null) {
            Vector relativeDirection = sourceLocation.getDirection();
            relativeDirection = VectorUtils.rotateVector(relativeDirection, this.relativeSourceDirectionYawOffset, this.relativeSourceDirectionPitchOffset);
            sourceLocation.setDirection(relativeDirection);
            updateDirection = true;
        }
        if (updateDirection && sourceLocation != null) {
            this.direction = sourceLocation.getDirection();
        }
        if (this.sourceDirectionOffset != null && sourceLocation != null && this.direction != null) {
            sourceLocation.setDirection(this.direction.add(this.sourceDirectionOffset));
        }
        if (this.sourceDirectionSpeed != null && sourceLocation != null && this.direction != null) {
            sourceLocation = sourceLocation.add(this.direction.clone().multiply(this.sourceDirectionSpeed.doubleValue()));
        }
        return sourceLocation;
    }

    protected Location modifyTarget(Location targetLocation, CastContext context, Entity targetEntity) {
        if (this.snapTargetToSize > 0 && targetLocation != null) {
            int x = targetLocation.getBlockX();
            int z = targetLocation.getBlockZ();
            int xresult = x / this.snapTargetToSize;
            int zresult = z / this.snapTargetToSize;
            boolean xneedfix = x % this.snapTargetToSize != 0;
            boolean zneedfix = z % this.snapTargetToSize != 0;
            targetLocation.setX((double)(this.snapTargetToSize * (xresult - (x < 0 && xneedfix ? 1 : 0))));
            targetLocation.setZ((double)(this.snapTargetToSize * (zresult - (z < 0 && zneedfix ? 1 : 0))));
        }
        if (this.targetOffset != null && targetLocation != null) {
            targetLocation = targetLocation.add(this.targetOffset);
        }
        if (this.relativeTargetOffset != null && targetLocation != null) {
            Location relativeTarget = this.persistCaster ? context.getMage().getEyeLocation() : targetLocation;
            if (!this.orientPitch) {
                relativeTarget.setPitch(0.0f);
            }
            Vector offset = VectorUtils.rotateVector(this.relativeTargetOffset, relativeTarget);
            targetLocation.add(offset);
        }
        if (this.randomTargetOffset != null && targetLocation != null) {
            targetLocation = RandomUtils.randomizeLocation(targetLocation, this.randomTargetOffset);
        }
        if (this.targetUseMovementDirection && targetLocation != null) {
            Mage targetMage = context.getController().getRegisteredMage(targetEntity);
            if (targetMage != null) {
                targetLocation.setDirection(targetMage.getVelocity());
            } else if (targetEntity != null) {
                targetLocation.setDirection(targetEntity.getVelocity());
            }
        }
        if (this.targetDirection != null && targetLocation != null) {
            targetLocation.setDirection(this.targetDirection);
        }
        if (targetLocation != null && this.targetYawOffset != 0.0f) {
            targetLocation.setYaw(targetLocation.getYaw() + this.targetYawOffset);
        }
        if (targetLocation != null && this.targetPitchOffset != 0.0f) {
            targetLocation.setPitch(targetLocation.getPitch() + this.targetPitchOffset);
        }
        if (targetLocation != null && (this.relativeTargetDirectionYawOffset != 0.0f || this.relativeTargetDirectionPitchOffset != 0.0f)) {
            Vector relativeDirection = targetLocation.getDirection();
            relativeDirection = VectorUtils.rotateVector(relativeDirection, this.relativeTargetDirectionYawOffset, this.relativeTargetDirectionPitchOffset);
            targetLocation.setDirection(relativeDirection);
        }
        if (this.targetDirectionOffset != null && targetLocation != null) {
            targetLocation.setDirection(targetLocation.getDirection().add(this.targetDirectionOffset));
        }
        if (this.targetDirectionSpeed != null && targetLocation != null) {
            targetLocation = targetLocation.add(this.direction.clone().multiply(this.targetDirectionSpeed.doubleValue()));
        }
        return targetLocation;
    }

    @Override
    public SpellResult step(CastContext context) {
        CastContext parent;
        Mage sourceMage = null;
        Entity sourceEntity = context.getEntity();
        Location sourceLocation = context.getEyeLocation();
        Entity targetEntity = context.getTargetEntity();
        Location targetLocation = context.getTargetLocation();
        if (this.useTargetMage) {
            sourceMage = context.getController().getMage(targetEntity);
        }
        if (sourceLocation != null) {
            sourceLocation = sourceLocation.clone();
        }
        if (this.absoluteSourceLocation != null && !this.absoluteSourceLocation.isEmpty()) {
            Vector newSource = ConfigurationUtils.toVector(this.absoluteSourceLocation);
            if (newSource != null) {
                if (sourceLocation == null) {
                    World world = context.getWorld();
                    if (world == null) {
                        return SpellResult.WORLD_REQUIRED;
                    }
                    sourceLocation = new Location(world, newSource.getX(), newSource.getY(), newSource.getZ());
                } else {
                    sourceLocation.setX(newSource.getX());
                    sourceLocation.setY(newSource.getY());
                    sourceLocation.setZ(newSource.getZ());
                }
            } else {
                context.getLogger().warning("Invalid source location in spell " + context.getSpell().getKey() + ": " + this.absoluteSourceLocation);
            }
        }
        Block targetBlock = null;
        Block previousBlock = null;
        if (targetLocation != null) {
            targetLocation = targetLocation.clone();
            if (this.absoluteTargetLocation != null && !this.absoluteTargetLocation.isEmpty()) {
                Vector newTarget = ConfigurationUtils.toVector(this.absoluteTargetLocation);
                if (newTarget != null) {
                    targetLocation.setX(newTarget.getX());
                    targetLocation.setY(newTarget.getY());
                    targetLocation.setZ(newTarget.getZ());
                } else {
                    context.getLogger().warning("Invalid target location in spell " + context.getSpell().getKey() + ": " + this.absoluteTargetLocation);
                }
            }
        }
        if (this.swapSourceAndTarget) {
            Entity swapEntity = targetEntity;
            targetEntity = sourceEntity;
            sourceEntity = swapEntity;
            Location swapLocation = targetLocation;
            targetLocation = sourceLocation;
            sourceLocation = swapLocation;
        }
        if (this.useParentTargetEntity) {
            Entity parentTargetEntity = null;
            for (parent = context.getParent(); parentTargetEntity == null && parent != null; parent = parent.getParent()) {
                parentTargetEntity = parent.getTargetEntity();
            }
            targetEntity = parentTargetEntity;
        }
        if (this.useParentSourceEntity) {
            Entity parentSourceEntity = null;
            for (parent = context.getParent(); parentSourceEntity == null && parent != null; parent = parent.getParent()) {
                parentSourceEntity = parent.getEntity();
            }
            sourceEntity = parentSourceEntity;
        }
        this.direction = context.getDirection();
        if (this.direction != null) {
            this.direction.normalize();
        }
        if (this.targetCaster) {
            targetEntity = sourceEntity;
            targetLocation = sourceLocation;
        } else if (this.targetEntityLocation && targetEntity != null) {
            targetLocation = targetEntity.getLocation();
        }
        if (this.attachBlock && (previousBlock = context.getPreviousBlock()) != null) {
            Location current = targetLocation;
            targetBlock = previousBlock;
            context.getBrush().setTarget(current, current);
            previousBlock = context.getPreviousPreviousBlock();
        }
        sourceLocation = this.modifySource(sourceLocation, context, targetEntity);
        targetLocation = this.modifyTarget(targetLocation, context, targetEntity);
        if (this.sourceDirectionAtTarget && targetLocation != null && sourceLocation != null) {
            sourceLocation.setDirection(targetLocation.toVector().subtract(sourceLocation.toVector()));
        }
        if (this.sourceAtTarget && targetLocation != null && sourceLocation != null) {
            sourceLocation.setX(targetLocation.getX());
            sourceLocation.setY(targetLocation.getY());
            sourceLocation.setZ(targetLocation.getZ());
            sourceLocation.setWorld(targetLocation.getWorld());
            sourceLocation = this.modifySource(sourceLocation, context, targetEntity);
        }
        if (this.persistTarget) {
            context.setTargetLocation(targetLocation);
        }
        if (sourceLocation != null) {
            context.getMage().sendDebugMessage(ChatColor.GREEN + " Set new source location to " + ChatColor.GRAY + sourceLocation.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + sourceLocation.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + sourceLocation.getBlockZ() + ChatColor.DARK_GRAY, 6);
        }
        if (targetLocation != null) {
            context.getMage().sendDebugMessage(ChatColor.DARK_GREEN + " Set new target location to " + ChatColor.GRAY + targetLocation.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + targetLocation.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + targetLocation.getBlockZ() + ChatColor.DARK_GRAY, 6);
        }
        if (this.sourceIsTarget) {
            sourceEntity = targetEntity;
        }
        if (this.sourceIsCaster) {
            sourceEntity = context.getMage().getEntity();
            sourceLocation = null;
        }
        this.createActionContext(context, sourceMage, sourceEntity, sourceLocation, targetEntity, targetLocation);
        if (this.targetSelf != null) {
            this.actionContext.setTargetsCaster(this.targetSelf);
        }
        if (targetBlock != null) {
            this.actionContext.setTargetBlock(targetBlock);
        }
        if (previousBlock != null) {
            this.actionContext.setPreviousBlock(previousBlock);
        }
        if (this.sourceLocation != null) {
            this.actionContext.setLocation(this.sourceLocation.getLocation(this.actionContext));
        }
        if (this.targetLocation != null) {
            this.actionContext.setTargetLocation(this.targetLocation.getLocation(this.actionContext));
        }
        if (this.destructible != null) {
            this.actionContext.setDestructible(this.destructible);
        }
        if (this.indestructible != null) {
            this.actionContext.setIndestructible(this.indestructible);
        }
        return this.startActions();
    }
}

