/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.heroes;

import com.elmakers.mine.bukkit.api.attributes.AttributeProvider;
import com.elmakers.mine.bukkit.api.entity.TeamProvider;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.heroes.HeroesSkillSpell;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.ManaController;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class HeroesManager
implements ManaController,
AttributeProvider,
TeamProvider {
    private Heroes heroes;
    private CharacterManager characters;
    private SkillManager skills;
    private static final Set<String> emptySkills = new HashSet<String>();
    private static final List<String> emptySkillList = new ArrayList<String>();
    private final Logger log;
    private Method getHeroAttributeMethod;
    private static final Map<String, Enum<?>> attributes = new HashMap();

    public HeroesManager(Plugin plugin, Plugin heroesPlugin) {
        this.log = plugin.getLogger();
        if (!(heroesPlugin instanceof Heroes)) {
            this.log.warning("Heroes found, but is not instance of Heroes plugin!");
            return;
        }
        this.heroes = (Heroes)heroesPlugin;
        try {
            Enum[] values;
            Class<?> classAttributeType = Class.forName("com.herocraftonline.heroes.attributes.AttributeType");
            for (Enum value : values = (Enum[])classAttributeType.getEnumConstants()) {
                attributes.put(value.name().toLowerCase(), value);
            }
            this.getHeroAttributeMethod = Hero.class.getMethod("getAttributeValue", classAttributeType);
            this.log.info("Registered Heroes attributes for use in spell parameters: " + this.getAllAttributes());
        }
        catch (Exception ex) {
            attributes.clear();
            this.getHeroAttributeMethod = null;
            this.log.info("Could not register Heroes attributes, you may need to update Heroes");
        }
        plugin.getServer().getScheduler().runTaskLater(plugin, new Runnable(){

            @Override
            public void run() {
                HeroesManager.this.finishIntegration();
            }
        }, 2L);
    }

    public void finishIntegration() {
        this.characters = this.heroes.getCharacterManager();
        this.skills = this.heroes.getSkillManager();
        if (this.characters != null && this.skills != null) {
            this.log.info("Heroes found, skills available for wand and hotbar use.");
            this.log.info("Give Magic.commands.mskills permission for /mskills command");
            this.log.info("Use \"/wand heroes\" for a wand that uses Heroes skills");
        } else {
            this.log.warning("Heroes found, but failed to integrate!");
            if (this.characters == null) {
                this.log.warning(" CharacterManager is null");
            }
            if (this.skills == null) {
                this.log.warning(" SkillManager is null");
            }
        }
    }

    public boolean canUseSkill(Player player, String skillName) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return false;
        }
        return hero.canUseSkill(skillName);
    }

    public List<String> getSkillList(Player player, boolean showUnuseable, boolean showPassive) {
        if (this.skills == null) {
            return emptySkillList;
        }
        Hero hero = this.getHero(player);
        if (hero == null) {
            return emptySkillList;
        }
        HeroClass heroClass = hero.getHeroClass();
        HeroClass secondClass = hero.getSecondClass();
        HashSet<String> primarySkills = new HashSet<String>();
        HashSet<String> secondarySkills = new HashSet<String>();
        this.addSkills(hero, heroClass, primarySkills, showUnuseable, showPassive);
        this.addSkills(hero, secondClass, secondarySkills, showUnuseable, showPassive);
        secondarySkills.removeAll(primarySkills);
        Multimap<Integer, Skill> primaryMap = this.mapSkillsByLevel(hero, primarySkills);
        Multimap<Integer, Skill> secondaryMap = this.mapSkillsByLevel(hero, secondarySkills);
        ArrayList<String> skillNames = new ArrayList<String>();
        for (Skill skill : primaryMap.values()) {
            skillNames.add(skill.getName());
        }
        for (Skill skill : secondaryMap.values()) {
            skillNames.add(skill.getName());
        }
        return skillNames;
    }

    private Multimap<Integer, Skill> mapSkillsByLevel(Hero hero, Collection<String> skillNames) {
        TreeMultimap skillMap = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)new Comparator<Skill>(){

            @Override
            public int compare(Skill skill1, Skill skill2) {
                return skill1.getName().compareTo(skill2.getName());
            }
        });
        for (String skillName : skillNames) {
            Skill skill = this.skills.getSkill(skillName);
            if (skill == null) continue;
            int level = SkillConfigManager.getUseSetting((Hero)hero, (Skill)skill, (SkillSetting)SkillSetting.LEVEL, (int)1, (boolean)true);
            skillMap.put((Object)level, (Object)skill);
        }
        return skillMap;
    }

    public int getSkillLevel(Player player, String skillName) {
        Skill skill = this.skills.getSkill(skillName);
        if (skill == null) {
            return 0;
        }
        Hero hero = this.getHero(player);
        if (hero == null) {
            return 0;
        }
        return SkillConfigManager.getUseSetting((Hero)hero, (Skill)skill, (SkillSetting)SkillSetting.LEVEL, (int)1, (boolean)true);
    }

    private void addSkills(Hero hero, HeroClass heroClass, Collection<String> skillSet, boolean showUnuseable, boolean showPassive) {
        if (heroClass != null) {
            Set classSkills = heroClass.getSkillNames();
            for (String classSkill : classSkills) {
                Skill skill = this.skills.getSkill(classSkill);
                if (!showUnuseable && !hero.canUseSkill(skill) || !showPassive && !(skill instanceof ActiveSkill) || !SkillConfigManager.getRaw((Skill)skill, (String)"wand", (String)"true").equalsIgnoreCase("true")) continue;
                skillSet.add(classSkill);
            }
        }
    }

    public Set<String> getSkills(Player player) {
        return this.getSkills(player, false, false);
    }

    public Set<String> getSkills(Player player, boolean showUnuseable, boolean showPassive) {
        if (this.skills == null) {
            return emptySkills;
        }
        Hero hero = this.getHero(player);
        if (hero == null) {
            return emptySkills;
        }
        HashSet<String> skillSet = new HashSet<String>();
        HeroClass heroClass = hero.getHeroClass();
        HeroClass secondClass = hero.getSecondClass();
        this.addSkills(hero, heroClass, skillSet, showUnuseable, showPassive);
        this.addSkills(hero, secondClass, skillSet, showUnuseable, showPassive);
        return skillSet;
    }

    public void clearCooldown(Player player) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return;
        }
        hero.clearCooldowns();
    }

    public void setCooldown(Player player, long ms) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return;
        }
        long cooldown = System.currentTimeMillis() + ms;
        Set<String> skills = this.getSkills(player, false, false);
        for (String skill : skills) {
            Long currentCooldown = hero.getCooldown(skill);
            if (currentCooldown != null && currentCooldown >= cooldown) continue;
            hero.setCooldown(skill, cooldown);
        }
    }

    public void reduceCooldown(Player player, long ms) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return;
        }
        Set<String> skills = this.getSkills(player, false, false);
        for (String skill : skills) {
            Long currentCooldown = hero.getCooldown(skill);
            if (currentCooldown == null) continue;
            hero.setCooldown(skill, Math.max(0L, currentCooldown - ms));
        }
    }

    @Nullable
    public SpellTemplate createSkillSpell(MagicController controller, String skillName) {
        if (this.skills == null) {
            return null;
        }
        Skill skill = this.skills.getSkill(skillName);
        if (skill == null) {
            return null;
        }
        HeroesSkillSpell newSpell = new HeroesSkillSpell();
        newSpell.initialize(controller);
        ConfigurationSection config = ConfigurationUtils.newConfigurationSection();
        String iconURL = SkillConfigManager.getRaw((Skill)skill, (String)"icon-url", (String)SkillConfigManager.getRaw((Skill)skill, (String)"icon_url", null));
        if (iconURL == null || iconURL.isEmpty()) {
            String icon = SkillConfigManager.getRaw((Skill)skill, (String)"icon", null);
            if (icon == null || icon.isEmpty()) {
                config.set("icon", (Object)controller.getDefaultSkillIcon());
            } else if (icon.startsWith("http://")) {
                config.set("icon_url", (Object)icon);
            } else {
                config.set("icon", (Object)icon);
            }
        } else {
            config.set("icon_url", (Object)iconURL);
        }
        String iconDisabledURL = SkillConfigManager.getRaw((Skill)skill, (String)"icon-disabled-url", (String)SkillConfigManager.getRaw((Skill)skill, (String)"icon_disabled_url", null));
        if (iconDisabledURL == null || iconDisabledURL.isEmpty()) {
            String icon = SkillConfigManager.getRaw((Skill)skill, (String)"icon-disabled", (String)SkillConfigManager.getRaw((Skill)skill, (String)"icon_disabled", null));
            if (icon != null && !icon.isEmpty()) {
                if (icon.startsWith("http://")) {
                    config.set("icon_disabled_url", (Object)icon);
                } else {
                    config.set("icon_disabled", (Object)icon);
                }
            }
        } else {
            config.set("icon_disabled_url", (Object)iconDisabledURL);
        }
        String nameTemplate = controller.getMessages().get("skills.item_name", "$skill");
        String skillDisplayName = SkillConfigManager.getRaw((Skill)skill, (String)"name", (String)skill.getName());
        config.set("name", (Object)nameTemplate.replace("$skill", skillDisplayName));
        config.set("category", (Object)"skills");
        String descriptionTemplate = controller.getMessages().get("skills.item_description", "$description");
        descriptionTemplate = descriptionTemplate.replace("$description", SkillConfigManager.getRaw((Skill)skill, (String)"description", (String)""));
        config.set("description", (Object)descriptionTemplate);
        newSpell.loadTemplate("heroes*" + skillName, config);
        return newSpell;
    }

    public String getClassName(Player player) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return "";
        }
        HeroClass heroClass = hero.getHeroClass();
        if (heroClass == null) {
            return "";
        }
        return heroClass.getName();
    }

    public String getSecondaryClassName(Player player) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return "";
        }
        HeroClass heroClass = hero.getSecondClass();
        if (heroClass == null) {
            return "";
        }
        return heroClass.getName();
    }

    @Nullable
    protected Skill getSkill(String key) {
        if (this.skills == null) {
            return null;
        }
        return this.skills.getSkill(key);
    }

    @Nullable
    protected Hero getHero(Player player) {
        if (this.characters == null) {
            return null;
        }
        return this.characters.getHero(player);
    }

    @Override
    public int getMaxMana(Player player) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return 0;
        }
        return hero.getMaxMana();
    }

    @Override
    public int getManaRegen(Player player) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return 0;
        }
        return hero.getManaRegen();
    }

    @Override
    public float getMana(Player player) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return 0.0f;
        }
        return hero.getMana();
    }

    @Override
    public void removeMana(Player player, float amount) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return;
        }
        hero.setMana(Math.max(0, hero.getMana() - (int)amount));
    }

    @Override
    public void setMana(Player player, float amount) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return;
        }
        hero.setMana((int)amount);
    }

    public boolean isInParty(Player source, Player check, boolean pvpCheck) {
        Hero sourceHero = this.getHero(source);
        Hero checkHero = this.getHero(check);
        if (sourceHero == null || checkHero == null) {
            return false;
        }
        HeroParty party = sourceHero.getParty();
        if (party == null || pvpCheck && !party.isNoPvp().booleanValue()) {
            return false;
        }
        return party.getMembers().contains(checkHero);
    }

    @Override
    public boolean isFriendly(Entity attacker, Entity entity) {
        if (attacker instanceof Player && entity instanceof Player) {
            return this.isInParty((Player)attacker, (Player)entity, false);
        }
        return false;
    }

    @Override
    public Set<String> getAllAttributes() {
        return attributes.keySet();
    }

    @Override
    @Nullable
    public Double getAttributeValue(String attribute, Player player) {
        Double result = null;
        Hero hero = this.getHero(player);
        if (hero == null) {
            return null;
        }
        try {
            Enum<?> attributeType;
            if (this.getHeroAttributeMethod != null && (attributeType = attributes.get(attribute)) != null) {
                result = (double)((Integer)this.getHeroAttributeMethod.invoke((Object)hero, attributeType));
            }
        }
        catch (Exception ex) {
            this.log.log(Level.WARNING, "Failed read Hero attribute", ex);
        }
        return result;
    }
}

