/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.effect.EffectContext;
import com.google.common.base.Preconditions;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class MageContext
extends EffectContext
implements com.elmakers.mine.bukkit.api.magic.MageContext {
    @Nonnull
    protected final Mage mage;

    public MageContext(@Nonnull Mage mage) {
        super(mage.getController());
        this.mage = (Mage)Preconditions.checkNotNull((Object)mage);
    }

    @Override
    @Nonnull
    public Mage getMage() {
        return this.mage;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.getMage().getName();
    }

    @Override
    @Nullable
    public Location getLocation() {
        if (this.location != null) {
            return this.location;
        }
        return this.mage.getLocation();
    }

    @Override
    @Nullable
    public Location getCastLocation() {
        return this.getEyeLocation();
    }

    @Override
    @Nullable
    public Location getWandLocation() {
        return this.getCastLocation();
    }

    @Override
    public Location getEyeLocation() {
        if (this.location != null) {
            return this.location;
        }
        return this.mage.getEyeLocation();
    }

    @Override
    public Entity getEntity() {
        return this.mage.getEntity();
    }

    @Override
    @Nullable
    public LivingEntity getLivingEntity() {
        return this.mage.getLivingEntity();
    }

    @Override
    @Nullable
    public Color getEffectColor() {
        return this.mage.getEffectColor();
    }

    @Override
    @Nullable
    public String getEffectParticle() {
        return this.mage.getEffectParticleName();
    }

    @Override
    public boolean canTarget(Entity entity) {
        return true;
    }

    @Override
    public boolean canTarget(Entity entity, Class<?> targetType) {
        return true;
    }

    @Override
    @Nullable
    public Wand getWand() {
        return this.mage.getActiveWand();
    }

    @Override
    @Nullable
    public Wand checkWand() {
        return this.mage.checkWand();
    }

    @Override
    public boolean isTargetable(Block block) {
        return true;
    }

    @Override
    public Logger getLogger() {
        return this.getController().getLogger();
    }

    @Override
    @Nonnull
    public CasterProperties getActiveProperties() {
        return this.mage.getActiveProperties();
    }

    @Override
    @Nullable
    public Double getAttribute(String attributeKey) {
        return this.mage.getAttribute(attributeKey);
    }

    @Override
    @Nullable
    public Double getVariable(String variable) {
        ConfigurationSection mageVariables = this.mage.getVariables();
        if (mageVariables != null && mageVariables.contains(variable)) {
            return mageVariables.getDouble(variable);
        }
        return null;
    }

    @Override
    @Nonnull
    public String getMessage(String key) {
        return this.getMessage(key, "");
    }

    @Override
    @Nonnull
    public String getMessage(String key, String def) {
        return this.controller.getMessages().get(key, def);
    }
}

