/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityAnimalData;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Player;

public class EntityFoxData
extends EntityAnimalData {
    private Fox.Type type;
    private UUID firstTrusted;
    private UUID secondTrusted;
    private boolean crouching;

    public EntityFoxData() {
    }

    public EntityFoxData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        String secondTrusted;
        String trusted;
        Logger log = controller.getLogger();
        String typeString = parameters.getString("fox_type");
        if (typeString != null && !typeString.isEmpty()) {
            try {
                this.type = Fox.Type.valueOf((String)typeString.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid fox_type: " + typeString, ex);
            }
        }
        if ((trusted = parameters.getString("trusted")) != null && !trusted.isEmpty()) {
            try {
                this.firstTrusted = UUID.fromString(trusted);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid trusted UUID: " + trusted, ex);
            }
        }
        if ((secondTrusted = parameters.getString("second_trusted")) != null && !secondTrusted.isEmpty()) {
            try {
                this.secondTrusted = UUID.fromString(secondTrusted);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid trusted UUID: " + secondTrusted, ex);
            }
        }
        this.crouching = parameters.getBoolean("crouching");
    }

    public EntityFoxData(Entity entity) {
        super(entity);
        if (entity instanceof Fox) {
            AnimalTamer second;
            Fox fox = (Fox)entity;
            this.type = fox.getFoxType();
            AnimalTamer trusted = fox.getFirstTrustedPlayer();
            if (trusted != null) {
                this.firstTrusted = trusted.getUniqueId();
            }
            if ((second = fox.getSecondTrustedPlayer()) != null) {
                this.secondTrusted = second.getUniqueId();
            }
            this.crouching = fox.isCrouching();
        }
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (entity instanceof Fox) {
            OfflinePlayer trusted;
            Fox fox = (Fox)entity;
            if (this.type != null) {
                fox.setFoxType(this.type);
            }
            if (this.firstTrusted != null && (trusted = Bukkit.getOfflinePlayer((UUID)this.firstTrusted)) != null) {
                fox.setFirstTrustedPlayer((AnimalTamer)trusted);
            }
            if (this.secondTrusted != null && (trusted = Bukkit.getOfflinePlayer((UUID)this.secondTrusted)) != null) {
                fox.setSecondTrustedPlayer((AnimalTamer)trusted);
            }
            fox.setCrouching(this.crouching);
        }
    }

    public static boolean tame(Player tamer, Entity entity) {
        if (!(entity instanceof Fox)) {
            return false;
        }
        if (tamer == null) {
            return false;
        }
        Fox fox = (Fox)entity;
        AnimalTamer current = fox.getFirstTrustedPlayer();
        if (current != null && current.getUniqueId().equals(tamer.getUniqueId())) {
            return false;
        }
        fox.setFirstTrustedPlayer((AnimalTamer)tamer);
        return true;
    }
}

