/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.configuration;

import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.bukkit.util.NumberConversions;

public class TranslatingConfigurationSection
extends MemorySection {
    private static Logger logger;
    private ConfigurationSection parameterMap;

    public static void setLogger(Logger log) {
        logger = log;
    }

    protected static void warn(String message) {
        if (logger != null) {
            logger.warning(message);
        }
    }

    protected TranslatingConfigurationSection() {
    }

    public TranslatingConfigurationSection(ConfigurationSection parent, String path) {
        super(parent, path);
    }

    public TranslatingConfigurationSection(ConfigurationSection copy) {
        super(copy.getParent(), copy.getName());
    }

    public static TranslatingConfigurationSection getWrapped(ConfigurationSection wrap) {
        TranslatingConfigurationSection newSection = new TranslatingConfigurationSection(wrap);
        newSection.wrap(wrap);
        return newSection;
    }

    public void wrap(ConfigurationSection wrap) {
        Map<String, Object> data = NMSUtils.getMap(wrap);
        if (data != null) {
            NMSUtils.setMap((ConfigurationSection)this, data);
        }
    }

    public TranslatingConfigurationSection newSection(String key) {
        return this.createSection(this, key);
    }

    protected TranslatingConfigurationSection createSection(TranslatingConfigurationSection parent, String key) {
        return new TranslatingConfigurationSection((ConfigurationSection)parent, key);
    }

    public ConfigurationSection createSection(String path) {
        int i2;
        Validate.notEmpty((String)path, (String)"Cannot create section at empty path");
        Configuration root = this.getRoot();
        if (root == null) {
            throw new IllegalStateException("Cannot create section without a root");
        }
        char separator = root.options().pathSeparator();
        int i1 = -1;
        TranslatingConfigurationSection section = this;
        while ((i1 = path.indexOf(separator, i2 = i1 + 1)) != -1) {
            String node = path.substring(i2, i1);
            ConfigurationSection subSection = section.getConfigurationSection(node);
            if (subSection == null) {
                section = section.createSection(node);
                continue;
            }
            section = subSection;
        }
        String key = path.substring(i2);
        if (section == this) {
            TranslatingConfigurationSection result = this.createSection(this, key);
            this.map.put(key, result);
            return result;
        }
        return section.createSection(key);
    }

    public Object get(String path, Object def) {
        String stringValue;
        Object rawValue;
        if (this.parameterMap != null && (rawValue = super.get(path, def)) != null && rawValue instanceof String && (stringValue = (String)rawValue).startsWith("$") && this.parameterMap.contains(stringValue = stringValue.substring(1))) {
            return this.parameterMap.get(stringValue);
        }
        return super.get(path, def);
    }

    public int getInt(String path, int def) {
        Object val = this.get(path, def);
        if (val instanceof String) {
            try {
                return Integer.parseInt((String)val);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return val instanceof Number ? NumberConversions.toInt((Object)val) : def;
    }

    public boolean isInt(String path) {
        Object val = this.get(path);
        if (val instanceof String) {
            try {
                Integer.parseInt((String)val);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return val instanceof Integer;
    }

    public double getDouble(String path, double def) {
        Object val = this.get(path, def);
        if (val instanceof String) {
            try {
                return Double.parseDouble((String)val);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return val instanceof Number ? NumberConversions.toDouble((Object)val) : def;
    }

    public boolean isDouble(String path) {
        Object val = this.get(path);
        if (val instanceof String) {
            try {
                Double.parseDouble((String)val);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return val instanceof Double;
    }

    public long getLong(String path, long def) {
        Object val = this.get(path, def);
        if (val instanceof String) {
            try {
                return Long.parseLong((String)val);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return val instanceof Number ? NumberConversions.toLong((Object)val) : def;
    }

    public boolean isLong(String path) {
        Object val = this.get(path);
        if (val instanceof String) {
            try {
                Long.parseLong((String)val);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return val instanceof Long;
    }

    public boolean getBoolean(String path, boolean def) {
        Object val = this.get(path, def);
        if (val instanceof String) {
            String s = (String)val;
            if (s.equalsIgnoreCase("true")) {
                return true;
            }
            if (s.equalsIgnoreCase("false")) {
                return false;
            }
        }
        return val instanceof Boolean ? (Boolean)val : def;
    }

    public boolean isBoolean(String path) {
        Object val = this.get(path);
        if (val == null) {
            return false;
        }
        if (val instanceof String) {
            String s = (String)val;
            return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false");
        }
        return val instanceof Boolean;
    }

    @Nullable
    public ConfigurationSection getConfigurationSection(String path) {
        Object val = this.get(path, null);
        if (val != null) {
            if (val instanceof Map) {
                return ConfigurationUtils.toConfigurationSection((ConfigurationSection)this, path, (Map)val);
            }
            return val instanceof ConfigurationSection ? (ConfigurationSection)val : null;
        }
        val = this.get(path, this.getDefault(path));
        return val instanceof ConfigurationSection ? this.createSection(path) : null;
    }

    public boolean isConfigurationSection(String path) {
        Object val = this.get(path);
        return val instanceof ConfigurationSection || val instanceof Map;
    }

    public void set(String key, Object value) {
        if (value instanceof Map) {
            value = ConfigurationUtils.toConfigurationSection((ConfigurationSection)this, key, (Map)value);
        }
        super.set(key, value);
    }

    public List<String> getStringList(String path) {
        if (this.isString(path)) {
            return Arrays.asList(StringUtils.split((String)this.getString(path), (char)','));
        }
        return super.getStringList(path);
    }

    public void setParameterMap(ConfigurationSection parameterMap) {
        this.parameterMap = parameterMap;
    }
}

