/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.automata;

import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.automata.Automaton;
import com.elmakers.mine.bukkit.automata.AutomatonTemplate;
import com.elmakers.mine.bukkit.automata.Nearby;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class Spawner {
    @Nonnull
    private final MageController controller;
    @Nonnull
    private final Deque<WeightedPair<EntityData>> entityTypeProbability;
    @Nonnull
    private final Deque<WeightedPair<Integer>> countProbability;
    private final Set<String> entityNames = new HashSet<String>();
    private final Set<EntityType> entityTypes = new HashSet<EntityType>();
    private boolean randomizeYaw = false;
    private boolean randomizePitch = false;
    private final int playerRange;
    private final int minPlayers;
    private final double probability;
    private final int limit;
    private final int limitRange;
    private final int verticalRange;
    private final int checkRadius;
    private final int verticalCheckRadius;
    private final boolean checkFloor;
    private final double radius;
    private final double verticalRadius;
    private final int locationRetry;
    private final MaterialSet passthrough;
    private final boolean track;
    private final boolean leash;
    private int interval;

    public Spawner(@Nonnull MageController controller, @Nonnull AutomatonTemplate automaton, ConfigurationSection configuration) {
        this.controller = controller;
        ConfigurationSection entityParameters = configuration.getConfigurationSection("parameters");
        this.entityTypeProbability = new ArrayDeque<WeightedPair<EntityData>>();
        ArrayDeque<WeightedPair<String>> keyProbability = new ArrayDeque<WeightedPair<String>>();
        RandomUtils.populateStringProbabilityMap(keyProbability, configuration, "mobs");
        if (keyProbability.isEmpty()) {
            controller.getLogger().warning("Automaton template " + automaton.getKey() + " has a spawner with no mobs defined");
        } else {
            for (WeightedPair weightedPair : keyProbability) {
                String mobKey = (String)weightedPair.getValue();
                EntityData entityData = null;
                if (!mobKey.equalsIgnoreCase("none")) {
                    entityData = controller.getMob(mobKey);
                    if (entityData == null) {
                        controller.getLogger().warning("Invalid mob type in automaton " + automaton.getKey() + ": " + mobKey);
                    } else {
                        String customMob;
                        if (entityParameters != null) {
                            entityData = entityData.clone();
                            ConfigurationSection effectiveParameters = ConfigurationUtils.cloneConfiguration(entityData.getConfiguration());
                            effectiveParameters = ConfigurationUtils.addConfigurations(effectiveParameters, entityParameters);
                            entityData.load(effectiveParameters);
                        }
                        if ((customMob = entityData.getName()) == null || customMob.isEmpty()) {
                            this.entityTypes.add(entityData.getType());
                        } else {
                            this.entityNames.add(customMob);
                        }
                    }
                }
                this.entityTypeProbability.add(new WeightedPair<EntityData>(weightedPair, entityData));
            }
        }
        this.countProbability = new ArrayDeque<WeightedPair<Integer>>();
        RandomUtils.populateIntegerProbabilityMap(this.countProbability, configuration, "count", 0, 0, 0.0f);
        if (this.countProbability.isEmpty()) {
            this.countProbability.add(new WeightedPair<Integer>(Float.valueOf(1.0f), Integer.valueOf(1)));
        }
        this.probability = configuration.getDouble("probability", 0.0);
        this.playerRange = configuration.getInt("player_range", 64);
        this.minPlayers = configuration.getInt("min_players", 1);
        this.interval = configuration.getInt("interval", 0);
        int configuredLimit = configuration.getInt("limit", 0);
        this.limitRange = configuration.getInt("limit_range", 16);
        this.verticalRange = configuration.getInt("vertical_range", 0);
        this.radius = configuration.getDouble("radius");
        this.verticalRadius = configuration.getDouble("vertical_radius");
        this.checkRadius = configuration.getInt("check_radius", 1);
        this.verticalCheckRadius = configuration.getInt("vertical_check_radius", 1);
        this.checkFloor = configuration.getBoolean("check_floor", true);
        this.locationRetry = configuration.getInt("retries", 4);
        this.passthrough = controller.getMaterialSetManager().getMaterialSet("passthrough");
        this.randomizePitch = configuration.getBoolean("randomize_pitch", false);
        this.randomizeYaw = configuration.getBoolean("randomize_yaw", false);
        this.track = configuration.getBoolean("track", true);
        this.leash = configuration.getBoolean("leash", true);
        for (WeightedPair<Integer> count : this.countProbability) {
            configuredLimit = Math.max(configuredLimit, count.getValue());
        }
        this.limit = configuredLimit;
    }

    private boolean isSafe(Location location) {
        if (this.checkRadius <= 0) {
            return true;
        }
        int range = this.checkRadius - 1;
        int verticalRange = this.verticalCheckRadius - 1;
        Block block = location.getBlock();
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                for (int y = -verticalRange - 1; y <= verticalRange + 1; ++y) {
                    Block testBlock = block.getRelative(x, y, z);
                    if (!(y < 0 && this.checkFloor ? this.passthrough.testBlock(testBlock) : !this.passthrough.testBlock(testBlock))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Nullable
    private Location getSafeLocation(Location location) {
        Block onBlock = location.getBlock().getRelative(BlockFace.DOWN);
        boolean goDown = this.passthrough.testBlock(onBlock);
        for (int retry = 0; retry <= this.locationRetry; ++retry) {
            if (this.isSafe(location)) {
                return location;
            }
            if (goDown) {
                location.setY(location.getY() - 1.0);
                if (!(location.getY() <= 0.0)) continue;
                return null;
            }
            location.setY(location.getY() + 1.0);
        }
        return null;
    }

    public Nearby getNearby(Automaton automaton) {
        boolean requiresPlayers;
        Location location = automaton.getLocation();
        int range = 0;
        Nearby nearby = new Nearby();
        nearby.mobs = automaton.getSpawnedCount();
        int playerRangeSquared = this.playerRange * this.playerRange;
        int limitRangeSquared = this.limitRange * this.limitRange;
        boolean hasLimit = this.limit > 0 && this.limitRange > 0;
        boolean bl = requiresPlayers = this.playerRange > 0 && this.minPlayers > 0;
        if (hasLimit) {
            range = this.limitRange;
        }
        if (requiresPlayers) {
            range = Math.max(this.playerRange, range);
        }
        int vertical = this.verticalRange > 0 ? this.verticalRange : range;
        Collection entities = location.getWorld().getNearbyEntities(location, (double)range, (double)vertical, (double)range);
        for (Entity entity : entities) {
            if (entity instanceof Player) {
                if (this.playerRange != range && !(entity.getLocation().distanceSquared(location) <= (double)playerRangeSquared)) continue;
                ++nearby.players;
                continue;
            }
            if (this.track || !hasLimit || this.limitRange != range && !(entity.getLocation().distanceSquared(location) <= (double)limitRangeSquared)) continue;
            String customName = entity.getCustomName();
            if (customName == null || customName.isEmpty()) {
                if (this.entityTypes.contains(entity.getType())) {
                    ++nearby.mobs;
                }
            } else if (this.entityNames.contains(customName)) {
                ++nearby.mobs;
            }
            if (nearby.mobs < this.limit) continue;
            break;
        }
        return nearby;
    }

    @Nullable
    public List<Entity> spawn(Automaton automaton) {
        boolean requiresPlayers;
        Location location = automaton.getLocation();
        if (this.entityTypeProbability.isEmpty()) {
            return null;
        }
        Random random = this.controller.getRandom();
        if (this.probability > 0.0 && random.nextDouble() > this.probability) {
            return null;
        }
        Nearby nearby = null;
        boolean hasLimit = this.limit > 0 && this.limitRange > 0;
        boolean bl = requiresPlayers = this.playerRange > 0 && this.minPlayers > 0;
        if (hasLimit || requiresPlayers) {
            nearby = this.getNearby(automaton);
            if (requiresPlayers && nearby.players < this.minPlayers) {
                return null;
            }
            if (hasLimit && nearby.mobs >= this.limit) {
                return null;
            }
        }
        int count = (Integer)RandomUtils.weightedRandom(this.countProbability);
        if (nearby != null) {
            count = Math.min(count, this.limit - nearby.mobs);
        }
        ArrayList<Entity> spawned = new ArrayList<Entity>();
        for (int num = 0; num < count; ++num) {
            Entity entity;
            EntityData entityData;
            Location target = this.getSpawnLocation(location);
            if (this.randomizeYaw) {
                target.setYaw(RandomUtils.getRandom().nextFloat() * 360.0f);
            }
            if (this.randomizePitch) {
                target.setPitch(RandomUtils.getRandom().nextFloat() * 180.0f - 90.0f);
            }
            if ((entityData = (EntityData)RandomUtils.weightedRandom(this.entityTypeProbability)) == null) continue;
            try {
                entity = entityData.spawn(target);
            }
            catch (Throwable ex) {
                this.controller.getLogger().log(Level.WARNING, "Error spawning mob from automaton at " + location, ex);
                entity = null;
            }
            if (entity == null) continue;
            spawned.add(entity);
        }
        return spawned;
    }

    @Nonnull
    public Location getSpawnLocation(Location location) {
        Location target = location;
        if (this.radius > 0.0) {
            Random random = this.controller.getRandom();
            for (int i = 0; i < this.locationRetry + 1; ++i) {
                target = location.clone();
                double vertical = this.verticalRadius >= 0.0 ? this.verticalRadius : this.radius;
                double xOffset = 2.0 * this.radius * random.nextDouble() - this.radius;
                double yOffset = vertical > 0.0 ? 2.0 * vertical * random.nextDouble() - vertical : 0.0;
                double zOffset = 2.0 * this.radius * random.nextDouble() - this.radius;
                target.setX(target.getX() + xOffset);
                target.setY(target.getY() + yOffset);
                target.setZ(target.getZ() + zOffset);
                target = this.getSafeLocation(target);
                if (target != null) break;
            }
        }
        if (target == null) {
            target = location;
        }
        return target;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getInterval() {
        return this.interval;
    }

    public boolean isLeashed() {
        return this.leash && this.limitRange > 0;
    }

    public int getLimitRange() {
        return this.limitRange;
    }

    public boolean isTracked() {
        return this.track;
    }

    public int getMinPlayers() {
        return this.minPlayers;
    }
}

