/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.ActionContext;
import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.configuration.SpellParameters;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;

public class RandomAction
extends CompoundAction {
    private Deque<WeightedPair<ActionContext>> actionProbability;
    private ActionContext currentAction = null;
    private MageSpell mageSpell;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        if (spell instanceof MageSpell) {
            this.mageSpell = (MageSpell)spell;
        }
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        if (this.actionProbability == null) {
            this.mapActions(context);
        }
        if (this.actionProbability.size() > 0) {
            this.currentAction = (ActionContext)RandomUtils.weightedRandom(this.actionProbability);
            this.currentAction.getAction().reset(context);
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.currentAction == null) {
            return SpellResult.FAIL;
        }
        return this.currentAction.perform(context);
    }

    @Override
    public void finish(CastContext context) {
        if (this.currentAction != null) {
            this.currentAction.finish(context);
        }
    }

    protected void mapActions(CastContext context) {
        this.actionProbability = new ArrayDeque<WeightedPair<ActionContext>>();
        ActionHandler actions = this.getHandler("actions");
        if (actions != null) {
            List<ActionContext> options = actions.getActions();
            float totalWeight = 0.0f;
            for (ActionContext option : options) {
                float weight = 1.0f;
                Object actionParameters = option.getActionParameters();
                if (actionParameters != null) {
                    if (this.mageSpell != null) {
                        actionParameters = new SpellParameters(this.mageSpell, context, (ConfigurationSection)actionParameters);
                    }
                    weight = (float)actionParameters.getDouble("weight", (double)weight);
                }
                this.actionProbability.add(new WeightedPair<ActionContext>(Float.valueOf(totalWeight += weight), Float.valueOf(weight), option));
            }
        }
    }

    @Override
    public Object clone() {
        RandomAction action = (RandomAction)super.clone();
        action.actionProbability = null;
        return action;
    }
}

