/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.utility.ColoredLogger;
import com.elmakers.mine.bukkit.utility.LogMessage;
import com.elmakers.mine.bukkit.utility.Messages;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MagicLogger
extends ColoredLogger {
    private String context = null;
    private boolean capture = false;
    private final Set<LogMessage> warnings = new LinkedHashSet<LogMessage>();
    private final Set<LogMessage> errors = new LinkedHashSet<LogMessage>();
    private int pendingWarningCount = 0;
    private int pendingErrorCount = 0;
    private long lastMessageSent = System.currentTimeMillis();

    public MagicLogger(Logger delegate) {
        super(delegate);
    }

    @Override
    public void log(LogRecord record) {
        if (this.capture) {
            boolean logged = false;
            if (record.getThrown() != null) {
                logged = true;
                super.log(record);
            }
            if (record.getLevel().equals(Level.WARNING)) {
                this.warnings.add(new LogMessage(this.context, record.getMessage().replace("[Magic] ", "")));
            } else if (record.getLevel().equals(Level.SEVERE)) {
                this.errors.add(new LogMessage(this.context, record.getMessage().replace("[Magic] ", "")));
            } else if (!logged) {
                super.log(record);
            }
        } else {
            if (record.getLevel().equals(Level.WARNING)) {
                ++this.pendingWarningCount;
            } else if (record.getLevel().equals(Level.SEVERE)) {
                ++this.pendingErrorCount;
            }
            super.log(record);
        }
    }

    public void enableCapture(boolean enable) {
        this.capture = enable;
        this.context = null;
        this.warnings.clear();
        this.errors.clear();
    }

    public void setContext(String context) {
        this.context = context;
    }

    public List<LogMessage> getErrors() {
        return new ArrayList<LogMessage>(this.errors);
    }

    public List<LogMessage> getWarnings() {
        return new ArrayList<LogMessage>(this.warnings);
    }

    public boolean isCapturing() {
        return this.capture;
    }

    public void notify(Messages messages, CommandSender sender) {
        if (this.pendingErrorCount == 0 && this.pendingWarningCount == 0) {
            return;
        }
        long timeSince = System.currentTimeMillis() - this.lastMessageSent;
        String sinceMessage = messages.getTimeDescription(timeSince, "description", "cooldown");
        String messageKey = "logs.notify_errors";
        if (this.pendingErrorCount == 0) {
            messageKey = "logs.notify_warnings";
        } else if (this.pendingWarningCount != 0) {
            messageKey = "logs.notify_errors_and_warnings";
        }
        String message = messages.get(messageKey);
        message = message.replace("$time", sinceMessage).replace("$warnings", Integer.toString(this.pendingWarningCount)).replace("$errors", Integer.toString(this.pendingErrorCount));
        if (!message.isEmpty()) {
            sender.sendMessage(message);
        }
    }

    public void checkNotify(Messages messages) {
        if (this.pendingErrorCount == 0 && this.pendingWarningCount == 0) {
            return;
        }
        boolean sent = false;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("Magic.notify")) continue;
            this.notify(messages, (CommandSender)player);
            String message = messages.get("logs.notify_instructions");
            if (!message.isEmpty()) {
                player.sendMessage(message);
            }
            sent = true;
        }
        if (sent) {
            this.clearNotify();
        }
    }

    public void clearNotify() {
        this.pendingErrorCount = 0;
        this.pendingWarningCount = 0;
        this.lastMessageSent = System.currentTimeMillis();
    }
}

