/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.item.ItemData;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemController {
    private MageController controller;
    private final Set<String> itemKeys = new HashSet<String>();
    private final Map<String, ItemData> items = new HashMap<String, ItemData>();
    private final Map<ItemStack, ItemData> itemsByStack = new HashMap<ItemStack, ItemData>();
    private final Map<Material, Map<Integer, ItemData>> replaceOnEquip = new HashMap<Material, Map<Integer, ItemData>>();

    public ItemController(MageController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection configuration) {
        this.itemKeys.clear();
        this.items.clear();
        this.itemsByStack.clear();
        this.replaceOnEquip.clear();
        Set itemKeys = configuration.getKeys(false);
        for (String itemKey : itemKeys) {
            ConfigurationSection itemConfig = configuration.getConfigurationSection(itemKey);
            if (itemConfig != null) {
                this.loadItem(itemKey, itemConfig);
                continue;
            }
            String itemString = configuration.getString(itemKey);
            if (itemString != null && !itemString.isEmpty()) {
                this.loadItem(itemKey, itemString);
                continue;
            }
            this.controller.getLogger().warning("Improperly formatted item: " + itemKey);
        }
    }

    public void loadItem(String itemKey, String material) {
        ItemData magicItem = new ItemData(itemKey, material, this.controller);
        this.itemKeys.add(itemKey);
        this.items.put(itemKey, magicItem);
    }

    public void loadItem(String itemKey, ConfigurationSection configuration) {
        try {
            ItemData magicItem = new ItemData(itemKey, configuration, this.controller);
            if (magicItem != null) {
                this.itemKeys.add(itemKey);
                this.items.put(itemKey, magicItem);
                if (magicItem.isReplaceOnEquip()) {
                    Material type = magicItem.getType();
                    Map<Integer, ItemData> mapped = this.replaceOnEquip.get(type);
                    if (mapped == null) {
                        mapped = new HashMap<Integer, ItemData>();
                        this.replaceOnEquip.put(type, mapped);
                    }
                    mapped.put(magicItem.getCustomModelData(), magicItem);
                }
            } else {
                this.controller.getLogger().warning("Could not create item with key " + itemKey);
            }
        }
        catch (Throwable ex) {
            this.controller.getLogger().log(Level.WARNING, "An error occurred while processing the item: " + itemKey, ex);
        }
    }

    public void finalizeItems() {
        for (ItemData magicItem : this.items.values()) {
            magicItem.checkKey();
            this.itemsByStack.put(magicItem.getOrCreateItemStack(), magicItem);
        }
    }

    public int getCount() {
        return this.items.size();
    }

    public Set<String> getKeys() {
        return this.itemKeys;
    }

    @Nullable
    public ItemData get(String key) {
        ItemData baseItem;
        String[] pieces;
        ItemData item = this.items.get(key);
        if (item == null && (pieces = StringUtils.split((String)key, (char)':')).length > 1 && (baseItem = this.items.get(pieces[0])) != null && baseItem.getMaxDurability() > 0) {
            try {
                short damage = Short.parseShort(pieces[1]);
                item = baseItem.createVariant(key, damage);
                if (item != null) {
                    this.items.put(key, item);
                }
            }
            catch (Exception ex) {
                return null;
            }
        }
        return item;
    }

    @Nullable
    public ItemData get(ItemStack item) {
        return this.itemsByStack.get(item);
    }

    @Nullable
    public ItemData getOrCreate(String key) {
        ItemData data = this.get(key);
        if (data == null) {
            data = new ItemData(key, this.controller);
        }
        return data;
    }

    public void remove(String key) {
        ItemData existing = this.items.get(key);
        if (existing != null) {
            this.itemsByStack.remove(existing.getItemStack(1));
        }
        this.items.remove(key);
        this.itemKeys.remove(key);
    }

    public void updateOnEquip(ItemStack itemStack) {
        if (CompatibilityUtils.isEmpty(itemStack)) {
            return;
        }
        Map<Integer, ItemData> mapped = this.replaceOnEquip.get(itemStack.getType());
        if (mapped == null) {
            return;
        }
        int customData = InventoryUtils.getMetaInt(itemStack, "CustomModelData", 0);
        ItemData replacement = mapped.get(customData);
        if (replacement != null) {
            ItemMeta meta = replacement.getItemMeta();
            itemStack.setItemMeta(meta);
        }
    }
}

