/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.api.event;

import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.projectiles.ProjectileSource;

public class MagicMobDeathEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final EntityDeathEvent deathEvent;
    private final EntityData entityData;
    private final MageController controller;
    private Mage mage;
    private Player player;

    public MagicMobDeathEvent(MageController controller, EntityData entityData, EntityDeathEvent deathEvent) {
        this.controller = controller;
        this.entityData = entityData;
        this.deathEvent = deathEvent;
        LivingEntity killed = deathEvent.getEntity();
        EntityDamageEvent damageEvent = killed.getLastDamageCause();
        if (damageEvent instanceof EntityDamageByEntityEvent) {
            Projectile projectile;
            ProjectileSource source;
            EntityDamageByEntityEvent damageByEvent = (EntityDamageByEntityEvent)damageEvent;
            Entity damagingEntity = damageByEvent.getDamager();
            if (damagingEntity instanceof Projectile && (source = (projectile = (Projectile)damagingEntity).getShooter()) instanceof LivingEntity) {
                damagingEntity = (LivingEntity)source;
            }
            if (damagingEntity != null && damagingEntity instanceof Player) {
                this.player = (Player)damagingEntity;
                this.mage = controller.getRegisteredMage(this.player.getUniqueId().toString());
            }
        }
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public EntityDeathEvent getDeathEvent() {
        return this.deathEvent;
    }

    public EntityData getEntityData() {
        return this.entityData;
    }

    public MageController getController() {
        return this.controller;
    }

    public Mage getMage() {
        return this.mage;
    }

    public Player getPlayer() {
        return this.player;
    }
}

