/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.builtin.CustomProjectileAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.magic.MagicMetaKeys;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.EntityMetadataUtils;
import com.elmakers.mine.bukkit.utility.SafetyUtils;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public class EntityProjectileAction
extends CustomProjectileAction {
    private boolean noTarget = true;
    private boolean doTeleport = false;
    private boolean doVelocity = false;
    private boolean orient = false;
    private Vector velocityOffset;
    private Vector locationOffset;
    protected CreatureSpawnEvent.SpawnReason spawnReason = CreatureSpawnEvent.SpawnReason.CUSTOM;
    private Collection<PotionEffect> projectileEffects;
    private EntityData entityData;
    protected String variantName;
    protected Entity entity = null;
    protected Plugin plugin = null;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.projectileEffects = ConfigurationUtils.getPotionEffects(parameters, "projectile_potion_effects", Integer.MAX_VALUE);
    }

    protected boolean teleportByDefault() {
        return false;
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        String mobType;
        super.prepare(context, parameters);
        this.plugin = context.getPlugin();
        this.doVelocity = parameters.getBoolean("apply_velocity", true);
        this.doTeleport = parameters.getBoolean("teleport", this.teleportByDefault());
        this.noTarget = parameters.getBoolean("no_target", true);
        this.orient = parameters.getBoolean("orient", false);
        this.velocityOffset = ConfigurationUtils.getVector(parameters, "velocity_offset");
        this.locationOffset = ConfigurationUtils.getVector(parameters, "location_offset");
        if (parameters.contains("spawn_reason")) {
            String reasonText = parameters.getString("spawn_reason").toUpperCase();
            try {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)reasonText);
            }
            catch (Exception ex) {
                context.getMage().sendMessage("Unknown spawn reason: " + reasonText);
            }
        }
        if ((mobType = parameters.getString("type")) == null || mobType.isEmpty()) {
            context.getLogger().warning("EntityProjectileAction missing type parameter");
        } else {
            this.entityData = context.getController().getMob(parameters);
        }
        this.variantName = parameters.getString("variant");
        if (this.variantName != null && this.variantName.isEmpty()) {
            this.variantName = null;
        }
    }

    protected Entity setEntity(MageController controller, @Nonnull Entity entity) {
        this.entity = entity;
        if (this.noTarget) {
            EntityMetadataUtils.instance().setBoolean(entity, MagicMetaKeys.NO_TARGET, true);
        }
        CompatibilityUtils.setPersist(entity, false);
        if (entity instanceof LivingEntity) {
            CompatibilityUtils.setMaxHealth((Damageable)((LivingEntity)entity), 1000.0);
            ((LivingEntity)entity).setHealth(1000.0);
        }
        if (this.projectileEffects != null && entity instanceof LivingEntity) {
            CompatibilityUtils.applyPotionEffects((LivingEntity)entity, this.projectileEffects);
        }
        this.targeting.ignoreEntity(entity);
        return entity;
    }

    @Override
    public SpellResult start(CastContext context) {
        if (this.entity == null) {
            Location location;
            Entity spawned;
            MaterialBrush brush = context.getBrush();
            if (brush != null && this.entityData.getMaterial() == null) {
                this.entityData.setMaterial(brush);
            }
            if ((spawned = this.entityData.spawn(location = this.adjustLocation(this.sourceLocation.getLocation(context)), this.spawnReason)) != null) {
                context.registerForUndo(spawned);
                this.setEntity(context.getController(), spawned);
            }
        }
        if (this.entity == null) {
            return SpellResult.FAIL;
        }
        return super.start(context);
    }

    protected Location adjustLocation(Location target) {
        if (this.locationOffset != null) {
            target = target.clone().add(this.locationOffset);
        }
        return target;
    }

    @Override
    public SpellResult step(CastContext context) {
        SpellResult result = super.step(context);
        if (this.entity == null) {
            return SpellResult.CAST;
        }
        Location target = this.adjustLocation(this.actionContext.getTargetLocation());
        if (this.doTeleport) {
            if (this.orient) {
                target.setDirection(this.velocity);
            }
            this.entity.teleport(target);
        }
        if (this.doVelocity) {
            Vector velocity = this.velocity.clone().multiply(this.distanceTravelledThisTick);
            if (this.velocityOffset != null) {
                velocity = velocity.add(this.velocityOffset);
            }
            SafetyUtils.setVelocity(this.entity, velocity);
        }
        return result;
    }

    @Override
    public void finishEffects() {
        super.finishEffects();
        if (this.entity != null) {
            this.entity.remove();
            this.entity = null;
        }
    }
}

