/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.listener;

import com.elmakers.mine.bukkit.world.MagicWorld;
import com.elmakers.mine.bukkit.world.WorldController;
import java.util.logging.Level;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.TimeSkipEvent;

public class TimeListener
implements Listener {
    private final WorldController controller;
    private boolean updating = false;

    public TimeListener(WorldController controller) {
        this.controller = controller;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onTimeSkip(TimeSkipEvent event) {
        if (this.updating) {
            return;
        }
        this.updating = true;
        World changedWorld = event.getWorld();
        for (MagicWorld world : this.controller.getWorlds()) {
            try {
                if (world.updateTimeFrom(changedWorld, event.getSkipAmount())) continue;
                event.setCancelled(true);
                break;
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.SEVERE, "An error occurred updating world time", ex);
            }
        }
        this.updating = false;
    }
}

