/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.event.CraftWandEvent;
import com.elmakers.mine.bukkit.configuration.MagicConfiguration;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicRecipe;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.Plugin;

public class CraftingController
implements Listener {
    private final MagicController controller;
    private boolean craftingEnabled = false;
    private boolean allowWandsAsIngredients = true;
    private Map<Material, List<MagicRecipe>> recipes = new HashMap<Material, List<MagicRecipe>>();
    private Set<String> recipeKeys = new HashSet<String>();
    private Set<String> autoDiscoverRecipeKeys = new HashSet<String>();

    public CraftingController(MagicController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection configuration) {
        for (List<MagicRecipe> recipeList : this.recipes.values()) {
            for (MagicRecipe recipe : recipeList) {
                recipe.unregister((Plugin)this.controller.getPlugin());
            }
        }
        this.recipes.clear();
        this.recipeKeys.clear();
        this.autoDiscoverRecipeKeys.clear();
        if (!this.craftingEnabled) {
            return;
        }
        Set recipeKeys = configuration.getKeys(false);
        for (String key : recipeKeys) {
            MagicRecipe recipe;
            block8: {
                Object parameters = configuration.getConfigurationSection(key);
                if (!ConfigurationUtils.isEnabled(parameters)) continue;
                parameters = MagicConfiguration.getKeyed(this.controller, parameters, "recipe", key);
                recipe = new MagicRecipe(key, this.controller);
                try {
                    if (!recipe.load((ConfigurationSection)parameters)) {
                        this.controller.getLogger().warning("Failed to create crafting recipe: " + key);
                    }
                    break block8;
                }
                catch (Exception ex) {
                    this.controller.getLogger().log(Level.WARNING, "An error occurred creating crafting recipe: " + key, ex);
                }
                continue;
            }
            Material outputType = recipe.getOutputType();
            List<MagicRecipe> similar = this.recipes.get(outputType);
            if (similar == null) {
                similar = new ArrayList<MagicRecipe>();
                this.recipes.put(outputType, similar);
            }
            similar.add(recipe);
            this.recipeKeys.add(recipe.getKey());
            if (!recipe.isAutoDiscover()) continue;
            this.autoDiscoverRecipeKeys.add(recipe.getKey());
        }
    }

    public void loadMainConfiguration(ConfigurationSection configuration) {
        this.craftingEnabled = configuration.getBoolean("enable_crafting", this.craftingEnabled);
        this.allowWandsAsIngredients = this.craftingEnabled && configuration.getBoolean("allow_wands_as_ingredients", this.allowWandsAsIngredients);
    }

    public boolean hasCraftPermission(Player player, MagicRecipe recipe) {
        if (player == null) {
            return false;
        }
        if (this.controller.hasBypassPermission((CommandSender)player)) {
            return true;
        }
        if (!this.controller.hasPermission(player, "Magic.wand.craft")) {
            return false;
        }
        if (!this.controller.hasPermission(player, "Magic.craft." + recipe.getKey())) {
            return false;
        }
        if (!recipe.isLocked()) {
            return true;
        }
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage == null) {
            return false;
        }
        return mage.canCraft(recipe.getKey());
    }

    public void register(MagicController controller, Plugin plugin) {
        if (!this.craftingEnabled) {
            return;
        }
        for (List<MagicRecipe> list : this.recipes.values()) {
            for (MagicRecipe recipe : list) {
                recipe.preregister(plugin);
            }
        }
        for (List<MagicRecipe> list : this.recipes.values()) {
            for (MagicRecipe recipe : list) {
                recipe.register(controller, plugin);
            }
        }
    }

    @EventHandler
    public void onPrepareCraftItem(PrepareItemCraftEvent event) {
        CraftingInventory inventory = event.getInventory();
        ItemStack[] contents = inventory.getMatrix();
        for (int i = 0; i < 9 && i < contents.length; ++i) {
            ItemStack item = contents[i];
            if (this.isCraftable(item)) continue;
            inventory.setResult(new ItemStack(Material.AIR));
            return;
        }
        if (!this.craftingEnabled) {
            return;
        }
        Recipe recipe = event.getRecipe();
        if (recipe == null) {
            return;
        }
        ItemStack result = recipe.getResult();
        if (result == null) {
            return;
        }
        Material resultType = result.getType();
        List<MagicRecipe> candidates = this.recipes.get(resultType);
        if (candidates == null || candidates.size() == 0) {
            return;
        }
        MagicRecipe.MatchType matchType = MagicRecipe.MatchType.NONE;
        for (MagicRecipe candidate : candidates) {
            matchType = candidate.getMatchType(recipe, contents);
            Material substitute = candidate.getSubstitute();
            if (matchType != MagicRecipe.MatchType.NONE) {
                for (HumanEntity human : event.getViewers()) {
                    if (!(human instanceof Player) || this.hasCraftPermission((Player)human, candidate)) continue;
                    inventory.setResult(new ItemStack(Material.AIR));
                    return;
                }
                if (matchType == MagicRecipe.MatchType.PARTIAL) continue;
                if (matchType != MagicRecipe.MatchType.MATCH) break;
                ItemStack crafted = candidate.craft();
                inventory.setResult(crafted);
                for (HumanEntity human : event.getViewers()) {
                    candidate.crafted(human, this.controller);
                }
                break;
            }
            if (substitute == null) continue;
            inventory.setResult(new ItemStack(substitute, 1));
        }
        if (matchType == MagicRecipe.MatchType.PARTIAL) {
            inventory.setResult(new ItemStack(Material.AIR));
            return;
        }
    }

    private boolean isCraftable(ItemStack item) {
        if (Wand.isSpecial(item)) {
            if (!this.allowWandsAsIngredients) {
                return false;
            }
            return InventoryUtils.getMetaBoolean(item, "craftable", false);
        }
        return true;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack cursor;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        InventoryType inventoryType = event.getInventory().getType();
        InventoryType.SlotType slotType = event.getSlotType();
        if (!(slotType != InventoryType.SlotType.CRAFTING || inventoryType != InventoryType.CRAFTING && inventoryType != InventoryType.WORKBENCH || this.isCraftable(cursor = event.getCursor()))) {
            event.setCancelled(true);
        }
    }

    public final boolean isCraftingSlot(InventoryView view, int slot) {
        if (slot >= 0 && slot < view.getTopInventory().getSize() && (view.getType() == InventoryType.WORKBENCH || view.getType() == InventoryType.CRAFTING)) {
            return slot > 0;
        }
        return false;
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        ItemStack item = event.getOldCursor();
        ItemStack itemStack = item = item.hasItemMeta() ? InventoryUtils.makeReal(item) : item;
        if (this.isCraftable(item)) {
            return;
        }
        InventoryView view = event.getView();
        for (Integer slot : event.getInventorySlots()) {
            if (slot == null || !this.isCraftingSlot(view, slot)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        HumanEntity human = event.getWhoClicked();
        if (!(human instanceof Player)) {
            return;
        }
        Player player = (Player)human;
        Mage mage = this.controller.getMage(player);
        if (mage.hasStoredInventory()) {
            event.setCancelled(true);
            return;
        }
        ItemStack currentItem = event.getCurrentItem();
        if (Wand.isWand(currentItem)) {
            currentItem = currentItem.clone();
            CraftWandEvent castEvent = new CraftWandEvent(mage, this.controller.getWand(currentItem));
            Bukkit.getPluginManager().callEvent((Event)castEvent);
        }
    }

    public boolean isEnabled() {
        return this.craftingEnabled;
    }

    public int getCount() {
        return this.recipeKeys.size();
    }

    public List<String> getRecipeKeys() {
        return new ArrayList<String>(this.recipeKeys);
    }

    public List<String> getAutoDiscoverRecipeKeys() {
        return new ArrayList<String>(this.autoDiscoverRecipeKeys);
    }
}

