/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command.config;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.config.AsyncProcessor;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;

public abstract class HttpGet
extends AsyncProcessor
implements Runnable {
    protected final String url;
    protected final MagicController controller;
    protected final CommandSender sender;
    protected long contentSize;

    public HttpGet(MagicController controller, CommandSender sender, String url) {
        this.controller = controller;
        this.sender = sender;
        this.url = url;
    }

    @Override
    public void run() {
        try {
            URL url = new URL(this.url);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/zip");
            connection.setDoInput(true);
            InputStream inputStream = connection.getInputStream();
            if (inputStream == null) {
                throw new IllegalArgumentException("Empty response");
            }
            this.contentSize = connection.getContentLengthLong();
            this.processResponse(inputStream);
        }
        catch (Exception ex) {
            this.fail(this.controller.getMessages().get("commands.mconfig.example.fetch.error"), "Error processing HTTP request", ex);
            this.processResponse(null);
            return;
        }
    }

    protected abstract void processResponse(InputStream var1);

    protected void message(List<String> messages, String message) {
        messages.add(message);
        HttpGet.message(this.controller, this.sender, StringUtils.join(messages, (String)"\n"));
    }

    protected void success(List<String> messages, String message) {
        messages.add(message);
        HttpGet.success(this.controller, this.sender, StringUtils.join(messages, (String)"\n"));
    }

    protected void success(String message) {
        HttpGet.success(this.controller, this.sender, message);
    }

    protected void fail(String message) {
        HttpGet.fail(this.controller, this.sender, message);
    }

    protected void fail(List<String> messages, String message, String errorMessage, Exception ex) {
        messages.add(message);
        HttpGet.fail(this.controller, this.sender, StringUtils.join(messages, (String)"\n"), errorMessage, ex);
    }

    protected void fail(String message, String errorMessage, Exception ex) {
        HttpGet.fail(this.controller, this.sender, message, errorMessage, ex);
    }
}

