/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.magic.BaseMagicConfigurable;
import com.elmakers.mine.bukkit.magic.CasterProperties;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageClass;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MageProperties
extends CasterProperties {
    private final Mage mage;

    public MageProperties(Mage mage) {
        super(MagicPropertyType.MAGE, mage.getController());
        this.mage = mage;
    }

    @Override
    public void updated() {
        this.updateMaxMana(this.mage);
        Wand activeWand = this.mage.getActiveWand();
        if (activeWand != null) {
            activeWand.updated();
        }
        this.mage.updatePassiveEffects();
    }

    @Override
    public void describe(CommandSender sender, @Nullable Set<String> ignoreProperties, @Nullable Set<String> overriddenProperties) {
        MageClass activeClass = this.mage.getActiveClass();
        if (activeClass != null) {
            if (overriddenProperties == null) {
                overriddenProperties = new HashSet<String>();
            }
            overriddenProperties.addAll(activeClass.getEffectiveConfiguration().getKeys(false));
        }
        super.describe(sender, ignoreProperties, overriddenProperties);
    }

    @Override
    public boolean isPlayer() {
        return this.mage.isPlayer();
    }

    @Override
    @Nullable
    public Player getPlayer() {
        return this.mage.getPlayer();
    }

    @Override
    public Mage getMage() {
        return this.mage;
    }

    @Override
    @Nullable
    public BaseMagicConfigurable getStorage(MagicPropertyType propertyType) {
        switch (propertyType) {
            case WAND: {
                return this.mage.getActiveWand();
            }
            case CLASS: 
            case SUBCLASS: {
                return this.mage.getActiveClass().getStorage(propertyType);
            }
            case MAGE: {
                return this;
            }
        }
        return null;
    }
}

