/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.economy;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.economy.Currency;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.text.DecimalFormat;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;

public abstract class BaseMagicCurrency
implements Currency {
    public static DecimalFormat formatter = new DecimalFormat("#,###.00");
    public static DecimalFormat intFormatter = new DecimalFormat("#,###");
    protected final String key;
    protected final double worth;
    protected final double defaultValue;
    protected final Double maxValue;
    protected final Double minValue;
    protected final String name;
    protected final String singularName;
    protected final String shortName;
    protected final String amountTemplate;
    protected final MaterialAndData icon;

    protected BaseMagicCurrency(MageController controller, String key, ConfigurationSection configuration) {
        this.key = key;
        this.worth = configuration.getDouble("worth", 1.0);
        this.name = controller.getMessages().get("currency." + key + ".name");
        this.singularName = controller.getMessages().get("currency." + key + ".name_singular", this.name);
        this.shortName = controller.getMessages().get("currency." + key + ".name_short", this.singularName);
        this.amountTemplate = controller.getMessages().get("currency." + key + ".amount", "$amount " + this.shortName);
        this.defaultValue = configuration.getDouble("default", 0.0);
        this.icon = ConfigurationUtils.getMaterialAndData(configuration, "icon");
        this.maxValue = configuration.contains("max") ? Double.valueOf(configuration.getDouble("max")) : null;
        this.minValue = configuration.contains("min") ? Double.valueOf(configuration.getDouble("min")) : null;
    }

    protected BaseMagicCurrency(String key, double worth) {
        this.key = key;
        this.worth = worth;
        this.defaultValue = 0.0;
        this.maxValue = null;
        this.minValue = null;
        this.name = null;
        this.singularName = null;
        this.shortName = null;
        this.amountTemplate = null;
        this.icon = null;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue == null ? 0.0 : this.maxValue;
    }

    @Override
    public boolean hasMaxValue() {
        return this.maxValue != null;
    }

    @Override
    public double getMinValue() {
        return this.minValue == null ? 0.0 : this.minValue;
    }

    @Override
    public boolean hasMinValue() {
        return this.minValue != null;
    }

    @Override
    public double getWorth() {
        return this.worth;
    }

    @Override
    @Nullable
    public MaterialAndData getIcon() {
        return this.icon;
    }

    @Override
    public String getName(Messages messages) {
        return this.name;
    }

    @Override
    public String getShortName(Messages messages) {
        return this.shortName;
    }

    @Override
    public String getSingularName(Messages messages) {
        return this.singularName;
    }

    protected boolean hasDecimals() {
        return false;
    }

    protected int getRoundedAmount(double amount) {
        return (int)Math.ceil(amount);
    }

    @Override
    public String formatAmount(double amount, Messages messages) {
        String amountString = this.hasDecimals() ? formatter.format(amount) : intFormatter.format(this.getRoundedAmount(amount));
        return this.amountTemplate.replace("$amount", amountString);
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

