/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.boss;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.boss.BossBarConfiguration;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Server;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BossBarTracker {
    private static final Random random = new Random();
    private final Mage mage;
    private BossBar bossBar;
    private final double radius;
    private final long interval;
    private final int intervalRandomization;
    private final Set<UUID> visibleTo = new HashSet<UUID>();
    private final Set<UUID> processing = new HashSet<UUID>();
    private long nextUpdate;

    public BossBarTracker(Mage mage, BossBarConfiguration config) {
        this.mage = mage;
        this.bossBar = config.createBossBar(mage);
        this.radius = config.getRadius();
        this.interval = config.getUpdateInterval();
        this.intervalRandomization = config.getUpdateIntervalRandomization();
        this.tick();
    }

    public void tick() {
        if (this.bossBar == null || !this.mage.isValid()) {
            return;
        }
        double progress = this.mage.getMaxHealth();
        if (progress > 0.0) {
            progress = this.mage.getHealth() / progress;
        }
        this.tick(progress);
    }

    public void tick(double progress) {
        if (this.bossBar == null || !this.mage.isValid()) {
            return;
        }
        this.bossBar.setProgress(Math.min(1.0, Math.max(0.0, progress)));
        if (System.currentTimeMillis() > this.nextUpdate) {
            this.updateVisibility();
        }
    }

    private void updateVisibility() {
        List<Entity> entities = CompatibilityUtils.getNearbyEntities(this.mage.getLocation(), this.radius, this.radius, this.radius);
        this.processing.addAll(this.visibleTo);
        this.visibleTo.clear();
        for (Entity entity : entities) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            UUID id = player.getUniqueId();
            if (!this.processing.remove(id)) {
                this.bossBar.addPlayer(player);
            }
            this.visibleTo.add(id);
        }
        Plugin plugin = this.mage.getController().getPlugin();
        Server server = plugin.getServer();
        for (UUID leftArea : this.processing) {
            Player player = server.getPlayer(leftArea);
            if (player == null) continue;
            this.bossBar.removePlayer(player);
        }
        this.processing.clear();
        this.nextUpdate = System.currentTimeMillis() + (long)random.nextInt(this.intervalRandomization) + this.interval;
    }

    public void remove() {
        if (this.bossBar != null) {
            this.bossBar.removeAll();
            this.bossBar.setVisible(false);
            this.bossBar = null;
            this.visibleTo.clear();
        }
    }
}

