/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.batch;

import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.block.ModifyType;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.automata.AutomatonLevel;
import com.elmakers.mine.bukkit.batch.SpellBatch;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.boss.BossBarConfiguration;
import com.elmakers.mine.bukkit.boss.BossBarTracker;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class SimulateBatch
extends SpellBatch {
    private static BlockFace[] NEIGHBOR_FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    private static BlockFace[] DIAGONAL_FACES = new BlockFace[]{BlockFace.SOUTH_EAST, BlockFace.NORTH_EAST, BlockFace.SOUTH_WEST, BlockFace.NORTH_WEST};
    private static BlockFace[] MAIN_FACES = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.WEST};
    private static BlockFace[] POWER_FACES = new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH, BlockFace.NORTH, BlockFace.DOWN, BlockFace.UP};
    private static double MAX_BREAKING = 0.9;
    public static boolean DEBUG = false;
    private Block heartBlock;
    private Block heartTargetBlock;
    private TargetMode targetMode = TargetMode.STABILIZE;
    private TargetMode backupTargetMode = TargetMode.WANDER;
    private TargetType targetType = TargetType.PLAYER;
    private boolean hasDirection = false;
    private String automataName;
    private AutomatonLevel level;
    private String dropItem;
    private Collection<String> dropItems;
    private int dropXp;
    private boolean reverseTargetDistanceScore = false;
    private boolean concurrent = false;
    private int commandMoveRangeSquared = 9;
    private int huntMaxRange = 128;
    private int castRange = 48;
    private int huntMinRange = 4;
    private int birthRangeSquared = 0;
    private int liveRangeSquared = 0;
    private float fovWeight = 100.0f;
    private double huntFov = 5.654866776461628;
    private int delay;
    private long delayTimeout;
    private World world;
    private MaterialAndData birthMaterial;
    private Material deathMaterial;
    private boolean isAutomata;
    private int radius;
    private int x;
    private int y;
    private int z;
    private int r;
    private int yRadius;
    private int updatingIndex;
    private ArrayList<Boolean> liveCounts = new ArrayList();
    private ArrayList<Boolean> birthCounts = new ArrayList();
    private ArrayList<Boolean> diagonalLiveCounts = new ArrayList();
    private ArrayList<Boolean> diagonalBirthCounts = new ArrayList();
    private SimulationState state;
    private Location center;
    private ModifyType modifyType = ModifyType.NO_PHYSICS;
    private double reflectChance;
    private int blockLimit = 0;
    private int maxBlocks = 0;
    private int minBlocks = 5;
    private Set<Long> liveBlocks = new HashSet<Long>();
    private double breakingBlocks = 0.0;
    private BossBarTracker bossBar;
    private List<Block> deadBlocks = new ArrayList<Block>();
    private List<Block> bornBlocks = new ArrayList<Block>();
    private List<Target> potentialHeartBlocks = new ArrayList<Target>();

    public SimulateBatch(BlockSpell spell, Location center, int radius, int yRadius, MaterialAndData birth, Material death, Set<Integer> liveCounts, Set<Integer> birthCounts, String automataName) {
        super(spell);
        this.yRadius = yRadius;
        this.radius = radius;
        this.center = center.clone();
        this.birthMaterial = birth;
        this.deathMaterial = death;
        this.mapIntegers(liveCounts, this.liveCounts);
        this.mapIntegers(birthCounts, this.birthCounts);
        this.world = center.getWorld();
        this.automataName = automataName;
        boolean bl = this.isAutomata = automataName != null;
        if (this.isAutomata) {
            this.heartBlock = center.getBlock();
        }
        this.state = SimulationState.INITIALIZING;
        this.undoList.setModifyType(this.modifyType);
    }

    @Override
    public int size() {
        return this.radius * this.radius * this.radius * 8;
    }

    @Override
    public int remaining() {
        if (this.r >= this.radius) {
            return 0;
        }
        return (this.radius - this.r) * (this.radius - this.r) * (this.radius - this.r) * 8;
    }

    protected void checkForPotentialHeart(Block block, int distanceSquared) {
        this.liveBlocks.add(com.elmakers.mine.bukkit.block.BlockData.getBlockId(block));
        if (this.isAutomata && distanceSquared <= this.commandMoveRangeSquared) {
            Target potential = new Target(this.center, block, 1, this.commandMoveRangeSquared, this.huntFov, this.fovWeight, this.reverseTargetDistanceScore);
            this.potentialHeartBlocks.add(potential);
        }
    }

    protected void die() {
        Entity entity;
        Object magicItem;
        String message = this.spell.getMessage("death_broadcast");
        if (message != null && this.automataName != null && (message = message.replace("$name", this.automataName)).length() > 0) {
            this.controller.sendToMages(message, this.center);
        }
        if (this.dropItem != null && this.dropItem.length() > 0 && (magicItem = this.controller.createWand(this.dropItem)) != null) {
            this.center.getWorld().dropItemNaturally(this.center, magicItem.getItem());
        }
        if (this.dropItems != null && this.dropItems.size() > 0) {
            for (String dropItemName : this.dropItems) {
                ItemStack drop = this.controller.createItem(dropItemName);
                if (drop == null) continue;
                this.center.getWorld().dropItemNaturally(this.center, drop);
            }
        }
        if (this.dropXp > 0 && (entity = this.center.getWorld().spawnEntity(this.center, EntityType.EXPERIENCE_ORB)) != null && entity instanceof ExperienceOrb) {
            ExperienceOrb orb = (ExperienceOrb)entity;
            orb.setExperience(this.dropXp);
        }
        if (this.level != null) {
            this.level.onDeath(this.mage, this.birthMaterial);
        }
        this.finish();
    }

    protected void removeBlock(Block block) {
        Double breaking = UndoList.getRegistry().getBreaking(block);
        if (breaking != null) {
            this.breakingBlocks += breaking.doubleValue();
            UndoList.getRegistry().unregisterBreaking(block);
            CompatibilityUtils.clearBreaking(block);
        }
        this.registerForUndo(block);
        if (this.modifyType == ModifyType.FAST) {
            CompatibilityUtils.setBlockFast(block, this.deathMaterial, 0);
        } else {
            DeprecatedUtils.setTypeAndData(block, this.deathMaterial, (byte)0, false);
        }
        if (this.reflectChance > 0.0) {
            UndoList.getRegistry().unregisterReflective(block);
        }
    }

    protected void killBlock(Block block) {
        long blockId = com.elmakers.mine.bukkit.block.BlockData.getBlockId(block);
        this.liveBlocks.remove(blockId);
        if (this.concurrent) {
            this.removeBlock(block);
        } else {
            this.deadBlocks.add(block);
        }
    }

    protected void createBlock(Block block) {
        this.registerForUndo(block);
        this.birthMaterial.modify(block, this.modifyType);
        if (this.breakingBlocks > 0.0) {
            double breaking = Math.min(this.breakingBlocks, MAX_BREAKING);
            double blockBreaking = UndoList.getRegistry().registerBreaking(block, breaking);
            CompatibilityUtils.setBreaking(block, blockBreaking);
            this.breakingBlocks -= breaking;
        }
        if (this.reflectChance > 0.0) {
            UndoList.getRegistry().registerReflective(block, this.reflectChance);
            this.undoList.setUndoReflective(true);
        }
    }

    protected void birthBlock(Block block) {
        if (this.isAutomata && this.liveBlocks.size() >= this.blockLimit) {
            return;
        }
        this.liveBlocks.add(com.elmakers.mine.bukkit.block.BlockData.getBlockId(block));
        if (this.concurrent) {
            this.createBlock(block);
        } else {
            this.bornBlocks.add(block);
        }
    }

    protected boolean simulateBlock(int dx, int dy, int dz) {
        int z;
        int y;
        int x = this.center.getBlockX() + dx;
        Block block = this.world.getBlockAt(x, y = this.center.getBlockY() + dy, z = this.center.getBlockZ() + dz);
        if (!CompatibilityUtils.isChunkLoaded(block)) {
            return false;
        }
        if (!this.context.hasBuildPermission(block)) {
            return true;
        }
        Material blockMaterial = block.getType();
        if (this.birthMaterial.is(block)) {
            int distanceSquared;
            int n = distanceSquared = this.liveRangeSquared > 0 || this.isAutomata ? (int)Math.ceil(block.getLocation().distanceSquared(this.heartBlock.getLocation())) : 0;
            if (this.liveRangeSquared <= 0 || distanceSquared <= this.liveRangeSquared) {
                if (this.diagonalLiveCounts.size() > 0) {
                    int faceNeighborCount = this.getFaceNeighborCount(block, this.birthMaterial);
                    int diagonalNeighborCount = this.getDiagonalNeighborCount(block, this.birthMaterial);
                    if (faceNeighborCount >= this.liveCounts.size() || !this.liveCounts.get(faceNeighborCount).booleanValue() || diagonalNeighborCount >= this.diagonalLiveCounts.size() || !this.diagonalLiveCounts.get(diagonalNeighborCount).booleanValue()) {
                        this.killBlock(block);
                    } else {
                        this.checkForPotentialHeart(block, distanceSquared);
                    }
                } else {
                    int neighborCount = this.getNeighborCount(block, this.birthMaterial);
                    if (neighborCount >= this.liveCounts.size() || !this.liveCounts.get(neighborCount).booleanValue()) {
                        this.killBlock(block);
                    } else {
                        this.checkForPotentialHeart(block, distanceSquared);
                    }
                }
            } else {
                this.killBlock(block);
            }
        } else if (blockMaterial == this.deathMaterial) {
            int distanceSquared;
            int n = distanceSquared = this.birthRangeSquared > 0 || this.isAutomata ? (int)Math.ceil(block.getLocation().distanceSquared(this.heartBlock.getLocation())) : 0;
            if (this.birthRangeSquared <= 0 || distanceSquared <= this.birthRangeSquared) {
                if (this.diagonalBirthCounts.size() > 0) {
                    int faceNeighborCount = this.getFaceNeighborCount(block, this.birthMaterial);
                    int diagonalNeighborCount = this.getDiagonalNeighborCount(block, this.birthMaterial);
                    if (faceNeighborCount < this.birthCounts.size() && this.birthCounts.get(faceNeighborCount).booleanValue() && diagonalNeighborCount < this.diagonalBirthCounts.size() && this.diagonalBirthCounts.get(diagonalNeighborCount).booleanValue()) {
                        this.birthBlock(block);
                        this.checkForPotentialHeart(block, distanceSquared);
                    }
                } else {
                    int neighborCount = this.getNeighborCount(block, this.birthMaterial);
                    if (neighborCount < this.birthCounts.size() && this.birthCounts.get(neighborCount).booleanValue()) {
                        this.birthBlock(block);
                        this.checkForPotentialHeart(block, distanceSquared);
                    }
                }
            }
        }
        return true;
    }

    protected boolean simulateBlocks(int x, int y, int z) {
        boolean success = true;
        if (y != 0) {
            boolean bl = success = success && this.simulateBlock(x, -y, z);
            if (x != 0) {
                boolean bl2 = success = success && this.simulateBlock(-x, -y, z);
            }
            if (z != 0) {
                boolean bl3 = success = success && this.simulateBlock(x, -y, -z);
            }
            if (x != 0 && z != 0) {
                success = success && this.simulateBlock(-x, -y, -z);
            }
        }
        boolean bl = success = success && this.simulateBlock(x, y, z);
        if (x != 0) {
            boolean bl4 = success = success && this.simulateBlock(-x, y, z);
        }
        if (z != 0) {
            boolean bl5 = success = success && this.simulateBlock(x, y, -z);
        }
        if (z != 0 && x != 0) {
            success = success && this.simulateBlock(-x, y, -z);
        }
        return success;
    }

    @Override
    public int process(int maxBlocks) {
        int processedBlocks = 0;
        if (this.bossBar != null) {
            double progress = this.maxBlocks < 1 ? 0.0 : (double)this.blockLimit / (double)this.maxBlocks;
            this.bossBar.tick(progress);
        }
        if (this.state == SimulationState.INITIALIZING) {
            this.x = 0;
            this.y = 0;
            this.z = 0;
            this.r = 0;
            this.updatingIndex = 0;
            this.bornBlocks.clear();
            this.deadBlocks.clear();
            this.liveBlocks.clear();
            if (this.isAutomata) {
                this.target();
                if (this.heartBlock == null || !CompatibilityUtils.isChunkLoaded(this.heartBlock)) {
                    this.finish();
                    return processedBlocks;
                }
                if (this.blockLimit < this.minBlocks) {
                    if (DEBUG) {
                        this.controller.getLogger().info("DIED with block count " + this.liveBlocks.size() + ", and block limit " + this.blockLimit);
                    }
                    this.die();
                    return processedBlocks;
                }
                this.potentialHeartBlocks.clear();
            }
            ++processedBlocks;
            this.state = SimulationState.SCANNING;
        }
        while (this.state == SimulationState.SCANNING && processedBlocks <= maxBlocks) {
            if (!this.simulateBlocks(this.x, this.y, this.z)) {
                this.finish();
                return processedBlocks;
            }
            ++this.y;
            if (this.y > this.yRadius) {
                this.y = 0;
                if (this.x < this.radius) {
                    ++this.x;
                } else {
                    --this.z;
                    if (this.z < 0) {
                        this.z = ++this.r;
                        this.x = 0;
                    }
                }
            }
            if (this.r <= this.radius) continue;
            this.state = SimulationState.UPDATING;
        }
        while (this.state == SimulationState.UPDATING && processedBlocks <= maxBlocks) {
            int bornIndex;
            int deadIndex = this.updatingIndex;
            if (deadIndex >= 0 && deadIndex < this.deadBlocks.size()) {
                Block killBlock = this.deadBlocks.get(deadIndex);
                if (!CompatibilityUtils.isChunkLoaded(killBlock)) {
                    this.finish();
                    return processedBlocks;
                }
                if (this.birthMaterial.is(killBlock)) {
                    this.removeBlock(killBlock);
                } else if (this.bornBlocks.size() > 0) {
                    this.bornBlocks.remove(this.bornBlocks.size() - 1);
                }
                ++processedBlocks;
            }
            if ((bornIndex = this.updatingIndex - this.deadBlocks.size()) >= 0 && bornIndex < this.bornBlocks.size()) {
                Block birthBlock = this.bornBlocks.get(bornIndex);
                if (!CompatibilityUtils.isChunkLoaded(birthBlock)) {
                    this.finish();
                    return processedBlocks;
                }
                this.createBlock(birthBlock);
            }
            ++this.updatingIndex;
            if (this.updatingIndex < this.deadBlocks.size() + this.bornBlocks.size()) continue;
            this.state = SimulationState.PRUNE;
            return maxBlocks;
        }
        if (this.state == SimulationState.PRUNE) {
            if (this.liveBlocks.isEmpty()) {
                if (DEBUG) {
                    this.controller.getLogger().info("Died, no blocks are alive");
                }
                this.die();
                return processedBlocks;
            }
            if (this.undoList != null) {
                this.undoList.prune();
            }
            this.state = SimulationState.TARGETING;
        }
        if (this.state == SimulationState.TARGETING) {
            if (this.isAutomata && this.potentialHeartBlocks.size() > 0) {
                switch (this.targetMode) {
                    case HUNT: {
                        Collections.sort(this.potentialHeartBlocks);
                        break;
                    }
                    case FLEE: {
                        Collections.sort(this.potentialHeartBlocks);
                        break;
                    }
                    default: {
                        Collections.shuffle(this.potentialHeartBlocks);
                    }
                }
                this.heartTargetBlock = null;
                Object backupBlock = null;
                for (Target target : this.potentialHeartBlocks) {
                    Block block = target.getBlock();
                    if (block == null || !this.birthMaterial.is(block)) continue;
                    this.heartTargetBlock = block;
                    break;
                }
                if (this.heartTargetBlock == null) {
                    this.heartTargetBlock = backupBlock;
                }
                if (this.heartTargetBlock == null && DEBUG) {
                    this.controller.getLogger().info("Could not find a valid command block location");
                }
            }
            if (DEBUG && this.heartTargetBlock != null) {
                this.controller.getLogger().info("Moved: " + this.heartTargetBlock.getLocation().toVector().subtract(this.center.toVector()) + " from " + this.potentialHeartBlocks.size() + " potential locations");
            }
            this.state = SimulationState.HEART_UPDATE;
        }
        if (this.state == SimulationState.HEART_UPDATE) {
            if (this.isAutomata) {
                if (this.heartTargetBlock != null) {
                    if (!CompatibilityUtils.isChunkLoaded(this.heartTargetBlock)) {
                        this.finish();
                        return processedBlocks;
                    }
                    if (this.reflectChance > 0.0) {
                        UndoList.getRegistry().unregisterReflective(this.heartTargetBlock);
                    }
                    this.heartBlock = this.heartTargetBlock;
                    Location newLocation = this.heartTargetBlock.getLocation();
                    newLocation.setPitch(this.center.getPitch());
                    newLocation.setYaw(this.center.getYaw());
                    this.center = newLocation;
                    this.mage.setLocation(newLocation);
                } else {
                    if (DEBUG) {
                        this.controller.getLogger().info("Died, could not find target heart block");
                    }
                    this.die();
                    return processedBlocks;
                }
            }
            this.delayTimeout = System.currentTimeMillis() + (long)this.delay;
            SimulationState simulationState = this.state = this.delay > 0 ? SimulationState.DELAY : SimulationState.CLEANUP;
        }
        if (this.state == SimulationState.DELAY) {
            ++processedBlocks;
            if (System.currentTimeMillis() > this.delayTimeout) {
                this.state = SimulationState.CLEANUP;
            }
            return processedBlocks;
        }
        if (this.state == SimulationState.CLEANUP) {
            if (this.blockLimit <= 0) {
                this.state = SimulationState.CHECK;
            } else {
                BlockData undid;
                int undidCount = 0;
                while (processedBlocks <= maxBlocks && this.undoList.size() > this.blockLimit && (undid = this.undoList.undoNext(false)) != null) {
                    if (!this.liveBlocks.remove(undid.getId())) continue;
                    ++undidCount;
                }
                if (DEBUG && undidCount > 0) {
                    this.controller.getLogger().info("UNDID: " + undidCount + " remaining: " + this.liveBlocks.size() + "/" + this.blockLimit);
                }
                if (this.undoList.size() <= this.blockLimit) {
                    this.state = SimulationState.CHECK;
                }
            }
        }
        if (this.state == SimulationState.CHECK) {
            int lostBlocks = 0;
            if (this.undoList != null) {
                Iterator iterator = this.undoList.iterator();
                while (iterator.hasNext()) {
                    BlockData block = (BlockData)iterator.next();
                    long blockId = block.getId();
                    if (!CompatibilityUtils.isChunkLoaded(block.getWorldLocation())) {
                        this.finish();
                        return processedBlocks;
                    }
                    if (block.getMaterial() == this.deathMaterial && block.getBlock().getType() != this.birthMaterial.getMaterial()) {
                        this.liveBlocks.remove(blockId);
                        ++lostBlocks;
                        --this.blockLimit;
                    }
                    if (block.isDifferent()) continue;
                    iterator.remove();
                    if (!(this.undoList instanceof UndoList)) continue;
                    ((UndoList)this.undoList).removeFromMap(block);
                }
            }
            if (lostBlocks > 0) {
                if (DEBUG) {
                    this.controller.getLogger().info(this.spell.getKey() + " LOST " + lostBlocks + " blocks, remaining: " + this.liveBlocks.size() + "/" + this.blockLimit);
                }
                this.spell.playEffects("hurt");
            }
            this.state = SimulationState.FINISHED;
        }
        if (this.state == SimulationState.FINISHED) {
            this.spell.playEffects("tick");
            if (this.isAutomata) {
                this.state = SimulationState.INITIALIZING;
            } else {
                this.finish();
            }
        }
        return processedBlocks;
    }

    public void setDrop(String dropName, int dropXp, Collection<String> drops) {
        this.dropItem = dropName;
        this.dropXp = dropXp;
        this.dropItems = drops;
    }

    public void setLevel(AutomatonLevel level) {
        this.level = level;
        this.commandMoveRangeSquared = level.getMoveRangeSquared(this.commandMoveRangeSquared);
        this.dropXp = level.getDropXp(this.dropXp);
        this.liveRangeSquared = level.getLiveRangeSquared(this.liveRangeSquared);
        this.birthRangeSquared = level.getBirthRangeSquared(this.birthRangeSquared);
        this.radius = level.getRadius(this.radius);
        this.yRadius = level.getYRadius(this.yRadius);
        this.maxBlocks = this.blockLimit = level.getMaxBlocks(this.blockLimit);
        this.minBlocks = level.getMinBlocks(this.minBlocks);
    }

    public void setBirthRange(int range) {
        this.birthRangeSquared = range * range;
    }

    public void setLiveRange(int range) {
        this.liveRangeSquared = range * range;
    }

    public void setMaxHuntRange(int range) {
        this.huntMaxRange = range;
    }

    public void setCastRange(int range) {
        this.castRange = range;
    }

    public void setMinHuntRange(int range) {
        this.huntMinRange = range;
    }

    public void setTargetType(TargetType targetType) {
        this.targetType = targetType;
    }

    public void target() {
        this.target(this.targetMode);
    }

    public void target(TargetMode mode) {
        TargetType targetType = this.targetType;
        if (mode == TargetMode.DIRECTED) {
            targetType = TargetType.PLAYER;
        }
        switch (mode) {
            case HUNT: 
            case FLEE: 
            case DIRECTED: {
                Target bestTarget = null;
                this.reverseTargetDistanceScore = true;
                if (targetType == TargetType.ANY || targetType == TargetType.MOB) {
                    List<Entity> entities = CompatibilityUtils.getNearbyEntities(this.center, this.huntMaxRange, this.huntMaxRange, this.huntMaxRange);
                    for (Entity entity : entities) {
                        if (entity instanceof Player || !(entity instanceof LivingEntity) || entity.isDead() || !entity.getLocation().getWorld().equals(this.center.getWorld()) || !this.context.canTarget(entity)) continue;
                        Target newScore = new Target(this.center, entity, this.huntMinRange, this.huntMaxRange, this.huntFov, 1000, false);
                        int score = newScore.getScore();
                        if (bestTarget != null && score <= bestTarget.getScore()) continue;
                        bestTarget = newScore;
                    }
                }
                if (targetType == TargetType.MAGE || targetType == TargetType.AUTOMATON || targetType == TargetType.ANY || targetType == TargetType.PLAYER) {
                    Collection<Mage> mages = this.controller.getMages();
                    for (Mage mage : mages) {
                        Entity entity;
                        if (mage == this.mage || targetType == TargetType.AUTOMATON && !mage.isAutomaton() || targetType == TargetType.PLAYER && mage.getPlayer() == null || mage.isAutomaton() && mage.hasTag(this.spell.getKey()) || mage.isDead() || !mage.isOnline() || !mage.hasLocation() || mage.isIgnoredByMobs() || !mage.getLocation().getWorld().equals(this.center.getWorld()) || (entity = mage.getEntity()) != null && !this.context.canTarget(entity)) continue;
                        Target newScore = new Target(this.center, mage, this.huntMinRange, this.huntMaxRange, this.huntFov, 1000, false);
                        int score = newScore.getScore();
                        if (bestTarget != null && score <= bestTarget.getScore()) continue;
                        bestTarget = newScore;
                    }
                }
                if (bestTarget != null) {
                    String targetDescription;
                    String string = bestTarget.getEntity() == null ? "NONE" : (targetDescription = bestTarget instanceof Player ? ((Player)bestTarget.getEntity()).getName() : bestTarget.getEntity().getType().name());
                    if (DEBUG) {
                        this.controller.getLogger().info(" Tracking " + targetDescription + " score: " + bestTarget.getScore() + " location: " + this.center + " -> " + bestTarget.getLocation() + " move " + this.commandMoveRangeSquared);
                    }
                    Vector direction = null;
                    if (mode == TargetMode.DIRECTED) {
                        direction = bestTarget.getLocation().getDirection();
                        if (DEBUG) {
                            this.controller.getLogger().info(" *Directed: " + direction);
                        }
                    } else {
                        Location targetLocation = bestTarget.getLocation();
                        direction = targetLocation.toVector().subtract(this.center.toVector());
                    }
                    if (direction != null) {
                        this.center.setDirection(direction);
                    }
                    if (mode == TargetMode.HUNT && this.level != null && this.center.distanceSquared(bestTarget.getLocation()) < (double)(this.castRange * this.castRange)) {
                        this.level.onTick(this.mage, this.birthMaterial);
                    }
                    if (mode != TargetMode.FLEE || !((direction = direction.multiply(-1)).getY() > 0.0)) break;
                    direction.setY(-direction.getY());
                    break;
                }
                if (this.backupTargetMode != mode) {
                    if (DEBUG) {
                        this.controller.getLogger().info("Falling back to target mode: " + (Object)((Object)this.backupTargetMode));
                    }
                    this.target(this.backupTargetMode);
                    break;
                }
                this.center.setPitch(-10.0f);
                this.mage.setLocation(this.center);
                break;
            }
            case GLIDE: {
                this.reverseTargetDistanceScore = true;
                break;
            }
            default: {
                this.reverseTargetDistanceScore = false;
            }
        }
        if (!this.hasDirection) {
            this.hasDirection = true;
            this.center.setYaw((float)RandomUtils.getRandom().nextInt(360));
        }
        this.mage.setLocation(this.center);
    }

    public void setMoveRange(int commandRadius) {
        this.commandMoveRangeSquared = commandRadius * commandRadius;
    }

    protected int getNeighborCount(Block block, MaterialAndData liveMaterial) {
        return this.getDiagonalNeighborCount(block, liveMaterial) + this.getFaceNeighborCount(block, liveMaterial);
    }

    protected int getFaceNeighborCount(Block block, MaterialAndData liveMaterial) {
        BlockFace[] faces;
        int liveCount = 0;
        for (BlockFace face : faces = this.yRadius > 0 ? POWER_FACES : MAIN_FACES) {
            Block faceBlock = block.getRelative(face);
            if (!CompatibilityUtils.isChunkLoaded(faceBlock) || !liveMaterial.is(faceBlock)) continue;
            ++liveCount;
        }
        return liveCount;
    }

    protected int getDiagonalNeighborCount(Block block, MaterialAndData liveMaterial) {
        int liveCount = 0;
        for (BlockFace face : DIAGONAL_FACES) {
            Block faceBlock = block.getRelative(face);
            if (!CompatibilityUtils.isChunkLoaded(faceBlock) || !liveMaterial.is(faceBlock)) continue;
            ++liveCount;
        }
        if (this.yRadius > 0) {
            Block upBlock = block.getRelative(BlockFace.UP);
            for (BlockFace face : NEIGHBOR_FACES) {
                Block faceBlock = upBlock.getRelative(face);
                if (!CompatibilityUtils.isChunkLoaded(faceBlock) || !liveMaterial.is(faceBlock)) continue;
                ++liveCount;
            }
            Block downBlock = block.getRelative(BlockFace.DOWN);
            for (BlockFace face : NEIGHBOR_FACES) {
                Block faceBlock = downBlock.getRelative(face);
                if (!CompatibilityUtils.isChunkLoaded(faceBlock) || !liveMaterial.is(faceBlock)) continue;
                ++liveCount;
            }
        }
        return liveCount;
    }

    public void setConcurrent(boolean concurrent) {
        this.concurrent = concurrent;
    }

    @Override
    public void finish() {
        if (this.isAutomata && !this.mage.isPlayer()) {
            this.controller.forgetMage(this.mage);
        }
        if (this.bossBar != null) {
            this.bossBar.remove();
            this.bossBar = null;
        }
        this.state = SimulationState.FINISHED;
        super.finish();
    }

    protected void mapIntegers(Collection<Integer> flags, List<Boolean> flagMap) {
        for (Integer flag : flags) {
            while (flagMap.size() <= flag) {
                flagMap.add(false);
            }
            flagMap.set(flag, true);
        }
    }

    public void setDiagonalLiveRules(Collection<Integer> rules) {
        this.mapIntegers(rules, this.diagonalLiveCounts);
    }

    public void setDiagonalBirthRules(Collection<Integer> rules) {
        this.mapIntegers(rules, this.diagonalBirthCounts);
    }

    public void setReflectChange(double reflectChance) {
        this.reflectChance = reflectChance;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setTargetMode(TargetMode mode) {
        this.targetMode = mode;
    }

    public void setBackupTargetMode(TargetMode mode) {
        this.backupTargetMode = mode;
    }

    public void setMaxBlocks(int maxBlocks) {
        this.blockLimit = maxBlocks;
        this.maxBlocks = maxBlocks;
    }

    public void setMinBlocks(int minBlocks) {
        this.minBlocks = minBlocks;
    }

    public void setBossBar(BossBarConfiguration config) {
        if (config != null) {
            this.bossBar = config.createTracker(this.mage);
        }
    }

    public static enum TargetType {
        PLAYER,
        MAGE,
        MOB,
        AUTOMATON,
        ANY;

    }

    public static enum TargetMode {
        STABILIZE,
        WANDER,
        GLIDE,
        HUNT,
        FLEE,
        DIRECTED;

    }

    private static enum SimulationState {
        INITIALIZING,
        SCANNING,
        UPDATING,
        PRUNE,
        TARGETING,
        HEART_UPDATE,
        DELAY,
        CLEANUP,
        CHECK,
        FINISHED;

    }
}

