/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class StashWandAction
extends BaseSpellAction {
    private ItemStack stashedItem;
    private WeakReference<Mage> targetMage;
    private int slotNumber;
    private boolean isOffhand = false;
    private boolean returnOnFinish = true;

    private void returnItem(CastContext context) {
        Mage targetMage;
        Mage mage = targetMage = this.targetMage == null ? null : (Mage)this.targetMage.get();
        if (targetMage == null || this.stashedItem == null) {
            return;
        }
        Player player = targetMage.getPlayer();
        if (player == null) {
            return;
        }
        boolean gave = false;
        Wand activeWand = targetMage.getActiveWand();
        if (activeWand != null && activeWand.isInventoryOpen()) {
            gave = targetMage.addToStoredInventory(this.stashedItem);
        } else if (this.isOffhand) {
            ItemStack existing = player.getInventory().getItemInOffHand();
            if (InventoryUtils.isEmpty(existing)) {
                player.getInventory().setItemInOffHand(this.stashedItem);
                gave = true;
            }
        } else {
            ItemStack existing = player.getInventory().getItem(this.slotNumber);
            if (InventoryUtils.isEmpty(existing)) {
                player.getInventory().setItem(this.slotNumber, this.stashedItem);
                gave = true;
            }
        }
        if (!gave) {
            targetMage.giveItem(this.stashedItem);
        }
        if (context == null) {
            if (targetMage != null) {
                targetMage.checkWand();
            }
        } else {
            context.checkWand();
        }
        this.stashedItem = null;
        this.targetMage = null;
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity entity = context.getTargetEntity();
        if (entity == null) {
            if (!context.getTargetsCaster()) {
                return SpellResult.NO_TARGET;
            }
            entity = context.getEntity();
        }
        if (entity == null || !(entity instanceof Player)) {
            return SpellResult.NO_TARGET;
        }
        Player player = (Player)entity;
        MageController controller = context.getController();
        Mage mage = controller.getMage(player);
        Wand activeWand = mage.getActiveWand();
        Wand offhandWand = mage.getOffhandWand();
        ItemStack activeItem = null;
        if (offhandWand == context.getWand()) {
            this.isOffhand = true;
            activeWand = offhandWand;
            activeItem = player.getInventory().getItemInOffHand();
        } else {
            if (activeWand != context.getWand()) {
                return SpellResult.NO_TARGET;
            }
            this.isOffhand = false;
            activeItem = player.getInventory().getItemInMainHand();
        }
        if (InventoryUtils.isEmpty(activeItem)) {
            return SpellResult.FAIL;
        }
        if (activeWand != null) {
            activeWand.deactivate();
        }
        this.slotNumber = player.getInventory().getHeldItemSlot();
        if (this.isOffhand) {
            this.stashedItem = player.getInventory().getItemInOffHand();
            player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
        } else {
            this.stashedItem = player.getInventory().getItemInMainHand();
            player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
        }
        this.targetMage = new WeakReference<Mage>(mage);
        context.registerForUndo(new StashWandUndoAction(context));
        return SpellResult.CAST;
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.returnOnFinish = parameters.getBoolean("return_on_finish", false);
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("return_on_finish");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("return_on_finish")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public void finish(CastContext context) {
        super.finish(context);
        if (this.returnOnFinish) {
            this.returnItem(context);
        }
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    private class StashWandUndoAction
    implements Runnable {
        private final WeakReference<CastContext> context;

        public StashWandUndoAction(CastContext context) {
            this.context = new WeakReference<CastContext>(context);
        }

        @Override
        public void run() {
            StashWandAction.this.returnItem((CastContext)this.context.get());
        }
    }
}

