/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.Target;
import com.elmakers.mine.bukkit.utility.Targeting;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class RetargetAction
extends CompoundAction {
    private Targeting targeting;
    private double range;

    @Override
    public void initialize(Spell spell, ConfigurationSection baseParameters) {
        super.initialize(spell, baseParameters);
        this.targeting = new Targeting();
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.targeting.start(context.getEyeLocation());
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.targeting.processParameters(parameters);
        this.range = parameters.getDouble("range", 32.0);
    }

    @Override
    public SpellResult step(CastContext context) {
        Target target;
        context.addWork(200);
        Entity targetEntity = null;
        Location targetLocation = null;
        CastContext useContext = context;
        if (this.hasActions()) {
            useContext = this.actionContext;
        }
        if ((target = this.targeting.target(useContext, this.range)) != null && target.isValid()) {
            targetEntity = target.getEntity();
            targetLocation = target.getLocation();
        }
        useContext.setTargetLocation(targetLocation);
        useContext.setTargetEntity(targetEntity);
        return this.startActions();
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("fov");
        parameters.add("target_count");
        parameters.add("hitbox");
        parameters.add("range");
        parameters.add("close_range");
        parameters.add("close_fov");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("hitbox")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("target_count") || parameterKey.equals("range") || parameterKey.equals("fov") || parameterKey.equals("close_range") || parameterKey.equals("close_fov")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

