/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectAction
extends BaseSpellAction {
    private Set<PotionEffectType> removeEffects;
    private Collection<PotionEffect> addEffects;
    private Integer duration;
    private boolean ambient = true;
    private boolean particles = true;
    private int amplifier = 0;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        Collection<PotionEffect> mappedEffects;
        super.prepare(context, parameters);
        this.ambient = parameters.getBoolean("effects_ambient", true);
        this.particles = parameters.getBoolean("effects_particles", true);
        this.amplifier = parameters.getInt("amplifier", 0);
        if (parameters.contains("duration")) {
            this.duration = parameters.getInt("duration");
            if (parameters.contains("duration_multiplier")) {
                this.duration = (int)Math.ceil(parameters.getDouble("duration_multiplier") * (double)this.duration.intValue());
            }
        } else {
            this.duration = null;
        }
        if (parameters.contains("remove_effects")) {
            this.removeEffects = new HashSet<PotionEffectType>();
            List removeEffectKeys = parameters.getStringList("remove_effects");
            for (String removeKey : removeEffectKeys) {
                try {
                    PotionEffectType removeType = PotionEffectType.getByName((String)removeKey);
                    if (removeType == null) continue;
                    this.removeEffects.add(removeType);
                }
                catch (Exception ex) {
                    context.getController().getLogger().log(Level.WARNING, "Invalid potion effect type: " + removeKey, ex);
                }
            }
        } else {
            this.removeEffects = null;
        }
        this.addEffects = BaseSpell.getPotionEffects(parameters, this.duration, this.ambient, this.particles);
        if (this.addEffects == null) {
            this.addEffects = Collections.emptyList();
        }
        if (!(mappedEffects = this.getMappedPotionEffects(parameters, context)).isEmpty()) {
            ArrayList<PotionEffect> newEffects = new ArrayList<PotionEffect>(this.addEffects.size() + mappedEffects.size());
            newEffects.addAll(this.addEffects);
            newEffects.addAll(mappedEffects);
            this.addEffects = newEffects;
        }
    }

    private Collection<PotionEffect> getMappedPotionEffects(ConfigurationSection parameters, CastContext context) {
        String sectionKey = parameters.contains("potion_effects") ? "potion_effects" : "add_effects";
        ConfigurationSection section = parameters.getConfigurationSection(sectionKey);
        int duration = parameters.getInt("duration", 500);
        if (section != null) {
            Set keys = section.getKeys(false);
            ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>(keys.size());
            int ticks = duration / 50;
            for (String key : keys) {
                int strength = section.getInt(key, 0);
                PotionEffectType type = PotionEffectType.getByName((String)key);
                if (type != null) {
                    effects.add(new PotionEffect(type, type.isInstant() ? 1 : ticks, strength, this.ambient, this.particles));
                    continue;
                }
                context.getLogger().warning("Invalid potion effect type: " + key);
            }
            return effects;
        }
        List<PotionEffect> effects = ConfigurationUtils.getPotionEffectObjects(parameters, sectionKey, context.getLogger(), duration, this.amplifier, this.ambient, this.particles);
        return effects == null ? Collections.emptyList() : effects;
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity entity = context.getTargetEntity();
        if (!(entity instanceof LivingEntity)) {
            return SpellResult.NO_TARGET;
        }
        LivingEntity targetEntity = (LivingEntity)entity;
        boolean effected = false;
        if (this.removeEffects != null) {
            context.registerPotionEffects((Entity)targetEntity);
            Collection currentEffects = targetEntity.getActivePotionEffects();
            for (PotionEffect effect : currentEffects) {
                PotionEffectType removeType = effect.getType();
                if (!this.removeEffects.contains(removeType) || effect.getDuration() >= 0x1FFFFFFF) continue;
                targetEntity.removePotionEffect(removeType);
                effected = true;
            }
        }
        if (this.addEffects != null && this.addEffects.size() > 0) {
            effected = true;
            for (PotionEffect effect : this.addEffects) {
                if (!CompatibilityUtils.applyPotionEffect(targetEntity, effect)) continue;
                context.registerPotionEffectForRemoval((Entity)targetEntity, effect.getType());
            }
        }
        return effected ? SpellResult.CAST : SpellResult.NO_TARGET;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        PotionEffectType[] effectTypes;
        super.getParameterNames(spell, parameters);
        parameters.add("duration");
        for (PotionEffectType effectType : effectTypes = PotionEffectType.values()) {
            if (effectType == null) continue;
            parameters.add("effect_" + effectType.getName().toLowerCase());
        }
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("duration")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_DURATIONS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

