/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationStore;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationTransform;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public class EquationAction
extends CompoundAction {
    private EquationTransform xTransform;
    private EquationTransform yTransform;
    private EquationTransform zTransform;
    private EquationTransform x2Transform;
    private EquationTransform y2Transform;
    private EquationTransform z2Transform;
    private boolean orient;
    private boolean orientPitch;
    private boolean reorient;
    private int iterations;
    private int iterations2;
    public String variable = "t";
    public String variable2 = "t2";
    private int iteration;
    private int iteration2;
    private Vector direction;
    private Location startLocation;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.reorient = parameters.getBoolean("reorient", false);
        this.orient = parameters.getBoolean("orient", false);
        this.orientPitch = parameters.getBoolean("orient_pitch", true);
        this.iterations = parameters.getInt("iterations", 1);
        this.iterations2 = parameters.getInt("iterations2", 0);
        this.variable = parameters.getString("variable", "t");
        this.variable2 = parameters.getString("variable2", "t");
        String xEquation = parameters.getString("x_equation");
        String yEquation = parameters.getString("y_equation");
        String zEquation = parameters.getString("z_equation");
        this.xTransform = EquationStore.getInstance().getTransform(xEquation, this.variable, "i");
        this.yTransform = EquationStore.getInstance().getTransform(yEquation, this.variable, "i");
        this.zTransform = EquationStore.getInstance().getTransform(zEquation, this.variable, "i");
        String x2Equation = parameters.getString("x2_equation");
        String y2Equation = parameters.getString("y2_equation");
        String z2Equation = parameters.getString("z2_equation");
        if (x2Equation != null && y2Equation != null && z2Equation != null && this.iterations2 > 0) {
            this.x2Transform = EquationStore.getInstance().getTransform(x2Equation, this.variable, this.variable2, "i", "i2");
            this.y2Transform = EquationStore.getInstance().getTransform(y2Equation, this.variable, this.variable2, "i", "i2");
            this.z2Transform = EquationStore.getInstance().getTransform(z2Equation, this.variable, this.variable2, "i", "i2");
        }
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.iteration = 0;
        this.iteration2 = 0;
        this.startLocation = context.getEyeLocation();
        if (this.startLocation == null) {
            return;
        }
        Location targetLocation = context.getTargetLocation();
        if (targetLocation == null) {
            this.direction = this.startLocation.getDirection();
        } else {
            this.startLocation = targetLocation;
            Vector startLoc = this.startLocation.toVector();
            Vector targetLoc = new Vector(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ());
            this.direction = targetLoc.clone();
            this.direction.subtract(startLoc);
            this.direction.normalize();
        }
    }

    @Override
    public SpellResult step(CastContext context) {
        if (this.startLocation == null) {
            return SpellResult.NO_TARGET;
        }
        context.addWork(100);
        context.playEffects("iterate");
        return this.startActions();
    }

    @Override
    public boolean next(CastContext context) {
        if (this.startLocation == null) {
            return false;
        }
        Location target = this.startLocation.clone();
        Double xValue = this.xTransform.get(this.iteration, this.iterations);
        Double yValue = this.yTransform.get(this.iteration, this.iterations);
        Double zValue = this.zTransform.get(this.iteration, this.iterations);
        Vector result = new Vector(xValue.doubleValue(), yValue.doubleValue(), zValue.doubleValue());
        Location location = context.getLocation();
        if (!this.reorient && this.direction != null) {
            location.setDirection(this.direction);
        }
        if (this.orient && this.orientPitch) {
            result = VectorUtils.rotateVector(result, location);
        } else if (this.orient) {
            result = VectorUtils.rotateVector(result, location.getYaw(), 0.0f);
        }
        target.add(result);
        if (this.x2Transform != null && this.y2Transform != null && this.z2Transform != null) {
            Double x2Value = this.x2Transform.get(this.iteration, this.iteration2, this.iterations2, this.iterations2);
            Double y2Value = this.y2Transform.get(this.iteration, this.iteration2, this.iterations2, this.iterations2);
            Double z2Value = this.z2Transform.get(this.iteration, this.iteration2, this.iterations2, this.iterations2);
            Vector result2 = new Vector(x2Value.doubleValue(), y2Value.doubleValue(), z2Value.doubleValue());
            if (this.orient && this.orientPitch) {
                result2 = VectorUtils.rotateVector(result2, location);
            } else if (this.orient) {
                result2 = VectorUtils.rotateVector(result2, location.getYaw(), 0.0f);
            }
            target.add(result2);
        }
        this.actionContext.setTargetLocation(target);
        ++this.iteration2;
        if (this.iteration2 > this.iterations2) {
            this.iteration2 = 0;
            ++this.iteration;
        }
        return this.iteration <= this.iterations;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("x_equation");
        parameters.add("y_equation");
        parameters.add("z_equation");
        parameters.add("x2_equation");
        parameters.add("y2_equation");
        parameters.add("z2_equation");
        parameters.add("variable");
        parameters.add("variable2");
        parameters.add("iterations");
        parameters.add("iterations2");
        parameters.add("reorient");
        parameters.add("orient");
        parameters.add("orient_pitch");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("orient") || parameterKey.equals("reorient") || parameterKey.equals("orient_pitch")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("iterations") || parameterKey.equals("iterations2")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public int getActionCount() {
        return this.iterations * (this.iterations2 + 1) * super.getActionCount();
    }
}

