/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.LegacyEntityMetadataUtils;
import com.elmakers.mine.bukkit.utility.PersistentEntityMetadataUtils;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public abstract class EntityMetadataUtils {
    public static EntityMetadataUtils metadataUtils;
    protected final Plugin plugin;

    protected EntityMetadataUtils(Plugin plugin) {
        this.plugin = plugin;
    }

    protected static boolean hasPersistentMetadata() {
        int[] version = CompatibilityUtils.getServerVersion();
        if (version[0] <= 1 && version[1] < 16) {
            return false;
        }
        try {
            Class.forName("org.bukkit.persistence.PersistentDataContainer");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void initialize(Plugin plugin) {
        if (EntityMetadataUtils.hasPersistentMetadata()) {
            metadataUtils = new PersistentEntityMetadataUtils(plugin);
        } else {
            plugin.getLogger().info("Persistent metadata is not available, will rely on custom names to restore persistent magic mobs");
            metadataUtils = new LegacyEntityMetadataUtils(plugin);
        }
    }

    public static EntityMetadataUtils instance() {
        return metadataUtils;
    }

    public abstract void remove(Entity var1, String var2);

    public abstract boolean getBoolean(Entity var1, String var2);

    public abstract Double getDouble(Entity var1, String var2);

    public abstract Long getLong(Entity var1, String var2);

    public abstract String getString(Entity var1, String var2);

    public abstract void setBoolean(Entity var1, String var2, boolean var3);

    public abstract void setDouble(Entity var1, String var2, double var3);

    public abstract void setLong(Entity var1, String var2, long var3);

    public abstract void setString(Entity var1, String var2, String var3);
}

