/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.api.spell;

import org.apache.commons.lang.StringUtils;

public class SpellKey {
    private final String key;
    private final String baseKey;
    private final int level;
    private final boolean isVariant;

    public SpellKey(String baseKey, int level) {
        this.baseKey = baseKey;
        this.level = level;
        if (this.level > 1) {
            this.isVariant = true;
            this.key = baseKey + "|" + level;
        } else {
            this.isVariant = false;
            this.key = baseKey;
        }
    }

    public SpellKey(String key) {
        this.key = key;
        if (key.contains("|")) {
            String[] pieces = StringUtils.split((String)key, (String)"|");
            this.baseKey = pieces[0];
            int parsedLevel = 1;
            if (pieces.length > 1) {
                try {
                    parsedLevel = Integer.parseInt(pieces[1]);
                }
                catch (Exception ex) {
                    parsedLevel = 1;
                    ex.printStackTrace();
                }
            }
            this.level = parsedLevel;
            this.isVariant = true;
        } else {
            this.level = 1;
            this.baseKey = key;
            this.isVariant = false;
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getBaseKey() {
        return this.baseKey;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isVariant() {
        return this.isVariant;
    }

    public String toString() {
        return this.key;
    }
}

