/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.BlockFace;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.DirectionUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class RecurseAction
extends CompoundAction {
    protected int recursionDepth;
    protected int limit;
    protected List<BlockFace> directions;
    protected Set<BlockFace> priority;
    protected Set<MaterialAndData> replaceable = null;
    protected boolean checker;
    protected boolean replace;
    protected boolean depthFirst;
    protected boolean debugDepth;
    protected List<MaterialAndData> debugMaterials;
    protected Deque<StackEntry> stack;
    protected Deque<StackEntry> prioritized;
    protected StackEntry current;
    protected Set<Long> touched;

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.touched.clear();
        this.stack.clear();
        if (this.prioritized != null) {
            this.prioritized.clear();
        }
        this.current = this.checker ? new StackEntry(context.getTargetBlock(), 0, 0) : new StackEntry(context.getTargetBlock(), -1, 0);
    }

    @Override
    public void finish(CastContext context) {
        super.finish(context);
        this.touched.clear();
        this.stack.clear();
        if (this.prioritized != null) {
            this.prioritized.clear();
        }
    }

    @Override
    protected void addHandlers(Spell spell, ConfigurationSection parameters) {
        this.addHandler(spell, "actions");
        this.addHandler(spell, "maxdepth");
    }

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.recursionDepth = parameters.getInt("size", 32);
        this.recursionDepth = parameters.getInt("depth", this.recursionDepth);
        this.directions = DirectionUtils.getDirections(parameters, "faces");
        if (parameters.contains("priority_faces")) {
            this.priority = new HashSet<BlockFace>(DirectionUtils.getDirections(parameters, "priority_faces"));
            this.prioritized = new ArrayDeque<StackEntry>(this.recursionDepth + 10);
        }
        this.replaceable = null;
        this.touched = new HashSet<Long>();
        this.stack = new ArrayDeque<StackEntry>(this.recursionDepth + 10);
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        Material baseMaterial;
        super.prepare(context, parameters);
        this.checker = parameters.getBoolean("checkered", false);
        this.replace = parameters.getBoolean("replace", false);
        this.depthFirst = parameters.getBoolean("depth_first", false);
        this.recursionDepth = parameters.getInt("size", 32);
        this.recursionDepth = parameters.getInt("depth", this.recursionDepth);
        this.limit = parameters.getInt("limit", 0);
        this.debugDepth = parameters.getBoolean("debug_depth", true);
        String debugKey = parameters.getString("debug_material");
        if (debugKey != null && !debugKey.isEmpty() && (baseMaterial = Material.getMaterial((String)debugKey.toUpperCase())) != null) {
            this.debugMaterials = new ArrayList<MaterialAndData>(DefaultMaterials.getColorBlocks(baseMaterial));
            Collections.sort(this.debugMaterials, new Comparator<MaterialAndData>(){

                @Override
                public int compare(MaterialAndData o1, MaterialAndData o2) {
                    if (o1.getMaterial() == o2.getMaterial()) {
                        return o1.getData() - o2.getData();
                    }
                    return o1.getMaterial().name().compareTo(o2.getMaterial().name());
                }
            });
        }
        if (this.replace) {
            int i;
            if (this.replaceable == null) {
                this.replaceable = new HashSet<MaterialAndData>();
            }
            Block targetBlock = context.getTargetBlock();
            this.replaceable.clear();
            if (targetBlock == null) {
                return;
            }
            MaterialAndData targetMaterialAndData = new MaterialAndData(targetBlock);
            if (targetMaterialAndData.isValid()) {
                this.replaceable.add(targetMaterialAndData);
            }
            Material targetMaterial = targetBlock.getType();
            if (parameters.getBoolean("auto_water", true) && DefaultMaterials.isWater(targetMaterial)) {
                for (Material material : DefaultMaterials.getWater()) {
                    for (i = 0; i < 15; i = (int)((byte)(i + 1))) {
                        this.replaceable.add(new MaterialAndData(material, (short)i));
                    }
                }
            }
            if (parameters.getBoolean("auto_lava", true) && DefaultMaterials.isLava(targetMaterial)) {
                for (Material material : DefaultMaterials.getLava()) {
                    for (i = 0; i < 15; i = (int)((byte)(i + 1))) {
                        this.replaceable.add(new MaterialAndData(material, (short)i));
                    }
                }
            }
            if (parameters.getBoolean("auto_snow", true) && targetMaterial == Material.SNOW) {
                for (int i2 = 0; i2 < 15; i2 = (int)((byte)(i2 + 1))) {
                    this.replaceable.add(new MaterialAndData(Material.SNOW, (short)i2));
                }
            }
        } else {
            this.replaceable = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean next(CastContext context) {
        ++this.current.face;
        if (this.current.face >= this.directions.size()) {
            if (this.stack.isEmpty()) {
                if (this.prioritized == null) return false;
                if (this.prioritized.isEmpty()) return false;
                this.current = this.prioritized.pop();
            } else {
                this.current = this.stack.pop();
            }
        }
        if (this.limit == 0) return true;
        if (this.touched.size() >= this.limit) return false;
        return true;
    }

    @Override
    public SpellResult step(CastContext context) {
        Deque<StackEntry> queue;
        Block block;
        Block originalBlock = block = this.current.block;
        int faceIndex = this.current.face;
        BlockFace direction = null;
        if (faceIndex >= 0) {
            direction = this.directions.get(faceIndex);
            block = direction.getRelative(block);
        }
        boolean prioritize = !this.depthFirst && this.priority != null && direction != null && this.priority.contains((Object)direction);
        Deque<StackEntry> deque = queue = prioritize ? this.prioritized : this.stack;
        if (!context.isDestructible(block)) {
            return SpellResult.NO_TARGET;
        }
        long id = BlockData.getBlockId(block);
        if (this.debugMaterials != null && !this.debugDepth) {
            context.registerForUndo(originalBlock);
            this.debugMaterials.get(faceIndex + 1).modify(originalBlock);
        }
        if (this.touched.contains(id)) {
            return SpellResult.NO_TARGET;
        }
        if (this.current.depth > this.recursionDepth) {
            Block nextBlock;
            if (this.hasActions("maxdepth")) {
                return this.startActions("maxdepth");
            }
            Block block2 = nextBlock = direction == null ? null : direction.getRelative(block);
            if (nextBlock != null && this.touched.contains(BlockData.getBlockId(nextBlock))) {
                if (this.debugMaterials != null && !this.debugDepth) {
                    context.registerForUndo(block);
                    this.debugMaterials.get(this.debugMaterials.size() - 2).modify(block);
                }
                return this.startActions();
            }
            if (this.debugMaterials != null && !this.debugDepth) {
                context.registerForUndo(block);
                this.debugMaterials.get(this.debugMaterials.size() - 1).modify(block);
            }
            return SpellResult.NO_TARGET;
        }
        if (this.debugMaterials != null) {
            context.registerForUndo(block);
            if (this.debugDepth) {
                this.debugMaterials.get(this.current.depth % this.debugMaterials.size()).modify(block);
            } else {
                this.debugMaterials.get(0).modify(block);
            }
        }
        if (this.replaceable != null && !this.replaceable.contains(new MaterialAndData(block))) {
            return SpellResult.NO_TARGET;
        }
        if (faceIndex >= 0) {
            if (this.checker && direction != null) {
                block = direction.getRelative(block);
            }
            if (prioritize) {
                queue.push(this.current);
                queue.addAll(this.stack);
                this.stack.clear();
                this.current = new StackEntry(block, -1, this.current.depth + 1);
            } else if (this.depthFirst) {
                queue.push(this.current);
                this.current = new StackEntry(block, -1, this.current.depth + 1);
            } else {
                queue.add(new StackEntry(block, this.current.depth + 1));
            }
        }
        this.touched.add(id);
        this.actionContext.setTargetLocation(block.getLocation());
        this.actionContext.playEffects("recurse");
        return this.startActions();
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("depth");
        parameters.add("size");
        parameters.add("faces");
        parameters.add("depth_first");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("faces")) {
            examples.addAll(Arrays.asList(DirectionUtils.EXAMPLE_DIRECTIONS));
        } else if (parameterKey.equals("depth") || parameterKey.equals("size")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("depth_first")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public int getActionCount() {
        return this.recursionDepth * super.getActionCount();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    private static class StackEntry {
        public Block block;
        public int face;
        public int depth;

        public StackEntry(Block block, int depth) {
            this.block = block;
            this.face = 0;
            this.depth = depth;
        }

        public StackEntry(Block block, int face, int depth) {
            this.block = block;
            this.face = face;
            this.depth = depth;
        }
    }
}

