/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.BlockFace;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.DirectionUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class RaiseBlockAction
extends BaseSpellAction {
    private int verticalSearchDistance;
    private List<BlockFace> directions;
    private Deque<WeightedPair<Integer>> slopeProbability;
    private boolean consumeBlocks = false;
    private boolean consumeVariants = true;
    private int maxHeight;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        if (parameters.contains("slopes")) {
            this.slopeProbability = new ArrayDeque<WeightedPair<Integer>>();
            RandomUtils.populateIntegerProbabilityMap(this.slopeProbability, ConfigurationUtils.getConfigurationSection(parameters, "slopes"));
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.consumeBlocks = parameters.getBoolean("consume", false);
        this.consumeVariants = parameters.getBoolean("consume_variants", true);
        this.verticalSearchDistance = parameters.getInt("vertical_range", context.getVerticalSearchDistance());
        this.directions = DirectionUtils.getDirections(parameters, "faces");
        this.maxHeight = parameters.getInt("max_height", 0);
    }

    @Override
    public SpellResult perform(CastContext context) {
        int slope;
        UndoList undoList;
        Block targetBlock = context.getTargetBlock();
        if (!context.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.consumeBlocks && !context.isConsumeFree() && (undoList = context.getUndoList()) != null) {
            undoList.setConsumed(true);
        }
        ArrayList<Material> underground = new ArrayList<Material>();
        ArrayList<Material> ground = new ArrayList<Material>();
        int maxHeight = targetBlock.getY();
        block0: for (BlockFace face : this.directions) {
            Block check = face.getRelative(targetBlock);
            if (context.isTransparent(check)) continue;
            for (int vertical = 0; vertical <= this.verticalSearchDistance; ++vertical) {
                Block next = BlockFace.UP.getRelative(check);
                if (context.isTransparent(next)) {
                    ground.add(check.getType());
                    continue block0;
                }
                underground.add(check.getType());
                check = next;
                maxHeight = Math.max(check.getY(), maxHeight);
            }
        }
        if (this.maxHeight > 0 && maxHeight > this.maxHeight) {
            maxHeight = this.maxHeight;
        }
        int n = slope = this.slopeProbability == null ? 0 : (Integer)RandomUtils.weightedRandom(this.slopeProbability);
        if (maxHeight - targetBlock.getY() <= slope) {
            return SpellResult.NO_TARGET;
        }
        Mage mage = context.getMage();
        int targetHeight = maxHeight - slope;
        while (targetBlock.getY() < targetHeight) {
            MaterialAndData block;
            if (!context.hasBuildPermission(targetBlock = BlockFace.UP.getRelative(targetBlock))) {
                return SpellResult.INSUFFICIENT_PERMISSION;
            }
            if (!context.isTransparent(targetBlock) || !context.isDestructible(targetBlock)) continue;
            context.registerForUndo(targetBlock);
            ArrayList<Material> materials = targetBlock.getY() == targetHeight ? ground : underground;
            Material material = (Material)RandomUtils.getRandom(materials);
            if (this.consumeBlocks && !context.isConsumeFree() && !mage.consumeBlock(block = new MaterialAndData(material), this.consumeVariants)) {
                String requiresMessage = context.getMessage("insufficient_resources");
                context.sendMessageKey("insufficient_resources", requiresMessage.replace("$cost", block.getName(context.getController().getMessages())));
                return SpellResult.STOP;
            }
            targetBlock.setType(material);
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresBuildPermission() {
        return true;
    }
}

