/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.npc.MagicNPC;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;

public class ModifyNPCAction
extends BaseSpellAction {
    private UUID npcId;
    private String name;
    private String npcTemplate;
    private ConfigurationSection npcConfiguration;
    private boolean nameFromWand;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.name = parameters.getString("name");
        this.npcTemplate = parameters.getString("npc_template");
        this.npcConfiguration = parameters.getConfigurationSection("npc_parameters");
        this.nameFromWand = parameters.getBoolean("name_from_wand", false);
        String idString = parameters.getString("npc_id");
        if (idString != null && !idString.isEmpty()) {
            try {
                this.npcId = UUID.fromString(idString);
            }
            catch (Exception ex) {
                context.getLogger().warning("Invalid npc_id: " + idString);
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Wand wand;
        if (this.npcId == null) {
            return SpellResult.FAIL;
        }
        MageController controller = context.getController();
        MagicNPC npc = controller.getNPC(this.npcId);
        if (npc == null) {
            return SpellResult.NO_TARGET;
        }
        if (this.name != null && !this.name.isEmpty()) {
            npc.setName(this.name);
        }
        if (this.npcTemplate != null) {
            npc.setTemplate(this.npcTemplate);
        }
        if (this.npcConfiguration != null) {
            Set keys = this.npcConfiguration.getKeys(true);
            for (String key : keys) {
                if (this.npcConfiguration.isConfigurationSection(key)) continue;
                if (this.npcConfiguration.isString(key)) {
                    String value = this.npcConfiguration.getString(key);
                    value = this.parameterize(context, value, npc.getId(), npc.getName());
                    npc.configure(key, value);
                    continue;
                }
                npc.configure(key, this.npcConfiguration.get(key));
            }
        }
        if (this.nameFromWand && (wand = context.getWand()) != null) {
            npc.setName(wand.getName());
        }
        return SpellResult.CAST;
    }

    private String parameterize(CastContext context, String message, UUID id, String name) {
        message = message.replace("$npc_name", name);
        message = message.replace("$npc", id.toString());
        message = context.parameterizeMessage(message);
        return message;
    }
}

