/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CheckAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;

public class CheckRequirementsAction
extends CheckAction {
    private Collection<Requirement> requirements;
    private boolean sendMessage;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.sendMessage = parameters.getBoolean("send_message");
        this.requirements = ConfigurationUtils.getRequirements(parameters);
        if (this.requirements == null || this.requirements.isEmpty()) {
            context.getLogger().warning("CheckRequirements action missing requirements in spell " + context.getName());
        }
    }

    @Override
    protected boolean isAllowed(CastContext context) {
        if (this.requirements == null) {
            return true;
        }
        String message = context.getController().checkRequirements(context, this.requirements);
        if (this.sendMessage && message != null) {
            context.getMage().sendMessage(message);
        }
        return message == null;
    }
}

