/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class BrushAction
extends CompoundAction {
    private List<String> brushes = new ArrayList<String>();
    private boolean sample = false;
    private String brushMod;
    private Map<Material, MaterialAndData> materialMap;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        List brushList;
        super.prepare(context, parameters);
        this.brushes.clear();
        this.brushMod = parameters.getString("brushmod");
        String materialKey = parameters.getString("brush", null);
        if (materialKey != null) {
            this.addBrush(materialKey);
        }
        if ((brushList = parameters.getStringList("brushes")) != null) {
            for (String brushKey : brushList) {
                this.addBrush(brushKey);
            }
        }
        this.sample = parameters.getBoolean("sample", false);
        ConfigurationSection replaceConfiguration = parameters.getConfigurationSection("replacements");
        if (replaceConfiguration != null) {
            this.materialMap = new HashMap<Material, MaterialAndData>();
            Set fromKeys = replaceConfiguration.getKeys(false);
            for (String fromKey : fromKeys) {
                Material fromMaterial;
                try {
                    fromMaterial = Material.valueOf((String)fromKey.toUpperCase());
                }
                catch (Exception ex) {
                    context.getLogger().warning("Invalid material replacement (from): " + fromKey);
                    continue;
                }
                String toKey = replaceConfiguration.getString(fromKey);
                MaterialAndData toMaterial = new MaterialAndData(toKey);
                if (!toMaterial.isValid()) {
                    context.getLogger().warning("Invalid material replacement (to): " + toKey);
                    continue;
                }
                this.materialMap.put(fromMaterial, toMaterial);
            }
        }
    }

    protected void addBrush(String brushKey) {
        this.brushes.add(brushKey);
    }

    @Override
    public SpellResult step(CastContext context) {
        MaterialBrush activeBrush;
        MaterialAndData replacement;
        if (this.brushes.size() == 0 && !this.sample) {
            return this.startActions();
        }
        if (this.sample) {
            Block targetBlock = context.getTargetBlock();
            if (targetBlock != null) {
                Mage mage = context.getMage();
                com.elmakers.mine.bukkit.block.MaterialBrush brush = new com.elmakers.mine.bukkit.block.MaterialBrush(mage, targetBlock);
                this.actionContext.setBrush(brush);
            }
        } else if (this.brushes != null) {
            String brushKey = this.brushes.get(context.getRandom().nextInt(this.brushes.size()));
            com.elmakers.mine.bukkit.block.MaterialBrush brush = null;
            if (this.brushMod != null) {
                brush = new com.elmakers.mine.bukkit.block.MaterialBrush(context.getMage(), context.getLocation(), this.brushMod);
                brush.update(brushKey);
            } else {
                brush = new com.elmakers.mine.bukkit.block.MaterialBrush(context.getMage(), context.getLocation(), brushKey);
            }
            this.actionContext.setBrush(brush);
        }
        if (this.materialMap != null && (replacement = this.materialMap.get((activeBrush = this.actionContext.getBrush()).getMaterial())) != null) {
            activeBrush.setMaterial(replacement.getMaterial());
            activeBrush.setData(replacement.getData());
        }
        return this.startActions();
    }

    @Override
    public boolean usesBrush() {
        return false;
    }
}

