/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.tasks;

import com.elmakers.mine.bukkit.api.data.MageData;
import com.elmakers.mine.bukkit.api.event.MageLoadEvent;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.magic.Mage;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class MageLoadTask
implements Runnable {
    private final Mage mage;
    private final MageData data;

    public MageLoadTask(Mage mage, MageData data) {
        this.mage = mage;
        this.data = data;
    }

    @Override
    public void run() {
        try {
            this.mage.onLoad(this.data);
            this.mage.setLoading(false);
            if (this.mage.isValid()) {
                MageController controller = this.mage.getController();
                if (this.mage.isPlayer() && this.mage.isResourcePackEnabled()) {
                    controller.promptResourcePack(this.mage.getPlayer());
                } else if (this.mage.isResourcePackPrompt()) {
                    controller.promptNoResourcePack(this.mage.getPlayer());
                }
            }
            MageLoadEvent event = new MageLoadEvent(this.mage, this.data == null);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        catch (Exception ex) {
            this.mage.getController().getLogger().warning("Failed to load mage data for player " + this.mage.getName());
            this.mage.setLoading(true);
        }
    }
}

