/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityAnimalData;
import org.bukkit.DyeColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Wolf;

public class EntityWolfData
extends EntityAnimalData {
    private boolean isAngry;
    private DyeColor collarColor;

    public EntityWolfData() {
    }

    public EntityWolfData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        String colorString = parameters.getString("color");
        if (colorString != null) {
            try {
                this.collarColor = DyeColor.valueOf((String)colorString.toUpperCase());
            }
            catch (Exception ex) {
                this.collarColor = null;
            }
        }
        this.isAngry = parameters.getBoolean("angry", false);
    }

    public EntityWolfData(Entity entity) {
        super(entity);
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            this.collarColor = wolf.getCollarColor();
            this.isAngry = wolf.isAngry();
            this.sitting = wolf.isSitting();
        }
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            if (this.collarColor != null) {
                wolf.setCollarColor(this.collarColor);
            }
            wolf.setAngry(this.isAngry);
            wolf.setSitting(this.sitting);
        }
    }
}

