/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.configuration;

import com.elmakers.mine.bukkit.configuration.ParameterizedConfiguration;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;

public class MagicConfiguration
extends ParameterizedConfiguration {
    private final MagicController controller;

    public MagicConfiguration(MagicController controller, ConfigurationSection copy, String logContext) {
        this(controller, logContext);
        ConfigurationUtils.addConfigurations((ConfigurationSection)this, copy);
    }

    public MagicConfiguration(MagicController controller, String logContext) {
        super(logContext);
        this.controller = controller;
    }

    public MagicConfiguration(MagicConfiguration copy) {
        super(copy);
        this.controller = copy.controller;
    }

    public static MagicConfiguration getKeyed(MagicController controller, ConfigurationSection copy, String logPrefix, String key) {
        return new MagicConfiguration(controller, copy, logPrefix + "." + key);
    }

    public static MagicConfiguration getKeyed(MagicController controller, ConfigurationSection copy, String logContext) {
        return new MagicConfiguration(controller, copy, logContext);
    }

    @Override
    protected double getParameter(String parameter) {
        Double value = this.controller.getBuiltinAttribute(parameter);
        return value == null || Double.isNaN(value) || Double.isInfinite(value) ? 0.0 : value;
    }

    @Override
    protected Set<String> getParameters() {
        return this.controller.getAttributes();
    }
}

