/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.warp;

import com.elmakers.mine.bukkit.api.warp.Warp;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.TextUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.WordUtils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;

public class MagicWarp
implements Warp {
    @Nonnull
    private final String key;
    @Nonnull
    private String locationDescriptor;
    @Nullable
    private Location location;
    private String icon;
    private String name;
    private String description;
    private String markerIcon;
    private String markerSet;
    private String group;
    private boolean locked;

    public MagicWarp(String key, ConfigurationSection warps) {
        this.key = key;
        if (warps.isConfigurationSection(key)) {
            ConfigurationSection configuration = warps.getConfigurationSection(key);
            this.locationDescriptor = configuration.getString("location");
            this.icon = configuration.getString("icon");
            this.name = configuration.getString("name");
            this.description = configuration.getString("description");
            this.markerIcon = configuration.getString("marker_icon");
            this.markerSet = configuration.getString("marker_set");
            this.group = configuration.getString("group");
            this.locked = configuration.getBoolean("locked");
        } else {
            this.locationDescriptor = warps.getString(key);
        }
    }

    public MagicWarp(String key, Location location) {
        this.key = key;
        this.setLocation(location);
    }

    public void save(ConfigurationSection warps) {
        ConfigurationSection warpConfig = warps.createSection(this.key);
        warpConfig.set("location", (Object)this.locationDescriptor);
        warpConfig.set("icon", (Object)this.icon);
        warpConfig.set("name", (Object)this.name);
        warpConfig.set("description", (Object)this.description);
        warpConfig.set("marker_set", (Object)this.markerSet);
        warpConfig.set("marker_icon", (Object)this.markerIcon);
        warpConfig.set("group", (Object)this.group);
        warpConfig.set("locked", (Object)this.locked);
    }

    @Override
    @Nullable
    public Location getLocation() {
        if (this.location == null || this.location.getWorld() == null) {
            this.location = ConfigurationUtils.toLocation(this.locationDescriptor);
        }
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
        this.locationDescriptor = ConfigurationUtils.fromLocation(location);
    }

    public void checkMarker(MagicController controller) {
        if (this.markerIcon != null) {
            controller.addMarker("warp-" + this.key, this.markerIcon, this.getMarkerSet(), this.getName(), this.getLocation(), this.description);
        } else {
            this.removeMarker(controller);
        }
    }

    public void removeMarker(MagicController controller) {
        controller.removeMarker("warp-" + this.key, this.getMarkerSet());
    }

    public static String keyToName(String key) {
        String converted = key.replace("_", " ").replace("-", " ");
        return WordUtils.capitalizeFully((String)converted);
    }

    @Override
    @Nonnull
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return MagicWarp.keyToName(this.key);
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String getMarkerSet() {
        return this.markerSet != null ? this.markerSet : "magic";
    }

    @Nullable
    public String getMarkerIcon() {
        return this.markerIcon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMarkerIcon(String markerIcon) {
        this.markerIcon = markerIcon;
    }

    public void setMarkerSet(String markerSet) {
        this.markerSet = markerSet;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    @Nullable
    public String getWorldName() {
        return ConfigurationUtils.getWorldName(this.locationDescriptor);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public String getIcon() {
        return this.icon;
    }

    private void sendIfNotEmpty(CommandSender sender, String prefix, String value) {
        if (value != null && !value.isEmpty()) {
            sender.sendMessage(ChatColor.GOLD + prefix + ChatColor.YELLOW + value);
        }
    }

    public void describe(CommandSender sender) {
        sender.sendMessage(ChatColor.AQUA + "Warp " + ChatColor.DARK_AQUA + this.key);
        Location location = this.getLocation();
        if (location == null) {
            sender.sendMessage(ChatColor.RED + "(Unknown Location)");
        } else {
            sender.sendMessage(ChatColor.AQUA + "   " + TextUtils.printLocationAndWorld(location, 0));
        }
        if (this.isLocked()) {
            sender.sendMessage(ChatColor.RED + "(Locked)");
        }
        this.sendIfNotEmpty(sender, " Name:", this.getName());
        this.sendIfNotEmpty(sender, " Description:", this.getDescription());
        this.sendIfNotEmpty(sender, " Group:", this.getGroup());
        this.sendIfNotEmpty(sender, " Icon:", this.getIcon());
        this.sendIfNotEmpty(sender, " Marker Icon:", this.markerIcon);
        this.sendIfNotEmpty(sender, " Marker Set:", this.markerSet);
    }
}

